/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine.gamma;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.railcraft.api.carts.CartTools;
import mods.railcraft.common.blocks.machine.gamma.TileLoaderBase;
import mods.railcraft.common.carts.CartUtils;
import mods.railcraft.common.fluids.FluidItemHelper;
import mods.railcraft.common.fluids.TankManager;
import mods.railcraft.common.fluids.tanks.StandardTank;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.inventory.PhantomInventory;
import mods.railcraft.common.util.inventory.wrappers.InventoryMapper;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public abstract class TileLoaderFluidBase
extends TileLoaderBase
implements IInventory,
IFluidHandler,
ISidedInventory {
    protected static final int SLOT_INPUT = 0;
    protected static final int SLOT_OUTPUT = 1;
    protected static final int[] SLOTS = InvTools.buildSlotArray(0, 2);
    protected static final int CAPACITY = 32000;
    protected final PhantomInventory invFilter = new PhantomInventory(1);
    protected final IInventory invInput = new InventoryMapper(this, 0, 1);
    protected final TankManager tankManager = new TankManager();
    protected final StandardTank loaderTank = new StandardTank(32000, this);
    protected int flow = 0;

    protected TileLoaderFluidBase() {
        this.setInventorySize(2);
        this.tankManager.add(this.loaderTank);
    }

    public TankManager getTankManager() {
        return this.tankManager;
    }

    public PhantomInventory getFluidFilter() {
        return this.invFilter;
    }

    public Fluid getFilterFluid() {
        if (this.invFilter.getStackInSlot(0) != null) {
            FluidStack fluidStack = FluidItemHelper.getFluidStackInContainer(this.invFilter.getStackInSlot(0));
            return fluidStack != null ? fluidStack.getFluid() : null;
        }
        return null;
    }

    public Fluid getFluidHandled() {
        Fluid fluid = this.getFilterFluid();
        if (fluid != null) {
            return fluid;
        }
        return this.loaderTank.getFluidType();
    }

    @Override
    public boolean isProcessing() {
        return this.flow > 0;
    }

    @Override
    protected void sendCart(EntityMinecart cart) {
        if (cart == null) {
            return;
        }
        if (this.isManualMode()) {
            return;
        }
        if (CartTools.cartVelocityIsLessThan(cart, 0.02f)) {
            this.flow = 0;
            this.setPowered(true);
        }
    }

    @Override
    protected void setPowered(boolean p) {
        if (this.isManualMode()) {
            p = false;
        }
        super.setPowered(p);
    }

    @Override
    public boolean canHandleCart(EntityMinecart cart) {
        if (this.isSendCartGateAction()) {
            return false;
        }
        if (!(cart instanceof IFluidHandler)) {
            return false;
        }
        ItemStack minecartSlot1 = this.getCartFilters().getStackInSlot(0);
        ItemStack minecartSlot2 = this.getCartFilters().getStackInSlot(1);
        return minecartSlot1 == null && minecartSlot2 == null || CartUtils.doesCartMatchFilter(minecartSlot1, cart) || CartUtils.doesCartMatchFilter(minecartSlot2, cart);
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (Game.isHost(this.getWorld()) && this.clock % 128 == 0) {
            this.sendUpdateToClient();
        }
    }

    @Override
    public boolean isItemValidForSlot(int slot, ItemStack stack) {
        return slot != 1;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.tankManager.fill(from, resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.tankManager.drain(from, maxDrain, doDrain);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.tankManager.drain(from, resource, doDrain);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection dir) {
        return this.tankManager.getTankInfo();
    }

    public int[] getAccessibleSlotsFromSide(int side) {
        return SLOTS;
    }

    public boolean canInsertItem(int slot, ItemStack stack, int side) {
        return this.isItemValidForSlot(slot, stack);
    }

    public boolean canExtractItem(int slot, ItemStack stack, int side) {
        return slot == 1;
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        if (data.getTag("tanks") instanceof NBTTagCompound) {
            data.setTag("tanks", (NBTBase)new NBTTagList());
        }
        this.tankManager.readTanksFromNBT(data);
        if (data.hasKey("filter")) {
            NBTTagCompound filter = data.getCompoundTag("filter");
            this.getFluidFilter().readFromNBT("Items", filter);
        } else {
            this.getFluidFilter().readFromNBT("invFilter", data);
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        this.tankManager.writeTanksToNBT(data);
        this.getFluidFilter().writeToNBT("invFilter", data);
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        this.tankManager.writePacketData(data);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.tankManager.readPacketData(data);
    }
}

