/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine.gamma;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.railcraft.common.blocks.machine.gamma.TileLoaderBase;
import mods.railcraft.common.carts.CartUtils;
import mods.railcraft.common.gui.buttons.IButtonTextureSet;
import mods.railcraft.common.gui.buttons.IMultiButtonState;
import mods.railcraft.common.gui.buttons.MultiButtonController;
import mods.railcraft.common.gui.buttons.StandardButtonTextureSets;
import mods.railcraft.common.gui.tooltips.ToolTip;
import mods.railcraft.common.plugins.forge.LocalizationPlugin;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.inventory.PhantomInventory;
import mods.railcraft.common.util.network.IGuiReturnHandler;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public abstract class TileLoaderItemBase
extends TileLoaderBase
implements IGuiReturnHandler,
ISidedInventory {
    protected static final int[] SLOTS = InvTools.buildSlotArray(0, 9);
    private final PhantomInventory invFilters = new PhantomInventory(9, this);
    private final MultiButtonController<EnumTransferMode> transferModeController = new MultiButtonController(EnumTransferMode.ALL.ordinal(), (IMultiButtonState[])EnumTransferMode.values());
    private final MultiButtonController<EnumRedstoneMode> redstoneModeController = new MultiButtonController(0, (IMultiButtonState[])this.getValidRedstoneModes());
    protected boolean movedItemCart = false;

    public MultiButtonController<EnumTransferMode> getTransferModeController() {
        return this.transferModeController;
    }

    public EnumRedstoneMode[] getValidRedstoneModes() {
        return EnumRedstoneMode.values();
    }

    public MultiButtonController<EnumRedstoneMode> getRedstoneModeController() {
        return this.redstoneModeController;
    }

    public final PhantomInventory getItemFilters() {
        return this.invFilters;
    }

    public abstract Slot getBufferSlot(int var1, int var2, int var3);

    public int[] getAccessibleSlotsFromSide(int side) {
        return SLOTS;
    }

    public boolean canInsertItem(int slot, ItemStack stack, int side) {
        return this.isItemValidForSlot(slot, stack);
    }

    @Override
    protected void setPowered(boolean p) {
        if (!this.isSendCartGateAction() && this.redstoneModeController.getButtonState() == EnumRedstoneMode.MANUAL) {
            super.setPowered(false);
            return;
        }
        super.setPowered(p);
    }

    @Override
    public boolean canHandleCart(EntityMinecart cart) {
        if (this.isSendCartGateAction()) {
            return false;
        }
        if (!(cart instanceof IInventory)) {
            return false;
        }
        IInventory cartInv = (IInventory)cart;
        if (cartInv.getSizeInventory() <= 0) {
            return false;
        }
        ItemStack minecartSlot1 = this.getCartFilters().getStackInSlot(0);
        ItemStack minecartSlot2 = this.getCartFilters().getStackInSlot(1);
        return minecartSlot1 == null && minecartSlot2 == null || CartUtils.doesCartMatchFilter(minecartSlot1, cart) || CartUtils.doesCartMatchFilter(minecartSlot2, cart);
    }

    @Override
    public boolean isProcessing() {
        return this.movedItemCart;
    }

    @Override
    public boolean isManualMode() {
        return this.redstoneModeController.getButtonState() == EnumRedstoneMode.MANUAL;
    }

    public final EnumTransferMode getMode() {
        return this.transferModeController.getButtonState();
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeByte(this.transferModeController.getCurrentState());
        data.writeByte(this.redstoneModeController.getCurrentState());
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.transferModeController.setCurrentState(data.readByte());
        this.redstoneModeController.setCurrentState(data.readByte());
    }

    @Override
    public void writeGuiData(DataOutputStream data) throws IOException {
        data.writeByte(this.transferModeController.getCurrentState());
        data.writeByte(this.redstoneModeController.getCurrentState());
    }

    @Override
    public void readGuiData(DataInputStream data, EntityPlayer sender) throws IOException {
        this.transferModeController.setCurrentState(data.readByte());
        this.redstoneModeController.setCurrentState(data.readByte());
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        this.transferModeController.writeToNBT(data, "mode");
        this.redstoneModeController.writeToNBT(data, "redstone");
        this.getItemFilters().writeToNBT("invFilters", data);
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.transferModeController.readFromNBT(data, "mode");
        this.redstoneModeController.readFromNBT(data, "redstone");
        if (data.getBoolean("waitTillComplete")) {
            this.redstoneModeController.setCurrentState(EnumRedstoneMode.COMPLETE.ordinal());
        }
        if (data.hasKey("filters")) {
            NBTTagCompound filters = data.getCompoundTag("filters");
            this.getItemFilters().readFromNBT("Items", filters);
        } else {
            this.getItemFilters().readFromNBT("invFilters", data);
        }
    }

    public static enum EnumRedstoneMode implements IMultiButtonState
    {
        IMMEDIATE("railcraft.gui.item.loader.immediate"),
        COMPLETE("railcraft.gui.item.loader.complete"),
        MANUAL("railcraft.gui.item.loader.manual"),
        PARTIAL("railcraft.gui.item.loader.partial");

        private final String label;
        private final ToolTip tip;

        private EnumRedstoneMode(String label) {
            this.label = label;
            this.tip = ToolTip.buildToolTip(label + ".tip", new String[0]);
        }

        @Override
        public String getLabel() {
            return LocalizationPlugin.translate(this.label);
        }

        @Override
        public StandardButtonTextureSets getTextureSet() {
            return StandardButtonTextureSets.SMALL_BUTTON;
        }

        @Override
        public ToolTip getToolTip() {
            return this.tip;
        }
    }

    public static enum EnumTransferMode implements IMultiButtonState
    {
        TRANSFER("railcraft.gui.item.loader.transfer"),
        STOCK("railcraft.gui.item.loader.stock"),
        EXCESS("railcraft.gui.item.loader.excess"),
        ALL("railcraft.gui.item.loader.all");

        private final String label;
        private final ToolTip tip;

        private EnumTransferMode(String label) {
            this.label = label;
            this.tip = ToolTip.buildToolTip(label + ".tip", new String[0]);
        }

        @Override
        public String getLabel() {
            return LocalizationPlugin.translate(this.label);
        }

        @Override
        public IButtonTextureSet getTextureSet() {
            return StandardButtonTextureSets.SMALL_BUTTON;
        }

        @Override
        public ToolTip getToolTip() {
            return this.tip;
        }
    }
}

