/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine.gamma;

import cofh.api.energy.IEnergyReceiver;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.railcraft.api.carts.CartTools;
import mods.railcraft.common.blocks.machine.IEnumMachine;
import mods.railcraft.common.blocks.machine.gamma.EnumMachineGamma;
import mods.railcraft.common.blocks.machine.gamma.TileRFLoaderBase;
import mods.railcraft.common.carts.EntityCartRF;
import mods.railcraft.common.gui.EnumGui;
import mods.railcraft.common.gui.GuiHandler;
import mods.railcraft.common.util.network.IGuiReturnHandler;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class TileRFLoader
extends TileRFLoaderBase
implements IGuiReturnHandler,
IEnergyReceiver {
    private boolean waitTillFull = true;
    private boolean waitIfEmpty = true;

    @Override
    public IEnumMachine getMachineType() {
        return EnumMachineGamma.RF_LOADER;
    }

    @Override
    public boolean openGui(EntityPlayer player) {
        GuiHandler.openGui(EnumGui.LOADER_RF, player, this.worldObj, this.xCoord, this.yCoord, this.zCoord);
        return true;
    }

    @Override
    protected boolean processCart() {
        boolean transferred = false;
        EntityMinecart cart = CartTools.getMinecartOnSide(this.worldObj, this.xCoord, this.yCoord, this.zCoord, 0.1f, this.direction);
        if (cart != this.currentCart) {
            this.setPowered(false);
            this.currentCart = cart;
            this.cartWasSent();
        }
        if (cart == null) {
            return false;
        }
        if (!this.canHandleCart(cart)) {
            this.sendCart(cart);
            return false;
        }
        if (this.isPaused()) {
            return false;
        }
        EntityCartRF rfCart = (EntityCartRF)cart;
        if (this.amountRF > 0 && rfCart.getRF() < rfCart.getMaxRF()) {
            int used;
            int injection = 8000;
            if (injection > this.amountRF) {
                injection = this.amountRF;
            }
            if ((used = rfCart.addRF(injection)) > 0) {
                this.amountRF -= used;
                transferred = true;
            }
        }
        if (!transferred && !this.isPowered() && this.shouldSendCart(cart)) {
            this.sendCart(cart);
        }
        return transferred;
    }

    @Override
    protected boolean shouldSendCart(EntityMinecart cart) {
        if (!(cart instanceof EntityCartRF)) {
            return true;
        }
        EntityCartRF energyCart = (EntityCartRF)cart;
        if (!this.waitTillFull && energyCart.getRF() > 0) {
            return true;
        }
        if (!this.waitIfEmpty && !this.waitTillFull && energyCart.getRF() == 0) {
            return true;
        }
        return energyCart.getRF() >= energyCart.getMaxRF();
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.setBoolean("WaitIfEmpty", this.waitIfEmpty());
        nbttagcompound.setBoolean("WaitTillFull", this.waitTillFull());
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.setWaitIfEmpty(nbttagcompound.getBoolean("WaitIfEmpty"));
        this.setWaitTillFull(nbttagcompound.getBoolean("WaitTillFull"));
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        byte bits = 0;
        bits = (byte)(bits | (this.waitIfEmpty ? 1 : 0));
        bits = (byte)(bits | (this.waitTillFull ? 2 : 0));
        data.writeByte(bits);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        byte bits = data.readByte();
        this.waitIfEmpty = (bits & 1) != 0;
        this.waitTillFull = (bits & 2) != 0;
    }

    @Override
    public void writeGuiData(DataOutputStream data) throws IOException {
        data.writeBoolean(this.waitIfEmpty);
        data.writeBoolean(this.waitTillFull);
    }

    @Override
    public void readGuiData(DataInputStream data, EntityPlayer sender) throws IOException {
        this.waitIfEmpty = data.readBoolean();
        this.waitTillFull = data.readBoolean();
    }

    public boolean waitTillFull() {
        return this.waitTillFull;
    }

    public void setWaitTillFull(boolean waitTillFull) {
        this.waitTillFull = waitTillFull;
    }

    public boolean waitIfEmpty() {
        return this.waitIfEmpty;
    }

    public void setWaitIfEmpty(boolean waitIfEmpty) {
        this.waitIfEmpty = waitIfEmpty;
    }

    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return this.addRF(maxReceive, simulate);
    }

    public int getEnergyStored(ForgeDirection from) {
        return this.amountRF;
    }

    public int getMaxEnergyStored(ForgeDirection from) {
        return this.getMaxRF();
    }

    public boolean canConnectEnergy(ForgeDirection from) {
        return true;
    }
}

