/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine.gamma;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.railcraft.common.blocks.machine.gamma.TileLoaderBase;
import mods.railcraft.common.carts.EntityCartRF;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.misc.MiscTools;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileRFLoaderBase
extends TileLoaderBase {
    protected static final int TRANSFER_RATE = 8000;
    protected static final int TRANSFER_FADE = 20;
    private static final int RF_CAP = 4000000;
    protected int amountRF;
    protected ForgeDirection direction = ForgeDirection.NORTH;
    private int ticksSinceTransfer;

    public TileRFLoaderBase() {
        this.setInventorySize(0);
    }

    @Override
    public IIcon getIcon(int side) {
        if (side == this.direction.ordinal()) {
            return this.getMachineType().getTexture(this.isProcessing() ? 7 : 8);
        }
        return this.getMachineType().getTexture(this.isProcessing() ? 0 : 6);
    }

    @Override
    public void onBlockPlacedBy(EntityLivingBase entityliving, ItemStack stack) {
        super.onBlockPlacedBy(entityliving, stack);
        this.direction = MiscTools.getSideFacingTrack(this.worldObj, this.xCoord, this.yCoord, this.zCoord);
        if (this.direction == ForgeDirection.UNKNOWN) {
            this.direction = MiscTools.getSideClosestToPlayer(this.worldObj, this.xCoord, this.yCoord, this.zCoord, entityliving);
        }
    }

    @Override
    public boolean isManualMode() {
        return false;
    }

    @Override
    public boolean canHandleCart(EntityMinecart cart) {
        return !this.isSendCartGateAction() && cart instanceof EntityCartRF;
    }

    @Override
    public boolean isProcessing() {
        return this.ticksSinceTransfer > 0;
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (Game.isNotHost(this.getWorld())) {
            return;
        }
        int capacity = this.getMaxRF();
        if (this.amountRF > capacity) {
            this.amountRF = capacity;
        }
        boolean wasProcessing = this.isProcessing();
        if (this.processCart()) {
            this.ticksSinceTransfer = 20;
        } else if (this.ticksSinceTransfer > 0) {
            --this.ticksSinceTransfer;
        }
        if (this.isProcessing() != wasProcessing) {
            this.sendUpdateToClient();
        }
    }

    protected abstract boolean processCart();

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.setInteger("rf", this.amountRF);
        data.setByte("direction", (byte)this.direction.ordinal());
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.amountRF = data.getInteger("rf");
        this.direction = ForgeDirection.getOrientation((int)data.getByte("direction"));
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeByte(this.direction.ordinal());
        data.writeBoolean(this.isProcessing());
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.direction = ForgeDirection.getOrientation((int)data.readByte());
        boolean transfer = data.readBoolean();
        if (this.isProcessing() != transfer) {
            this.ticksSinceTransfer = transfer ? 20 : 0;
            this.markBlockForUpdate();
        }
    }

    @Override
    public boolean rotateBlock(ForgeDirection axis) {
        this.direction = this.direction == axis ? axis.getOpposite() : axis;
        this.markBlockForUpdate();
        return true;
    }

    public int addRF(int rf, boolean simulate) {
        if (rf <= 0) {
            return 0;
        }
        if (this.amountRF >= 4000000) {
            return 0;
        }
        if (4000000 - this.amountRF >= rf) {
            if (!simulate) {
                this.amountRF += rf;
            }
            return rf;
        }
        int used = 4000000 - this.amountRF;
        if (!simulate) {
            this.amountRF = 4000000;
        }
        return used;
    }

    public int removeRF(int request, boolean simulate) {
        if (request <= 0) {
            return 0;
        }
        if (this.amountRF >= request) {
            if (!simulate) {
                this.amountRF -= request;
            }
            return request;
        }
        int ret = this.amountRF;
        if (!simulate) {
            this.amountRF = 0;
        }
        return ret;
    }

    public int getRF() {
        return this.amountRF;
    }

    public void setRF(int energy) {
        this.amountRF = energy;
    }

    public int getMaxRF() {
        return 4000000;
    }
}

