/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine.tank;

import mods.railcraft.common.blocks.machine.IEnumMachine;
import mods.railcraft.common.blocks.machine.beta.MetalTank;
import mods.railcraft.common.blocks.machine.beta.TileTankIronValve;
import mods.railcraft.common.modules.ModuleAdvancedTanks;
import net.minecraft.nbt.NBTTagCompound;

public class TileGenericMultiTankValve
extends TileTankIronValve {
    private MetalTank tankType;
    private IEnumMachine valveType;

    public TileGenericMultiTankValve() {
    }

    public TileGenericMultiTankValve(MetalTank thisTankType, IEnumMachine thisValveType) {
        this.tankType = thisTankType;
        this.valveType = thisValveType;
        this.markDirty();
    }

    @Override
    public IEnumMachine getMachineType() {
        return this.valveType;
    }

    @Override
    public MetalTank getTankType() {
        return this.tankType;
    }

    @Override
    public int getCapacityPerBlock() {
        return this.valveType.getCapacity();
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        if (this.valveType != null && !data.hasKey("Machine.Type")) {
            data.setString("Machine.Type", this.valveType.getTag());
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        this.valveType = ModuleAdvancedTanks.cacheTankType.get(data.getString("Machine.Type"));
        this.tankType = ModuleAdvancedTanks.cacheTankMaterial.get(data.getString("Machine.Type"));
        super.readFromNBT(data);
    }
}

