/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine.zeta;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import mods.railcraft.client.util.textures.TextureAtlasSheet;
import mods.railcraft.common.blocks.RailcraftBlocks;
import mods.railcraft.common.blocks.machine.IEnumMachine;
import mods.railcraft.common.blocks.machine.TileMachineBase;
import mods.railcraft.common.blocks.machine.beta.MetalTank;
import mods.railcraft.common.blocks.machine.tank.GenericMultiTankBase;
import mods.railcraft.common.blocks.machine.tank.TileGenericMultiTankGauge;
import mods.railcraft.common.blocks.machine.tank.TileGenericMultiTankValve;
import mods.railcraft.common.blocks.machine.tank.TileGenericMultiTankWall;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.gui.tooltips.ToolTip;
import mods.railcraft.common.modules.ModuleManager;
import mods.railcraft.common.plugins.forge.LocalizationPlugin;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;

public enum EnumMachineEta implements IEnumMachine
{
    TANK_IRIDIUM_WALL(ModuleManager.Module.ADVTANKS, "tank.iridium.wall", 32786000, TileGenericMultiTankWall.class, 2, 1, 0, 0, 1, 1, 1, 1),
    TANK_IRIDIUM_GAUGE(ModuleManager.Module.ADVTANKS, "tank.iridium.gauge", 32786000, TileGenericMultiTankGauge.class, 1, 5, 0, 0, 0, 0, 0, 0, 1, 2, 3, 4),
    TANK_IRIDIUM_VALVE(ModuleManager.Module.ADVTANKS, "tank.iridium.valve", 32786000, TileGenericMultiTankValve.class, 4, 1, 0, 0, 1, 1, 1, 1, 2, 3),
    TANK_OSMIUM_WALL(ModuleManager.Module.ADVTANKS, "tank.osmium.wall", 131720000, TileGenericMultiTankWall.class, 2, 1, 0, 0, 1, 1, 1, 1),
    TANK_OSMIUM_GAUGE(ModuleManager.Module.ADVTANKS, "tank.osmium.gauge", 131720000, TileGenericMultiTankGauge.class, 1, 5, 0, 0, 0, 0, 0, 0, 1, 2, 3, 4),
    TANK_OSMIUM_VALVE(ModuleManager.Module.ADVTANKS, "tank.osmium.valve", 131720000, TileGenericMultiTankValve.class, 4, 1, 0, 0, 1, 1, 1, 1, 2, 3),
    TANK_NEUTRONIUM_WALL(ModuleManager.Module.ADVTANKS, "tank.neutronium.wall", 524288000, TileGenericMultiTankWall.class, 2, 1, 0, 0, 1, 1, 1, 1),
    TANK_NEUTRONIUM_GAUGE(ModuleManager.Module.ADVTANKS, "tank.neutronium.gauge", 524288000, TileGenericMultiTankGauge.class, 1, 5, 0, 0, 0, 0, 0, 0, 1, 2, 3, 4),
    TANK_NEUTRONIUM_VALVE(ModuleManager.Module.ADVTANKS, "tank.neutronium.valve", 524288000, TileGenericMultiTankValve.class, 4, 1, 0, 0, 1, 1, 1, 1, 2, 3);

    private final ModuleManager.Module module;
    private final String tag;
    private final int capacity;
    private GenericMultiTankBase tankType;
    private final Class<? extends TileMachineBase> tile;
    private IIcon[] texture = new IIcon[12];
    private final int[] textureInfo;
    private static final List<EnumMachineEta> creativeList;
    private static final EnumMachineEta[] VALUES;
    private ToolTip tip;

    private EnumMachineEta(ModuleManager.Module module, String tag, int cap, Class<? extends TileMachineBase> tile, int ... textureInfo) {
        this.module = module;
        this.tile = tile;
        this.tag = tag;
        this.capacity = cap;
        this.textureInfo = textureInfo;
    }

    public boolean register() {
        if (RailcraftConfig.isSubBlockEnabled(this.getTag())) {
            RailcraftBlocks.registerBlockMachineEta();
            return this.getBlock() != null;
        }
        return false;
    }

    public void setTankType(GenericMultiTankBase tankMaterial) {
        this.tankType = tankMaterial;
    }

    @Override
    public int getCapacity() {
        return this.capacity;
    }

    @Override
    public boolean isDepreciated() {
        return this.module == null;
    }

    public void setTexture(IIcon[] tex) {
        this.texture = tex;
    }

    public IIcon[] getTexture() {
        return this.texture;
    }

    @Override
    public IIcon getTexture(int index) {
        if (index < 0 || index >= this.texture.length) {
            index = 0;
        }
        return this.texture[index];
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerIcons(IIconRegister iconRegister) {
        for (EnumMachineEta machine : VALUES) {
            if (machine.isDepreciated()) continue;
            machine.texture = new IIcon[machine.textureInfo.length - 2];
            int columns = machine.textureInfo[0];
            int rows = machine.textureInfo[1];
            IIcon[] icons = TextureAtlasSheet.unstitchIcons(iconRegister, "railcraft:" + machine.tag, columns, rows);
            for (int i = 0; i < machine.texture.length; ++i) {
                machine.texture[i] = icons[machine.textureInfo[i + 2]];
            }
        }
    }

    public static EnumMachineEta fromId(int id) {
        if (id < 0 || id >= VALUES.length) {
            id = 0;
        }
        return VALUES[id];
    }

    public static List<EnumMachineEta> getCreativeList() {
        return creativeList;
    }

    @Override
    public String getTag() {
        return "tile.railcraft.machine.eta." + this.tag;
    }

    @Override
    public Class getTileClass() {
        return this.tile;
    }

    @Override
    public TileMachineBase getTileEntity() {
        try {
            Constructor<? extends TileMachineBase> cons = this.tile.getDeclaredConstructor(MetalTank.class, IEnumMachine.class);
            return cons.newInstance(this.tankType, this);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    @Override
    public ItemStack getItem() {
        return this.getItem(1);
    }

    @Override
    public ItemStack getItem(int qty) {
        Block block = this.getBlock();
        if (block == null) {
            return null;
        }
        return new ItemStack(block, qty, this.ordinal());
    }

    public ModuleManager.Module getModule() {
        return this.module;
    }

    @Override
    public Block getBlock() {
        return RailcraftBlocks.getBlockMachineEta();
    }

    public boolean isEnabled() {
        return ModuleManager.isModuleLoaded(this.getModule()) && RailcraftConfig.isSubBlockEnabled(this.getTag());
    }

    @Override
    public boolean isAvaliable() {
        return this.getBlock() != null && this.isEnabled();
    }

    @Override
    public ToolTip getToolTip(ItemStack stack, EntityPlayer player, boolean adv) {
        if (this.tip != null) {
            return this.tip;
        }
        String tipTag = this.getTag() + ".tip";
        if (LocalizationPlugin.hasTag(tipTag)) {
            this.tip = ToolTip.buildToolTip(tipTag, new String[0]);
        }
        return this.tip;
    }

    static {
        creativeList = new ArrayList<EnumMachineEta>();
        VALUES = EnumMachineEta.values();
        creativeList.add(TANK_IRIDIUM_WALL);
        creativeList.add(TANK_IRIDIUM_GAUGE);
        creativeList.add(TANK_IRIDIUM_VALVE);
        creativeList.add(TANK_OSMIUM_WALL);
        creativeList.add(TANK_OSMIUM_GAUGE);
        creativeList.add(TANK_OSMIUM_VALVE);
        creativeList.add(TANK_NEUTRONIUM_WALL);
        creativeList.add(TANK_NEUTRONIUM_GAUGE);
        creativeList.add(TANK_NEUTRONIUM_VALVE);
    }
}

