/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.ore;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import mods.railcraft.client.particles.ParticleHelper;
import mods.railcraft.client.particles.ParticleHelperCallback;
import mods.railcraft.common.blocks.aesthetics.cube.EnumCube;
import mods.railcraft.common.blocks.ore.EnumOre;
import mods.railcraft.common.blocks.ore.ItemOre;
import mods.railcraft.common.carts.EntityTunnelBore;
import mods.railcraft.common.core.Railcraft;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.items.ItemDust;
import mods.railcraft.common.items.Metal;
import mods.railcraft.common.items.RailcraftItem;
import mods.railcraft.common.plugins.forestry.ForestryPlugin;
import mods.railcraft.common.plugins.forge.CraftingPlugin;
import mods.railcraft.common.plugins.forge.CreativePlugin;
import mods.railcraft.common.plugins.forge.HarvestPlugin;
import mods.railcraft.common.plugins.forge.RailcraftRegistry;
import mods.railcraft.common.util.misc.MiscTools;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.particle.EntityDiggingFX;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.oredict.OreDictionary;

public class BlockOre
extends Block {
    private static final ParticleHelperCallback callback = new ParticleCallback();
    public static int renderPass;
    private static BlockOre instance;
    private final int renderType;
    private final Random rand = new Random();

    public BlockOre(int renderId) {
        super(Material.rock);
        this.renderType = renderId;
        this.setBlockName("railcraft.ore");
        this.setResistance(5.0f);
        this.setHardness(3.0f);
        this.setStepSound(Block.soundTypeStone);
        this.setCreativeTab(CreativePlugin.RAILCRAFT_TAB);
    }

    public static BlockOre getBlock() {
        return instance;
    }

    public static void registerBlock() {
        if (instance == null && RailcraftConfig.isBlockEnabled("ore")) {
            int renderId = Railcraft.getProxy().getRenderId();
            instance = new BlockOre(renderId);
            RailcraftRegistry.register(instance, ItemOre.class);
            EntityTunnelBore.addMineableBlock(instance);
            block4: for (EnumOre ore : EnumOre.values()) {
                ForestryPlugin.addBackpackItem("miner", ore.getItem());
                switch (ore) {
                    case FIRESTONE: {
                        HarvestPlugin.setHarvestLevel(instance, ore.ordinal(), "pickaxe", 3);
                        continue block4;
                    }
                    case DARK_LAPIS: 
                    case POOR_IRON: 
                    case POOR_TIN: 
                    case POOR_COPPER: {
                        HarvestPlugin.setHarvestLevel(instance, ore.ordinal(), "pickaxe", 1);
                        continue block4;
                    }
                    default: {
                        HarvestPlugin.setHarvestLevel(instance, ore.ordinal(), "pickaxe", 2);
                    }
                }
            }
            RailcraftItem.dust.registerItem();
            BlockOre.registerOre("oreSulfur", EnumOre.SULFUR);
            BlockOre.registerOre("oreSaltpeter", EnumOre.SALTPETER);
            BlockOre.registerOre("oreDiamond", EnumOre.DARK_DIAMOND);
            BlockOre.registerOre("oreEmerald", EnumOre.DARK_EMERALD);
            BlockOre.registerOre("oreLapis", EnumOre.DARK_LAPIS);
            BlockOre.registerOre("oreFirestone", EnumOre.FIRESTONE);
            BlockOre.registerOre("orePoorCopper", EnumOre.POOR_COPPER);
            BlockOre.registerOre("orePoorGold", EnumOre.POOR_GOLD);
            BlockOre.registerOre("orePoorIron", EnumOre.POOR_IRON);
            BlockOre.registerOre("orePoorTin", EnumOre.POOR_TIN);
            BlockOre.registerOre("orePoorLead", EnumOre.POOR_LEAD);
            BlockOre.registerPoorOreRecipe(Metal.COPPER);
            BlockOre.registerPoorOreRecipe(Metal.GOLD);
            BlockOre.registerPoorOreRecipe(Metal.IRON);
            BlockOre.registerPoorOreRecipe(Metal.TIN);
            BlockOre.registerPoorOreRecipe(Metal.LEAD);
        }
    }

    private static void registerPoorOreRecipe(Metal metal) {
        CraftingPlugin.addFurnaceRecipe(metal.getPoorOre(), metal.getNugget(2), 0.1f);
    }

    private static void registerOre(String name, EnumOre ore) {
        if (!ore.isDepecriated() && ore.isEnabled()) {
            OreDictionary.registerOre((String)name, (ItemStack)ore.getItem());
        }
    }

    public int getRenderType() {
        return this.renderType;
    }

    public void getSubBlocks(Item item, CreativeTabs tab, List list) {
        for (EnumOre ore : EnumOre.values()) {
            if (ore.isDepecriated() || !ore.isEnabled()) continue;
            list.add(ore.getItem());
        }
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z, EntityPlayer player) {
        int meta = world.getBlockMetadata(x, y, z);
        return EnumOre.fromMeta(meta).getItem();
    }

    public void dropBlockAsItemWithChance(World world, int x, int y, int z, int meta, float par6, int fortune) {
        super.dropBlockAsItemWithChance(world, x, y, z, meta, par6, fortune);
        switch (EnumOre.fromMeta(meta)) {
            case DARK_LAPIS: 
            case SULFUR: 
            case SALTPETER: 
            case DARK_DIAMOND: 
            case DARK_EMERALD: {
                int xp = MathHelper.getRandomIntegerInRange((Random)world.rand, (int)2, (int)5);
                this.dropXpOnBlockBreak(world, x, y, z, xp);
            }
        }
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int meta, int fortune) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        switch (EnumOre.fromMeta(meta)) {
            case SULFUR: {
                int qty = 2 + this.rand.nextInt(4) + this.rand.nextInt(fortune + 1);
                drops.add(RailcraftItem.dust.getStack(qty, ItemDust.EnumDust.SULFUR));
                return drops;
            }
            case SALTPETER: {
                int qty = 1 + this.rand.nextInt(2) + this.rand.nextInt(fortune + 1);
                drops.add(RailcraftItem.dust.getStack(qty, ItemDust.EnumDust.SALTPETER));
                return drops;
            }
            case DARK_DIAMOND: {
                int bonus = this.rand.nextInt(fortune + 2) - 1;
                if (bonus < 0) {
                    bonus = 0;
                }
                int qty = 1 * (bonus + 1);
                drops.add(new ItemStack(Items.diamond, qty));
                return drops;
            }
            case DARK_EMERALD: {
                int bonus = this.rand.nextInt(fortune + 2) - 1;
                if (bonus < 0) {
                    bonus = 0;
                }
                int qty = 1 * (bonus + 1);
                drops.add(new ItemStack(Items.emerald, qty));
                return drops;
            }
            case DARK_LAPIS: {
                int bonus = this.rand.nextInt(fortune + 2) - 1;
                if (bonus < 0) {
                    bonus = 0;
                }
                int qty = (4 + this.rand.nextInt(5)) * (bonus + 1);
                drops.add(new ItemStack(Items.dye, qty, 4));
                return drops;
            }
        }
        return super.getDrops(world, x, y, z, meta, fortune);
    }

    public int damageDropped(int meta) {
        return meta;
    }

    public boolean canSilkHarvest(World world, EntityPlayer player, int x, int y, int z, int metadata) {
        return true;
    }

    public void registerBlockIcons(IIconRegister iconRegister) {
        for (EnumOre ore : EnumOre.VALUES) {
            if (ore == EnumOre.WATERSTONE) continue;
            ore.setTexture(iconRegister.registerIcon("railcraft:" + MiscTools.cleanTag(ore.getTag())));
        }
    }

    public IIcon getIcon(int side, int meta) {
        if (renderPass == 0) {
            switch (EnumOre.fromMeta(meta)) {
                case SALTPETER: {
                    return Blocks.sandstone.getIcon(ForgeDirection.DOWN.ordinal(), 0);
                }
                case FIRESTONE: {
                    return Blocks.netherrack.getIcon(0, 0);
                }
                case DARK_LAPIS: 
                case DARK_DIAMOND: 
                case DARK_EMERALD: {
                    IIcon icon = EnumCube.ABYSSAL_STONE.getIcon();
                    if (icon == null) break;
                    return icon;
                }
            }
            return Blocks.stone.getIcon(side, 0);
        }
        return EnumOre.fromMeta(meta).getTexture(side);
    }

    public void setBlockBoundsForItemRender() {
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(World worldObj, MovingObjectPosition target, EffectRenderer effectRenderer) {
        return ParticleHelper.addHitEffects(worldObj, instance, target, effectRenderer, callback);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World worldObj, int x, int y, int z, int meta, EffectRenderer effectRenderer) {
        return ParticleHelper.addDestroyEffects(worldObj, instance, x, y, z, meta, effectRenderer, callback);
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        int meta = world.getBlockMetadata(x, y, z);
        if (EnumOre.FIRESTONE.ordinal() == meta) {
            return 15;
        }
        return super.getLightValue(world, x, y, z);
    }

    private static class ParticleCallback
    implements ParticleHelperCallback {
        private ParticleCallback() {
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void addHitEffects(EntityDiggingFX fx, World world, int x, int y, int z, int meta) {
            this.setTexture(fx, world, x, y, z, meta);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void addDestroyEffects(EntityDiggingFX fx, World world, int x, int y, int z, int meta) {
            this.setTexture(fx, world, x, y, z, meta);
        }

        @SideOnly(value=Side.CLIENT)
        private void setTexture(EntityDiggingFX fx, World world, int x, int y, int z, int meta) {
            renderPass = 0;
            fx.setParticleIcon(instance.getIcon(0, meta));
        }
    }
}

