/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.ore;

import java.util.List;
import mods.railcraft.common.blocks.ore.EnumOre;
import mods.railcraft.common.gui.tooltips.ToolTip;
import mods.railcraft.common.items.EntityItemFireproof;
import mods.railcraft.common.plugins.forge.LocalizationPlugin;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class ItemOre
extends ItemBlock {
    public ItemOre(Block block) {
        super(block);
        this.setMaxDamage(0);
        this.setHasSubtypes(true);
    }

    public IIcon getIconFromDamage(int meta) {
        return EnumOre.values()[meta].getTexture(meta);
    }

    public int getMetadata(int meta) {
        return meta;
    }

    public String getUnlocalizedName(ItemStack stack) {
        int damage = stack.getItemDamage();
        if (damage < 0 || damage >= EnumOre.values().length) {
            return "";
        }
        return EnumOre.values()[damage].getTag();
    }

    public void addInformation(ItemStack stack, EntityPlayer player, List info, boolean adv) {
        super.addInformation(stack, player, info, adv);
        String tipTag = EnumOre.fromMeta(stack.getItemDamage()).getTag() + ".tip";
        if (LocalizationPlugin.hasTag(tipTag)) {
            ToolTip tip = ToolTip.buildToolTip(tipTag, new String[0]);
            info.addAll(tip.convertToStrings());
        }
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return stack != null && stack.getItemDamage() == EnumOre.FIRESTONE.ordinal();
    }

    public Entity createEntity(World world, Entity location, ItemStack stack) {
        if (!this.hasCustomEntity(stack)) {
            return null;
        }
        EntityItemFireproof entity = new EntityItemFireproof(world, location.posX, location.posY, location.posZ, stack);
        entity.motionX = location.motionX;
        entity.motionY = location.motionY;
        entity.motionZ = location.motionZ;
        entity.delayBeforeCanPickup = 10;
        return entity;
    }
}

