/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.signals;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.railcraft.api.signals.SignalAspect;
import mods.railcraft.common.blocks.signals.EnumSignal;
import mods.railcraft.common.blocks.signals.TileBoxBase;
import mods.railcraft.common.gui.EnumGui;
import mods.railcraft.common.gui.GuiHandler;
import mods.railcraft.common.gui.buttons.IButtonTextureSet;
import mods.railcraft.common.gui.buttons.IMultiButtonState;
import mods.railcraft.common.gui.buttons.MultiButtonController;
import mods.railcraft.common.gui.buttons.StandardButtonTextureSets;
import mods.railcraft.common.gui.tooltips.ToolTip;
import mods.railcraft.common.plugins.forge.LocalizationPlugin;
import mods.railcraft.common.plugins.forge.PowerPlugin;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.misc.MiscTools;
import mods.railcraft.common.util.network.IGuiReturnHandler;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TileBoxCapacitor
extends TileBoxBase
implements IGuiReturnHandler {
    private short ticksPowered;
    public short ticksToPower = (short)200;
    private SignalAspect aspect = SignalAspect.OFF;
    private final MultiButtonController<EnumStateMode> stateModeController = new MultiButtonController(EnumStateMode.IMMEDIATE.ordinal(), (IMultiButtonState[])EnumStateMode.values());

    public MultiButtonController<EnumStateMode> getStateModeController() {
        return this.stateModeController;
    }

    @Override
    public EnumSignal getSignalType() {
        return EnumSignal.BOX_CAPACITOR;
    }

    @Override
    public boolean blockActivated(int side, EntityPlayer player) {
        if (player.isSneaking()) {
            return false;
        }
        GuiHandler.openGui(EnumGui.BOX_CAPACITOR, player, this.worldObj, this.xCoord, this.yCoord, this.zCoord);
        return true;
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (Game.isNotHost(this.worldObj)) {
            return;
        }
        if (this.ticksPowered > 0) {
            this.ticksPowered = (short)(this.ticksPowered - 1);
            if (this.stateModeController.getButtonState().equals(EnumStateMode.DELAYED)) {
                SignalAspect tmpaspect = SignalAspect.GREEN;
                Boolean hasInput = false;
                if (PowerPlugin.isBlockBeingPoweredByRepeater(this.worldObj, this.xCoord, this.yCoord, this.zCoord)) {
                    hasInput = true;
                }
                for (int side = 2; side < 6; ++side) {
                    TileBoxBase box;
                    ForgeDirection forgeSide = ForgeDirection.getOrientation((int)side);
                    TileEntity tile = this.tileCache.getTileOnSide(forgeSide);
                    if (!(tile instanceof TileBoxBase) || !(box = (TileBoxBase)tile).isEmittingRedstone(forgeSide.getOpposite())) continue;
                    hasInput = true;
                    tmpaspect = SignalAspect.mostRestrictive(tmpaspect, box.getBoxSignalAspect(forgeSide.getOpposite()));
                }
                if (hasInput.booleanValue()) {
                    this.ticksPowered = this.ticksToPower;
                    if (!this.aspect.equals((Object)tmpaspect)) {
                        this.aspect = tmpaspect;
                        this.updateNeighbors();
                    }
                }
            }
            if (this.ticksPowered <= 0) {
                this.updateNeighbors();
            }
        }
    }

    @Override
    public void onNeighborBlockChange(Block block) {
        super.onNeighborBlockChange(block);
        if (this.worldObj.isRemote) {
            return;
        }
        boolean p = PowerPlugin.isBlockBeingPoweredByRepeater(this.worldObj, this.xCoord, this.yCoord, this.zCoord);
        if (this.ticksPowered <= 0 && p) {
            this.ticksPowered = this.ticksToPower;
            if (this.stateModeController.getButtonState().equals(EnumStateMode.IMMEDIATE)) {
                this.aspect = SignalAspect.GREEN;
            }
            this.updateNeighbors();
        }
    }

    @Override
    public void onNeighborStateChange(TileBoxBase neighbor, ForgeDirection side) {
        if (neighbor.isEmittingRedstone(side)) {
            this.ticksPowered = this.ticksToPower;
            if (this.stateModeController.getButtonState().equals(EnumStateMode.IMMEDIATE)) {
                this.aspect = neighbor.getBoxSignalAspect(side);
            }
            this.updateNeighbors();
        }
    }

    private void updateNeighbors() {
        this.sendUpdateToClient();
        this.notifyBlocksOfNeighborChange();
        this.updateNeighborBoxes();
    }

    @Override
    public int getPowerOutput(int side) {
        TileEntity tile = this.tileCache.getTileOnSide(MiscTools.getOppositeSide(side));
        if (tile instanceof TileBoxBase) {
            return 0;
        }
        return this.ticksPowered > 0 ? 15 : 0;
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.setShort("ticksPowered", this.ticksPowered);
        data.setShort("ticksToPower", this.ticksToPower);
        data.setByte("aspect", (byte)this.aspect.ordinal());
        this.stateModeController.writeToNBT(data, "mode");
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.ticksPowered = data.getShort("ticksPowered");
        this.ticksToPower = data.getShort("ticksToPower");
        this.aspect = SignalAspect.values()[data.getByte("aspect")];
        if (data.hasKey("mode")) {
            this.stateModeController.readFromNBT(data, "mode");
        } else {
            this.stateModeController.setCurrentState(EnumStateMode.IMMEDIATE.ordinal());
        }
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeBoolean(this.ticksPowered > 0);
        data.writeShort(this.ticksToPower);
        data.writeByte(this.aspect.ordinal());
        data.writeByte(this.stateModeController.getCurrentState());
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.ticksPowered = (short)(data.readBoolean() ? 1 : 0);
        this.ticksToPower = data.readShort();
        this.aspect = SignalAspect.values()[data.readByte()];
        this.stateModeController.setCurrentState(data.readByte());
        this.markBlockForUpdate();
    }

    @Override
    public void writeGuiData(DataOutputStream data) throws IOException {
        data.writeShort(this.ticksToPower);
        data.writeByte(this.stateModeController.getCurrentState());
    }

    @Override
    public void readGuiData(DataInputStream data, EntityPlayer sender) throws IOException {
        this.ticksToPower = data.readShort();
        this.stateModeController.setCurrentState(data.readByte());
    }

    @Override
    public boolean isConnected(ForgeDirection side) {
        TileEntity tile = this.tileCache.getTileOnSide(side);
        if (tile instanceof TileBoxBase) {
            return ((TileBoxBase)tile).canTransferAspect() || ((TileBoxBase)tile).canReceiveAspect();
        }
        return false;
    }

    @Override
    public SignalAspect getBoxSignalAspect(ForgeDirection side) {
        return this.ticksPowered > 0 ? this.aspect : SignalAspect.RED;
    }

    @Override
    public boolean canReceiveAspect() {
        return true;
    }

    @Override
    public boolean canTransferAspect() {
        return true;
    }

    public static enum EnumStateMode implements IMultiButtonState
    {
        IMMEDIATE("railcraft.gui.box.capacitor.immediate"),
        DELAYED("railcraft.gui.box.capacitor.delayed");

        private final String label;
        private final ToolTip tip;

        private EnumStateMode(String label) {
            this.label = label;
            this.tip = ToolTip.buildToolTip(label + ".tip", new String[0]);
        }

        @Override
        public String getLabel() {
            return LocalizationPlugin.translate(this.label);
        }

        @Override
        public IButtonTextureSet getTextureSet() {
            return StandardButtonTextureSets.SMALL_BUTTON;
        }

        @Override
        public ToolTip getToolTip() {
            return this.tip;
        }
    }
}

