/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.signals;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.EnumSet;
import mods.railcraft.api.signals.IControllerTile;
import mods.railcraft.api.signals.SignalAspect;
import mods.railcraft.api.signals.SimpleSignalController;
import mods.railcraft.common.blocks.signals.EnumSignal;
import mods.railcraft.common.blocks.signals.TileBoxBase;
import mods.railcraft.common.gui.EnumGui;
import mods.railcraft.common.gui.GuiHandler;
import mods.railcraft.common.plugins.forge.PowerPlugin;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.network.IGuiReturnHandler;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TileBoxController
extends TileBoxBase
implements IControllerTile,
IGuiReturnHandler {
    private static final EnumSet<ForgeDirection> powerSides = EnumSet.of(ForgeDirection.DOWN, ForgeDirection.EAST, ForgeDirection.WEST, ForgeDirection.NORTH, ForgeDirection.SOUTH);
    private final SimpleSignalController controller = new SimpleSignalController(this.getLocalizationTag(), this);
    public SignalAspect defaultAspect = SignalAspect.GREEN;
    public SignalAspect poweredAspect = SignalAspect.RED;
    private boolean powered;

    @Override
    public EnumSignal getSignalType() {
        return EnumSignal.BOX_CONTROLLER;
    }

    @Override
    public boolean blockActivated(int side, EntityPlayer player) {
        if (player.isSneaking()) {
            return false;
        }
        GuiHandler.openGui(EnumGui.BOX_CONTROLLER, player, this.worldObj, this.xCoord, this.yCoord, this.zCoord);
        return true;
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (Game.isNotHost(this.worldObj)) {
            this.controller.tickClient();
            return;
        }
        this.controller.tickServer();
        SignalAspect prevAspect = this.controller.getAspect();
        if (this.controller.isBeingPaired()) {
            this.controller.setAspect(SignalAspect.BLINK_YELLOW);
        } else if (this.controller.isPaired()) {
            this.controller.setAspect(this.determineAspect());
        } else {
            this.controller.setAspect(SignalAspect.BLINK_RED);
        }
        if (prevAspect != this.controller.getAspect()) {
            this.sendUpdateToClient();
        }
    }

    @Override
    public void onNeighborBlockChange(Block block) {
        boolean p;
        super.onNeighborBlockChange(block);
        if (Game.isNotHost(this.getWorld())) {
            return;
        }
        boolean bl = p = this.isBeingPowered() || PowerPlugin.isRedstonePowered(this.worldObj, this.xCoord, this.yCoord, this.zCoord);
        if (p != this.powered) {
            this.powered = p;
            this.sendUpdateToClient();
        }
    }

    private boolean isBeingPowered() {
        for (ForgeDirection side : powerSides) {
            if (this.tileCache.getTileOnSide(side) instanceof TileBoxBase || !PowerPlugin.isBlockBeingPowered(this.worldObj, this.xCoord, this.yCoord, this.zCoord, side)) continue;
            return true;
        }
        return false;
    }

    private SignalAspect determineAspect() {
        SignalAspect newAspect = this.powered ? this.poweredAspect : this.defaultAspect;
        for (int side = 2; side < 6; ++side) {
            TileBoxBase tile;
            ForgeDirection forgeSide = ForgeDirection.getOrientation((int)side);
            TileEntity t = this.tileCache.getTileOnSide(forgeSide);
            if (!(t instanceof TileBoxBase) || !(tile = (TileBoxBase)t).canTransferAspect()) continue;
            newAspect = SignalAspect.mostRestrictive(newAspect, tile.getBoxSignalAspect(forgeSide.getOpposite()));
        }
        return newAspect;
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.setBoolean("Powered", this.powered);
        data.setInteger("defaultAspect", this.defaultAspect.ordinal());
        data.setInteger("PoweredAspect", this.poweredAspect.ordinal());
        this.controller.writeToNBT(data);
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.powered = data.getBoolean("Powered");
        this.defaultAspect = SignalAspect.values()[data.getInteger("defaultAspect")];
        this.poweredAspect = SignalAspect.values()[data.getInteger("PoweredAspect")];
        this.controller.readFromNBT(data);
        if (data.hasKey("ReceiverX")) {
            int x = data.getInteger("ReceiverX");
            int y = data.getInteger("ReceiverY");
            int z = data.getInteger("ReceiverZ");
            this.controller.registerLegacyReceiver(x, y, z);
        }
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeByte(this.defaultAspect.ordinal());
        data.writeByte(this.poweredAspect.ordinal());
        this.controller.writePacketData(data);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.defaultAspect = SignalAspect.values()[data.readByte()];
        this.poweredAspect = SignalAspect.values()[data.readByte()];
        this.controller.readPacketData(data);
        this.markBlockForUpdate();
    }

    @Override
    public void writeGuiData(DataOutputStream data) throws IOException {
        data.writeByte(this.defaultAspect.ordinal());
        data.writeByte(this.poweredAspect.ordinal());
    }

    @Override
    public void readGuiData(DataInputStream data, EntityPlayer sender) throws IOException {
        this.defaultAspect = SignalAspect.values()[data.readByte()];
        this.poweredAspect = SignalAspect.values()[data.readByte()];
    }

    @Override
    public boolean isConnected(ForgeDirection side) {
        TileEntity tile = this.tileCache.getTileOnSide(side);
        if (tile instanceof TileBoxBase) {
            return ((TileBoxBase)tile).canTransferAspect();
        }
        return false;
    }

    @Override
    public SignalAspect getBoxSignalAspect(ForgeDirection side) {
        return this.controller.getAspect();
    }

    @Override
    public boolean canReceiveAspect() {
        return true;
    }

    @Override
    public SimpleSignalController getController() {
        return this.controller;
    }
}

