/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.signals;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import mods.railcraft.api.signals.IControllerTile;
import mods.railcraft.api.signals.IReceiverTile;
import mods.railcraft.api.signals.SignalAspect;
import mods.railcraft.api.signals.SignalController;
import mods.railcraft.api.signals.SimpleSignalController;
import mods.railcraft.api.signals.SimpleSignalReceiver;
import mods.railcraft.common.blocks.signals.EnumSignal;
import mods.railcraft.common.blocks.signals.TileBoxBase;
import mods.railcraft.common.plugins.buildcraft.triggers.IAspectProvider;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TileBoxInterlock
extends TileBoxBase
implements IControllerTile,
IReceiverTile,
IAspectProvider {
    private static final ForgeDirection[] SIDES = new ForgeDirection[]{ForgeDirection.NORTH, ForgeDirection.WEST, ForgeDirection.SOUTH, ForgeDirection.EAST};
    private final SimpleSignalController controller = new SimpleSignalController(this.getLocalizationTag(), this);
    private final SimpleSignalReceiver receiver = new SimpleSignalReceiver(this.getLocalizationTag(), this);
    private Interlock interlock = new Interlock(this);
    private SignalAspect overrideAspect = SignalAspect.RED;

    @Override
    public EnumSignal getSignalType() {
        return EnumSignal.BOX_INTERLOCK;
    }

    @Override
    public void onControllerAspectChange(SignalController con, SignalAspect aspect) {
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (this.worldObj.isRemote) {
            this.controller.tickClient();
            this.receiver.tickClient();
            return;
        }
        this.controller.tickServer();
        this.receiver.tickServer();
        this.overrideAspect = this.getOverrideAspect();
        this.mergeInterlocks();
        this.interlock.tick(this);
        SignalAspect prevAspect = this.controller.getAspect();
        if (this.receiver.isBeingPaired() || this.controller.isBeingPaired()) {
            this.controller.setAspect(SignalAspect.BLINK_YELLOW);
        } else if (this.controller.isPaired() && this.receiver.isPaired()) {
            this.controller.setAspect(this.determineAspect());
        } else {
            this.controller.setAspect(SignalAspect.BLINK_RED);
        }
        if (prevAspect != this.controller.getAspect()) {
            this.sendUpdateToClient();
        }
    }

    private void mergeInterlocks() {
        for (ForgeDirection side : SIDES) {
            TileEntity tile = this.tileCache.getTileOnSide(side);
            if (!(tile instanceof TileBoxInterlock)) continue;
            TileBoxInterlock box = (TileBoxInterlock)tile;
            if (box.interlock == this.interlock) continue;
            box.interlock.merge(this.interlock);
            return;
        }
    }

    private SignalAspect getOverrideAspect() {
        SignalAspect newAspect = SignalAspect.GREEN;
        for (int side = 2; side < 6; ++side) {
            TileBoxBase tile;
            ForgeDirection forgeSide = ForgeDirection.getOrientation((int)side);
            TileEntity t = this.tileCache.getTileOnSide(forgeSide);
            if (!(t instanceof TileBoxBase) || !(tile = (TileBoxBase)t).canTransferAspect()) continue;
            newAspect = SignalAspect.mostRestrictive(newAspect, tile.getBoxSignalAspect(forgeSide.getOpposite()));
        }
        return newAspect;
    }

    private SignalAspect determineAspect() {
        this.interlock.requestLock(this, this.receiver.getAspect().ordinal() <= SignalAspect.YELLOW.ordinal());
        return this.interlock.getAspect(this, this.receiver.getAspect());
    }

    @Override
    public SignalAspect getBoxSignalAspect(ForgeDirection side) {
        return this.controller.getAspect();
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        this.controller.writeToNBT(data);
        this.receiver.writeToNBT(data);
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.controller.readFromNBT(data);
        this.receiver.readFromNBT(data);
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        this.controller.writePacketData(data);
        this.receiver.writePacketData(data);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.controller.readPacketData(data);
        this.receiver.readPacketData(data);
        this.markBlockForUpdate();
    }

    @Override
    public boolean isConnected(ForgeDirection side) {
        TileEntity tile = this.tileCache.getTileOnSide(side);
        if (tile instanceof TileBoxInterlock) {
            return true;
        }
        if (tile instanceof TileBoxBase) {
            return ((TileBoxBase)tile).canTransferAspect();
        }
        return false;
    }

    @Override
    public boolean canTransferAspect() {
        return false;
    }

    @Override
    public boolean canReceiveAspect() {
        return true;
    }

    @Override
    public SignalController getController() {
        return this.controller;
    }

    @Override
    public SimpleSignalReceiver getReceiver() {
        return this.receiver;
    }

    @Override
    public SignalAspect getTriggerAspect() {
        return this.getBoxSignalAspect(null);
    }

    @Override
    public List<String> getDebugOutput() {
        List<String> debug = super.getDebugOutput();
        debug.add("Interlock Obj: " + this.interlock);
        debug.add("Interlock Pool: " + this.interlock.interlocks);
        debug.add("Lock Requests: " + this.interlock.lockRequests);
        debug.add("Active: " + this.interlock.active);
        debug.add("Delay: " + this.interlock.delay);
        debug.add("In Aspect: " + this.receiver.getAspect().name());
        debug.add("Out Aspect: " + this.controller.getAspect().name());
        debug.add("Override Aspect: " + this.overrideAspect.name());
        return debug;
    }

    private class Interlock {
        private static final int DELAY = 200;
        private TreeSet<TileBoxInterlock> interlocks = new TreeSet<TileBoxInterlock>(TileComparator.INSTANCE);
        private TreeSet<TileBoxInterlock> lockRequests = new TreeSet<TileBoxInterlock>(TileComparator.INSTANCE);
        private TileBoxInterlock active;
        private int delay;

        public Interlock(TileBoxInterlock tile) {
            this.interlocks.add(tile);
        }

        public void merge(Interlock interlock) {
            this.interlocks.addAll(interlock.interlocks);
            for (TileBoxInterlock box : this.interlocks) {
                box.interlock = this;
            }
        }

        public void tick(TileBoxInterlock host) {
            Iterator<TileBoxInterlock> it = this.interlocks.iterator();
            while (it.hasNext()) {
                TileBoxInterlock box = it.next();
                if (!box.isInvalid()) continue;
                it.remove();
            }
            if (this.delay < 200) {
                ++this.delay;
                return;
            }
            if (this.active != null && this.active.isInvalid()) {
                this.active = null;
            }
            if (this.active == null && !this.lockRequests.isEmpty() && this.interlocks.first() == host) {
                this.active = this.lockRequests.last();
                this.lockRequests.clear();
            }
        }

        public void requestLock(TileBoxInterlock host, boolean request) {
            if (request) {
                this.lockRequests.add(host);
            } else if (this.active == host) {
                this.active = null;
            }
        }

        public SignalAspect getAspect(TileBoxInterlock host, SignalAspect requestedAspect) {
            if (host == this.active) {
                SignalAspect overrideAspect = SignalAspect.GREEN;
                for (TileBoxInterlock box : this.interlocks) {
                    overrideAspect = SignalAspect.mostRestrictive(overrideAspect, box.overrideAspect);
                }
                return SignalAspect.mostRestrictive(overrideAspect, requestedAspect);
            }
            return SignalAspect.RED;
        }
    }

    private static class TileComparator
    implements Comparator<TileBoxInterlock> {
        public static TileComparator INSTANCE = new TileComparator();

        private TileComparator() {
        }

        @Override
        public int compare(TileBoxInterlock o1, TileBoxInterlock o2) {
            if (o1.xCoord != o2.xCoord) {
                return o1.xCoord - o2.xCoord;
            }
            if (o1.zCoord != o2.zCoord) {
                return o1.zCoord - o2.zCoord;
            }
            if (o1.yCoord != o2.yCoord) {
                return o1.yCoord - o2.yCoord;
            }
            return 0;
        }
    }
}

