/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.signals;

import mods.railcraft.common.blocks.RailcraftBlocks;
import mods.railcraft.common.blocks.RailcraftTileEntity;
import mods.railcraft.common.blocks.signals.BlockSignalBase;
import mods.railcraft.common.blocks.signals.ISignalTileDefinition;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.logging.log4j.Level;

public abstract class TileSignalFoundation
extends RailcraftTileEntity {
    private boolean checkedBlock = false;

    public abstract ISignalTileDefinition getSignalType();

    public boolean canUpdate() {
        return true;
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (Game.isNotHost(this.worldObj)) {
            return;
        }
        if (!this.checkedBlock) {
            this.checkedBlock = true;
            if (!this.getSignalType().isEnabled()) {
                this.worldObj.setBlockToAir(this.xCoord, this.yCoord, this.zCoord);
                return;
            }
            if (this.getBlockType() != this.getSignalType().getBlock()) {
                Game.log(Level.INFO, "Updating Machine Tile Block: {0} {1}->{2}, [{3}, {4}, {5}]", this.getClass().getSimpleName(), this.getBlockType(), this.getSignalType().getBlock(), this.xCoord, this.yCoord, this.zCoord);
                this.worldObj.setBlock(this.xCoord, this.yCoord, this.zCoord, this.getSignalType().getBlock(), (int)this.getId(), 3);
                this.validate();
                this.worldObj.setTileEntity(this.xCoord, this.yCoord, this.zCoord, (TileEntity)this);
                this.updateContainingBlockInfo();
            }
            int meta = this.worldObj.getBlockMetadata(this.xCoord, this.yCoord, this.zCoord);
            if (this.getBlockType() != null && this.getClass() != ((BlockSignalBase)this.getBlockType()).getSignalType(meta).getTileClass()) {
                this.worldObj.setBlockMetadataWithNotify(this.xCoord, this.yCoord, this.zCoord, this.getSignalType().getMeta(), 3);
                this.validate();
                this.worldObj.setTileEntity(this.xCoord, this.yCoord, this.zCoord, (TileEntity)this);
                Game.log(Level.INFO, "Updating Machine Tile Metadata: {0} {1}->{2}, [{3}, {4}, {5}]", this.getClass().getSimpleName(), meta, this.getSignalType().getMeta(), this.xCoord, this.yCoord, this.zCoord);
                this.updateContainingBlockInfo();
            }
        }
    }

    public boolean blockActivated(int side, EntityPlayer player) {
        return false;
    }

    public boolean rotateBlock(ForgeDirection axis) {
        return false;
    }

    public ForgeDirection[] getValidRotations() {
        return ForgeDirection.VALID_DIRECTIONS;
    }

    public void onBlockPlaced() {
    }

    public void onBlockRemoval() {
    }

    public void setBlockBoundsBasedOnState(IBlockAccess world, int i, int j, int k) {
        RailcraftBlocks.getBlockSignal().setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int i, int j, int k) {
        return AxisAlignedBB.getBoundingBox((double)i, (double)j, (double)k, (double)(i + 1), (double)(j + 1), (double)(k + 1));
    }

    public AxisAlignedBB getSelectedBoundingBoxFromPool(World world, int i, int j, int k) {
        return AxisAlignedBB.getBoundingBox((double)i, (double)j, (double)k, (double)(i + 1), (double)(j + 1), (double)(k + 1));
    }

    public boolean isSideSolid(IBlockAccess world, int i, int j, int k, ForgeDirection side) {
        return false;
    }

    public boolean canConnectRedstone(int dir) {
        return false;
    }

    public int getPowerOutput(int side) {
        return 0;
    }

    public float getHardness() {
        return this.getSignalType().getHardness();
    }

    public Block getBlockType() {
        return RailcraftBlocks.getBlockSignal();
    }

    @Override
    public short getId() {
        return (short)this.getSignalType().getMeta();
    }

    @Override
    public String getLocalizationTag() {
        return this.getSignalType().getTag() + ".name";
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }
}

