/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.signals;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.railcraft.api.signals.IReceiverTile;
import mods.railcraft.api.signals.SignalAspect;
import mods.railcraft.api.signals.SignalController;
import mods.railcraft.api.signals.SimpleSignalReceiver;
import mods.railcraft.api.tracks.ITrackSwitch;
import mods.railcraft.common.blocks.signals.EnumSignal;
import mods.railcraft.common.blocks.signals.IAspectActionManager;
import mods.railcraft.common.blocks.signals.TileSwitchSecured;
import mods.railcraft.common.gui.EnumGui;
import mods.railcraft.common.gui.GuiHandler;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.network.IGuiReturnHandler;
import net.minecraft.block.Block;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;

public class TileSwitchMotor
extends TileSwitchSecured
implements IAspectActionManager,
IGuiReturnHandler,
IReceiverTile {
    private final SimpleSignalReceiver receiver = new SimpleSignalReceiver(this.getLocalizationTag(), this);
    private boolean[] switchOnAspects = new boolean[SignalAspect.values().length];
    private boolean switchAspect;
    private boolean switchOnRedstone = true;

    public TileSwitchMotor() {
        this.switchOnAspects[SignalAspect.RED.ordinal()] = true;
    }

    @Override
    public EnumSignal getSignalType() {
        return EnumSignal.SWITCH_MOTOR;
    }

    @Override
    public boolean blockActivated(int side, EntityPlayer player) {
        if (Game.isHost(this.worldObj)) {
            GuiHandler.openGui(EnumGui.SWITCH_MOTOR, player, this.worldObj, this.xCoord, this.yCoord, this.zCoord);
        }
        return true;
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (Game.isNotHost(this.worldObj)) {
            this.receiver.tickClient();
            return;
        }
        this.receiver.tickServer();
        boolean active = this.isSwitchAspect();
        if (this.switchAspect != active) {
            this.switchAspect = active;
        }
    }

    @Override
    public void onControllerAspectChange(SignalController con, SignalAspect aspect) {
    }

    @Override
    public void onNeighborBlockChange(Block block) {
        super.onNeighborBlockChange(block);
        boolean power = this.isBeingPoweredByRedstone();
        if (this.isPowered() != power) {
            this.setPowered(power);
        }
    }

    @Override
    public boolean canConnectRedstone(int dir) {
        return true;
    }

    private boolean isSwitchAspect() {
        return this.switchOnAspects[this.receiver.getAspect().ordinal()];
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        byte[] array = new byte[this.switchOnAspects.length];
        for (int i = 0; i < this.switchOnAspects.length; ++i) {
            array[i] = (byte)(this.switchOnAspects[i] ? 1 : 0);
        }
        data.setByteArray("PowerOnAspect", array);
        data.setBoolean("switchAspect", this.switchAspect);
        data.setBoolean("switchOnRedstone", this.switchOnRedstone);
        this.receiver.writeToNBT(data);
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        if (data.hasKey("PowerOnAspect")) {
            byte[] array = data.getByteArray("PowerOnAspect");
            for (int i = 0; i < this.switchOnAspects.length; ++i) {
                this.switchOnAspects[i] = array[i] == 1;
            }
        }
        this.switchAspect = data.getBoolean("switchAspect");
        if (data.hasKey("switchOnRedstone")) {
            this.switchOnRedstone = data.getBoolean("switchOnRedstone");
        }
        this.receiver.readFromNBT(data);
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        this.receiver.writePacketData(data);
        this.writeGuiData(data);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.receiver.readPacketData(data);
        this.readGuiData(data, null);
        this.markBlockForUpdate();
    }

    @Override
    public void writeGuiData(DataOutputStream data) throws IOException {
        super.writeGuiData(data);
        int bits = 0;
        for (int i = 0; i < this.switchOnAspects.length; ++i) {
            bits = (byte)(bits | (this.switchOnAspects[i] ? 1 : 0) << i);
        }
        data.writeByte(bits);
        data.writeBoolean(this.switchOnRedstone);
    }

    @Override
    public void readGuiData(DataInputStream data, EntityPlayer sender) throws IOException {
        super.readGuiData(data, sender);
        byte bits = data.readByte();
        for (int bit = 0; bit < this.switchOnAspects.length; ++bit) {
            this.switchOnAspects[bit] = (bits >> bit & 1) == 1;
        }
        this.switchOnRedstone = data.readBoolean();
    }

    @Override
    public boolean doesActionOnAspect(SignalAspect aspect) {
        return this.switchOnAspects[aspect.ordinal()];
    }

    @Override
    public void doActionOnAspect(SignalAspect aspect, boolean trigger) {
        this.switchOnAspects[aspect.ordinal()] = trigger;
    }

    @Override
    public SimpleSignalReceiver getReceiver() {
        return this.receiver;
    }

    @Override
    public boolean shouldSwitch(ITrackSwitch switchTrack, EntityMinecart cart) {
        return this.switchAspect || this.shouldSwitchOnRedstone() && this.isPowered();
    }

    public boolean shouldSwitchOnRedstone() {
        return this.switchOnRedstone;
    }

    public void setSwitchOnRedstone(boolean switchOnRedstone) {
        this.switchOnRedstone = switchOnRedstone;
    }
}

