/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.tracks;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import mods.railcraft.api.core.IPostConnection;
import mods.railcraft.api.core.ITextureLoader;
import mods.railcraft.api.electricity.IElectricGrid;
import mods.railcraft.api.tracks.ITrackBlocksMovement;
import mods.railcraft.api.tracks.ITrackCustomShape;
import mods.railcraft.api.tracks.ITrackEmitter;
import mods.railcraft.api.tracks.ITrackInstance;
import mods.railcraft.api.tracks.TrackInstanceBase;
import mods.railcraft.api.tracks.TrackRegistry;
import mods.railcraft.api.tracks.TrackSpec;
import mods.railcraft.client.particles.ParticleHelper;
import mods.railcraft.common.blocks.RailcraftBlocks;
import mods.railcraft.common.blocks.tracks.EnumTrack;
import mods.railcraft.common.blocks.tracks.TileTrack;
import mods.railcraft.common.blocks.tracks.TileTrackTESR;
import mods.railcraft.common.blocks.tracks.TrackTools;
import mods.railcraft.common.core.Railcraft;
import mods.railcraft.common.items.ItemOveralls;
import mods.railcraft.common.plugins.forge.WorldPlugin;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.misc.MiscTools;
import mods.railcraft.common.util.misc.RailcraftDamageSource;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRailBase;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.logging.log4j.Level;

public class BlockTrack
extends BlockRailBase
implements IPostConnection {
    public static final float HARDNESS = 2.0f;
    protected final int renderType;

    public BlockTrack(int modelID) {
        super(false);
        this.renderType = modelID;
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.125f, 1.0f);
        this.setResistance(3.5f);
        this.setHardness(2.0f);
        this.setStepSound(soundTypeMetal);
        this.setCreativeTab(CreativeTabs.tabTransport);
        this.setHarvestLevel("crowbar", 0);
        GameRegistry.registerTileEntity(TileTrack.class, (String)"RailcraftTrackTile");
        GameRegistry.registerTileEntity(TileTrackTESR.class, (String)"RailcraftTrackTESRTile");
        try {
            TrackSpec.blockTrack = this;
        }
        catch (Throwable error) {
            Game.logErrorAPI(Railcraft.getModId(), error, TrackSpec.class);
        }
    }

    public void getSubBlocks(Item item, CreativeTabs tab, List list) {
        for (EnumTrack track : EnumTrack.getCreativeList()) {
            if (!track.isEnabled()) continue;
            list.add(track.getItem());
        }
        try {
            Collection<TrackSpec> railcraftSpecs = EnumTrack.getRailcraftTrackSpecs();
            Map<Short, TrackSpec> registeredSpecs = TrackRegistry.getTrackSpecIDs();
            HashSet<TrackSpec> otherSpecs = new HashSet<TrackSpec>(registeredSpecs.values());
            otherSpecs.removeAll(railcraftSpecs);
            for (TrackSpec spec : otherSpecs) {
                list.add(spec.getItem());
            }
        }
        catch (Error error) {
            Game.logErrorAPI(Railcraft.getModId(), error, TrackRegistry.class, TrackSpec.class);
        }
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z, EntityPlayer player) {
        TileEntity tile = WorldPlugin.getBlockTile((IBlockAccess)world, x, y, z);
        try {
            if (tile instanceof TileTrack) {
                ITrackInstance track = ((TileTrack)tile).getTrackInstance();
                return track.getTrackSpec().getItem();
            }
        }
        catch (Error error) {
            Game.logErrorAPI(Railcraft.getModId(), error, TrackRegistry.class, TrackSpec.class);
        }
        return null;
    }

    public boolean rotateBlock(World worldObj, int x, int y, int z, ForgeDirection axis) {
        return false;
    }

    public int getRenderType() {
        return this.renderType;
    }

    public boolean hasTileEntity(int metadata) {
        return true;
    }

    public int getMobilityFlag() {
        return 0;
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int x, int y, int z) {
        TileEntity tile = WorldPlugin.getBlockTile((IBlockAccess)world, x, y, z);
        try {
            ITrackInstance track;
            if (tile instanceof TileTrack && (track = ((TileTrack)tile).getTrackInstance()) instanceof ITrackCustomShape) {
                return ((ITrackCustomShape)track).getCollisionBoundingBoxFromPool();
            }
        }
        catch (Error error) {
            Game.logErrorAPI(Railcraft.getModId(), error, ITrackInstance.class);
        }
        return null;
    }

    public AxisAlignedBB getSelectedBoundingBoxFromPool(World world, int x, int y, int z) {
        TileEntity tile = WorldPlugin.getBlockTile((IBlockAccess)world, x, y, z);
        try {
            ITrackInstance track;
            if (tile instanceof TileTrack && (track = ((TileTrack)tile).getTrackInstance()) instanceof ITrackCustomShape) {
                return ((ITrackCustomShape)track).getSelectedBoundingBoxFromPool();
            }
        }
        catch (Error error) {
            Game.logErrorAPI(Railcraft.getModId(), error, ITrackInstance.class);
        }
        return AxisAlignedBB.getBoundingBox((double)((double)x + this.minX), (double)((double)y + this.minY), (double)((double)z + this.minZ), (double)((double)x + this.maxX), (double)((double)y + this.maxY), (double)((double)z + this.maxZ));
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public MovingObjectPosition collisionRayTrace(World world, int x, int y, int z, Vec3 vec3d, Vec3 vec3d1) {
        TileEntity tile = WorldPlugin.getBlockTile((IBlockAccess)world, x, y, z);
        try {
            ITrackInstance track;
            if (tile instanceof TileTrack && (track = ((TileTrack)tile).getTrackInstance()) instanceof ITrackCustomShape) {
                return ((ITrackCustomShape)track).collisionRayTrace(vec3d, vec3d1);
            }
        }
        catch (Error error) {
            Game.logErrorAPI(Railcraft.getModId(), error, ITrackInstance.class);
        }
        return super.collisionRayTrace(world, x, y, z, vec3d, vec3d1);
    }

    public void setBlockBoundsBasedOnState(IBlockAccess iblockaccess, int x, int y, int z) {
        int l = iblockaccess.getBlockMetadata(x, y, z);
        if (l >= 2 && l <= 5) {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.625f, 1.0f);
        } else {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.125f, 1.0f);
        }
    }

    public boolean getBlocksMovement(IBlockAccess world, int x, int y, int z) {
        TileEntity tile = WorldPlugin.getBlockTile(world, x, y, z);
        try {
            ITrackInstance track;
            if (tile instanceof TileTrack && (track = ((TileTrack)tile).getTrackInstance()) instanceof ITrackBlocksMovement) {
                return !((ITrackBlocksMovement)((Object)track)).blocksMovement();
            }
        }
        catch (Error error) {
            Game.logErrorAPI(Railcraft.getModId(), error, ITrackInstance.class, ITrackBlocksMovement.class);
        }
        return super.getBlocksMovement(world, x, y, z);
    }

    public void onEntityCollidedWithBlock(World world, int x, int y, int z, Entity entity) {
        if (Game.isNotHost(world)) {
            return;
        }
        if (!MiscTools.isKillabledEntity(entity)) {
            return;
        }
        TileEntity tile = WorldPlugin.getBlockTile((IBlockAccess)world, x, y, z);
        if (!(tile instanceof TileTrack)) {
            return;
        }
        ITrackInstance track = ((TileTrack)tile).getTrackInstance();
        if (!(track instanceof IElectricGrid)) {
            return;
        }
        IElectricGrid.ChargeHandler chargeHandler = ((IElectricGrid)((Object)track)).getChargeHandler();
        if (chargeHandler.getCharge() > 2000.0) {
            if (entity instanceof EntityPlayer && ItemOveralls.isPlayerWearing((EntityPlayer)entity)) {
                if (!((EntityPlayer)entity).capabilities.isCreativeMode && MiscTools.RANDOM.nextInt(150) == 0) {
                    EntityPlayer player = (EntityPlayer)entity;
                    ItemStack pants = player.getCurrentArmor(MiscTools.ArmorSlots.LEGS.ordinal());
                    player.setCurrentItemOrArmor(MiscTools.ArmorSlots.LEGS.ordinal() + 1, InvTools.damageItem(pants, 1));
                }
            } else if (((EntityLivingBase)entity).attackEntityFrom((DamageSource)RailcraftDamageSource.TRACK_ELECTRIC, 2.0f)) {
                chargeHandler.removeCharge(2000.0);
            }
        }
    }

    public boolean canPlaceBlockAt(World world, int x, int y, int z) {
        return !TrackTools.isRailBlockAt((IBlockAccess)world, x, y + 1, z);
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public boolean canProvidePower() {
        return true;
    }

    public boolean canConnectRedstone(IBlockAccess world, int x, int y, int z, int side) {
        TileEntity tile = WorldPlugin.getBlockTile(world, x, y, z);
        if (tile instanceof TileTrack) {
            ITrackInstance track = ((TileTrack)tile).getTrackInstance();
            return track instanceof ITrackEmitter;
        }
        return false;
    }

    public int isProvidingWeakPower(IBlockAccess world, int x, int y, int z, int side) {
        TileEntity tile = WorldPlugin.getBlockTile(world, x, y, z);
        if (tile instanceof TileTrack) {
            ITrackInstance track = ((TileTrack)tile).getTrackInstance();
            return track instanceof ITrackEmitter ? ((ITrackEmitter)track).getPowerOutput() : 0;
        }
        return 0;
    }

    public void onMinecartPass(World world, EntityMinecart cart, int x, int y, int z) {
        TileEntity tile = WorldPlugin.getBlockTile((IBlockAccess)world, x, y, z);
        if (tile instanceof TileTrack) {
            ((TileTrack)tile).getTrackInstance().onMinecartPass(cart);
        }
    }

    public int getBasicRailMetadata(IBlockAccess world, EntityMinecart cart, int x, int y, int z) {
        TileEntity tile = WorldPlugin.getBlockTile(world, x, y, z);
        if (tile instanceof TileTrack) {
            return ((TileTrack)tile).getTrackInstance().getBasicRailMetadata(cart);
        }
        return world.getBlockMetadata(x, y, z);
    }

    public float getRailMaxSpeed(World world, EntityMinecart cart, int x, int y, int z) {
        TileEntity tile = WorldPlugin.getBlockTile((IBlockAccess)world, x, y, z);
        if (tile instanceof TileTrack) {
            return ((TileTrack)tile).getTrackInstance().getRailMaxSpeed(cart);
        }
        return 0.4f;
    }

    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer player, int side, float u1, float u2, float u3) {
        TileEntity tile = WorldPlugin.getBlockTile((IBlockAccess)world, x, y, z);
        if (tile instanceof TileTrack) {
            return ((TileTrack)tile).getTrackInstance().blockActivated(player);
        }
        return false;
    }

    public boolean isFlexibleRail(IBlockAccess world, int x, int y, int z) {
        TileEntity tile = WorldPlugin.getBlockTile(world, x, y, z);
        if (tile instanceof TileTrack) {
            return ((TileTrack)tile).getTrackInstance().isFlexibleRail();
        }
        return false;
    }

    public boolean canMakeSlopes(IBlockAccess world, int x, int y, int z) {
        TileEntity tile = WorldPlugin.getBlockTile(world, x, y, z);
        if (tile instanceof TileTrack) {
            return ((TileTrack)tile).getTrackInstance().canMakeSlopes();
        }
        return true;
    }

    public IIcon getIcon(int side, int meta) {
        return Blocks.rail.getIcon(side, meta);
    }

    public IIcon getIcon(IBlockAccess world, int x, int y, int z, int side) {
        TileEntity tile = WorldPlugin.getBlockTile(world, x, y, z);
        if (tile instanceof TileTrack) {
            return ((TileTrack)tile).getTrackInstance().getIcon();
        }
        return null;
    }

    public void registerBlockIcons(IIconRegister iconRegister) {
        try {
            for (ITextureLoader iconLoader : TrackRegistry.getIconLoaders()) {
                iconLoader.registerIcons(iconRegister);
            }
        }
        catch (Error error) {
            Game.logErrorAPI(Railcraft.getModId(), error, TrackRegistry.class);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(World worldObj, MovingObjectPosition target, EffectRenderer effectRenderer) {
        return ParticleHelper.addHitEffects(worldObj, RailcraftBlocks.getBlockTrack(), target, effectRenderer, null);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World worldObj, int x, int y, int z, int meta, EffectRenderer effectRenderer) {
        return ParticleHelper.addDestroyEffects(worldObj, RailcraftBlocks.getBlockTrack(), x, y, z, meta, effectRenderer, null);
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int md, int fortune) {
        TileEntity tile = WorldPlugin.getBlockTile((IBlockAccess)world, x, y, z);
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        try {
            if (tile instanceof TileTrack) {
                List<ItemStack> drops = ((TileTrack)tile).getTrackInstance().getDrops(fortune);
                if (drops != null) {
                    items.addAll(drops);
                }
            } else {
                Game.log(Level.WARN, "Rail Tile was invalid when harvesting rail", new Object[0]);
                items.add(new ItemStack(Blocks.rail));
            }
        }
        catch (Error error) {
            Game.logErrorAPI(Railcraft.getModId(), error, ITrackInstance.class, TrackInstanceBase.class);
        }
        return items;
    }

    public int quantityDropped(int meta, int fortune, Random random) {
        return 1;
    }

    public TileEntity getBlockEntity(int md) {
        return null;
    }

    public void onBlockPlacedBy(World world, int x, int y, int z, EntityLivingBase entityliving, ItemStack stack) {
        TileEntity tile = WorldPlugin.getBlockTile((IBlockAccess)world, x, y, z);
        if (tile instanceof TileTrack) {
            ((TileTrack)tile).onBlockPlacedBy(entityliving, stack);
            ((TileTrack)tile).getTrackInstance().onBlockPlacedBy(entityliving);
        }
    }

    public void onPostBlockPlaced(World world, int x, int y, int z, int meta) {
        TileEntity tile = WorldPlugin.getBlockTile((IBlockAccess)world, x, y, z);
        try {
            if (tile instanceof TileTrack) {
                ((TileTrack)tile).getTrackInstance().onBlockPlaced();
            }
        }
        catch (Error error) {
            Game.logErrorAPI(Railcraft.getModId(), error, ITrackInstance.class);
        }
    }

    public void harvestBlock(World world, EntityPlayer entityplayer, int x, int y, int z, int l) {
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean willHarvest) {
        player.addStat(StatList.mineBlockStatArray[BlockTrack.getIdFromBlock((Block)this)], 1);
        player.addExhaustion(0.025f);
        if (Game.isHost(world) && !player.capabilities.isCreativeMode) {
            this.dropBlockAsItem(world, x, y, z, 0, 0);
        }
        return world.setBlockToAir(x, y, z);
    }

    public void breakBlock(World world, int x, int y, int z, Block block, int meta) {
        super.breakBlock(world, x, y, z, block, meta);
        try {
            TileEntity tile = WorldPlugin.getBlockTile((IBlockAccess)world, x, y, z);
            if (tile instanceof TileTrack) {
                ((TileTrack)tile).getTrackInstance().onBlockRemoved();
            }
        }
        catch (Error error) {
            Game.logErrorAPI(Railcraft.getModId(), error, ITrackInstance.class);
        }
        world.removeTileEntity(x, y, z);
    }

    public void onNeighborBlockChange(World world, int x, int y, int z, Block block) {
        block4: {
            try {
                if (Game.isNotHost(world)) {
                    return;
                }
                TileEntity t = WorldPlugin.getBlockTile((IBlockAccess)world, x, y, z);
                if (t instanceof TileTrack) {
                    TileTrack tile = (TileTrack)t;
                    tile.onNeighborBlockChange(block);
                    tile.getTrackInstance().onNeighborBlockChange(block);
                }
            }
            catch (StackOverflowError error) {
                Game.logThrowable(Level.ERROR, "Stack Overflow Error in BlockTrack.onNeighborBlockChange()", 10, error, new Object[0]);
                if (!Game.IS_DEBUG) break block4;
                throw error;
            }
        }
    }

    public float getBlockHardness(World world, int x, int y, int z) {
        TileEntity tile = WorldPlugin.getBlockTile((IBlockAccess)world, x, y, z);
        if (tile instanceof TileTrack) {
            try {
                return ((TileTrack)tile).getTrackInstance().getHardness();
            }
            catch (Error error) {
                Game.logErrorAPI(Railcraft.getModId(), error, ITrackInstance.class);
            }
        }
        return super.getBlockHardness(world, x, y, z);
    }

    public float getExplosionResistance(Entity exploder, World world, int x, int y, int z, double srcX, double srcY, double srcZ) {
        TileEntity tile = WorldPlugin.getBlockTile((IBlockAccess)world, x, y, z);
        if (tile instanceof TileTrack) {
            try {
                return ((TileTrack)tile).getTrackInstance().getExplosionResistance(srcX, srcY, srcZ, exploder) * 3.0f / 5.0f;
            }
            catch (Error error) {
                Game.logErrorAPI(Railcraft.getModId(), error, ITrackInstance.class);
            }
        }
        return this.getExplosionResistance(exploder);
    }

    public boolean canBeReplacedByLeaves(IBlockAccess world, int x, int y, int z) {
        return false;
    }

    public boolean canCreatureSpawn(EnumCreatureType type, IBlockAccess world, int x, int y, int z) {
        return false;
    }

    @Override
    public IPostConnection.ConnectStyle connectsToPost(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        TileEntity tile = WorldPlugin.getBlockTile(world, x, y, z);
        try {
            ITrackInstance track;
            if (tile instanceof TileTrack && (track = ((TileTrack)tile).getTrackInstance()) instanceof IPostConnection) {
                return ((IPostConnection)((Object)track)).connectsToPost(world, x, y, z, side);
            }
        }
        catch (Error error) {
            Game.logErrorAPI(Railcraft.getModId(), error, IPostConnection.class, ITrackInstance.class);
        }
        return IPostConnection.ConnectStyle.NONE;
    }
}

