/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.tracks;

import mods.railcraft.api.carts.CartTools;
import mods.railcraft.client.util.textures.TextureAtlasSheet;
import mods.railcraft.common.blocks.tracks.MaterialElevator;
import mods.railcraft.common.blocks.tracks.TrackTools;
import mods.railcraft.common.plugins.forge.PowerPlugin;
import mods.railcraft.common.plugins.forge.WorldPlugin;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockTrackElevator
extends Block {
    public static double CLIMB_UP_VELOCITY = 0.2;
    public static double CLIMB_DOWN_VELOCITY = -0.3;
    public static double FALL_DOWN_CORRECTION = 0.04f;
    public static final int FACING_EAST_METADATA_VALUE = 2;
    public static final int FACING_WEST_METADATA_VALUE = 3;
    public static final int FACING_NORTH_METADATA_VALUE = 4;
    public static final int FACING_SOUTH_METADATA_VALUE = 5;
    public static final double RIDE_UP_VELOCITY = 0.4;
    public static final double RIDE_DOWN_VELOCITY = -0.4;
    public static final int BLOCK_FACING_DATA_METADATA_MASK = 7;
    private final int renderType;
    private IIcon[] texture;

    public BlockTrackElevator(int renderId) {
        super((Material)new MaterialElevator());
        this.setHardness(1.05f);
        this.setStepSound(soundTypeMetal);
        this.renderType = renderId;
        this.setCreativeTab(CreativeTabs.tabTransport);
    }

    public MovingObjectPosition collisionRayTrace(World world, int i, int j, int k, Vec3 vec3d, Vec3 vec3d1) {
        this.setBlockBoundsBasedOnState((IBlockAccess)world, i, j, k);
        return super.collisionRayTrace(world, i, j, k, vec3d, vec3d1);
    }

    public void setBlockBoundsBasedOnState(IBlockAccess world, int i, int j, int k) {
        int meta = this.getLadderFacingMetadata(world, i, j, k);
        float f = 0.125f;
        if (meta == 2) {
            this.setBlockBounds(0.0f, 0.0f, 1.0f - f, 1.0f, 1.0f, 1.0f);
        }
        if (meta == 3) {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, f);
        }
        if (meta == 4) {
            this.setBlockBounds(1.0f - f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        }
        if (meta == 5) {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, f, 1.0f, 1.0f);
        }
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int i, int j, int k) {
        return null;
    }

    public AxisAlignedBB getSelectedBoundingBoxFromPool(World world, int i, int j, int k) {
        this.setBlockBoundsBasedOnState((IBlockAccess)world, i, j, k);
        return AxisAlignedBB.getBoundingBox((double)((double)i + this.minX), (double)((double)j + this.minY), (double)((double)k + this.minZ), (double)((double)i + this.maxX), (double)((double)j + this.maxY), (double)((double)k + this.maxZ));
    }

    public int getRenderType() {
        return this.renderType;
    }

    public boolean isLadder(IBlockAccess world, int x, int y, int z, EntityLivingBase entity) {
        return true;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public boolean isACube() {
        return false;
    }

    public IIcon getIcon(int side, int meta) {
        boolean powered;
        boolean bl = powered = (meta & 8) != 0;
        if (powered) {
            return this.texture[0];
        }
        return this.texture[1];
    }

    public void registerBlockIcons(IIconRegister iconRegister) {
        this.texture = TextureAtlasSheet.unstitchIcons(iconRegister, "railcraft:tracks/track.elevator", 2);
    }

    public boolean canPlaceBlockAt(World world, int i, int j, int k) {
        if (world.isSideSolid(i - 1, j, k, ForgeDirection.EAST)) {
            return true;
        }
        if (world.isSideSolid(i + 1, j, k, ForgeDirection.WEST)) {
            return true;
        }
        if (world.isSideSolid(i, j, k - 1, ForgeDirection.SOUTH)) {
            return true;
        }
        return world.isSideSolid(i, j, k + 1, ForgeDirection.NORTH);
    }

    public int onBlockPlaced(World world, int x, int y, int z, int side, float par6, float par7, float par8, int meta) {
        if ((meta == 0 || side == 2) && world.isSideSolid(x, y, z + 1, ForgeDirection.NORTH)) {
            meta = 2;
        }
        if ((meta == 0 || side == 3) && world.isSideSolid(x, y, z - 1, ForgeDirection.SOUTH)) {
            meta = 3;
        }
        if ((meta == 0 || side == 4) && world.isSideSolid(x + 1, y, z, ForgeDirection.WEST)) {
            meta = 4;
        }
        if ((meta == 0 || side == 5) && world.isSideSolid(x - 1, y, z, ForgeDirection.EAST)) {
            meta = 5;
        }
        return meta;
    }

    public void onPostBlockPlaced(World world, int x, int y, int z, int meta) {
        boolean powered;
        Block block;
        BlockRailBase railBlock;
        this.setBlockBoundsBasedOnState((IBlockAccess)world, x, y, z);
        if (TrackTools.isRailBlockAt((IBlockAccess)world, x, y - 1, z) && (railBlock = (BlockRailBase)(block = WorldPlugin.getBlock((IBlockAccess)world, x, y - 1, z))).canMakeSlopes((IBlockAccess)world, x, y - 1, z)) {
            int trackMeta = railBlock.getBasicRailMetadata((IBlockAccess)world, null, x, y - 1, z);
            int ladderMeta = this.getLadderFacingMetadata((IBlockAccess)world, x, y, z);
            int outputMeta = 0;
            if (trackMeta == 0 && ladderMeta == 2) {
                outputMeta = 5;
            } else if (trackMeta == 0 && ladderMeta == 3) {
                outputMeta = 4;
            } else if (trackMeta == 1 && ladderMeta == 4) {
                outputMeta = 2;
            } else if (trackMeta == 1 && ladderMeta == 5) {
                outputMeta = 3;
            }
            if (outputMeta != 0) {
                if (railBlock.isPowered()) {
                    outputMeta |= world.getBlockMetadata(x, y - 1, z) & 8;
                }
                world.setBlockMetadataWithNotify(x, y - 1, z, outputMeta, 3);
            }
        }
        boolean bl = powered = ((meta = world.getBlockMetadata(x, y, z)) & 8) != 0;
        if (powered ^ this.isPowered(world, x, y, z)) {
            world.setBlockMetadataWithNotify(x, y, z, meta ^ 8, 3);
        }
        world.markBlockForUpdate(x, y, z);
    }

    public void dropBlockAsItemWithChance(World world, int i, int j, int k, int l, float f, int i1) {
        super.dropBlockAsItemWithChance(world, i, j, k, l, f, i1);
    }

    public void onNeighborBlockChange(World world, int i, int j, int k, Block block) {
        int meta = world.getBlockMetadata(i, j, k);
        int ladderMeta = this.getLadderFacingMetadata((IBlockAccess)world, i, j, k);
        boolean valid = false;
        if (ladderMeta == 2 && world.isSideSolid(i, j, k + 1, ForgeDirection.NORTH)) {
            valid = true;
        }
        if (ladderMeta == 3 && world.isSideSolid(i, j, k - 1, ForgeDirection.SOUTH)) {
            valid = true;
        }
        if (ladderMeta == 4 && world.isSideSolid(i + 1, j, k, ForgeDirection.WEST)) {
            valid = true;
        }
        if (ladderMeta == 5 && world.isSideSolid(i - 1, j, k, ForgeDirection.EAST)) {
            valid = true;
        }
        if (!valid) {
            this.dropBlockAsItem(world, i, j, k, ladderMeta, 0);
            world.setBlockToAir(i, j, k);
        } else {
            boolean powered;
            boolean bl = powered = (meta & 8) != 0;
            if (powered ^ this.isPowered(world, i, j, k)) {
                world.setBlockMetadataWithNotify(i, j, k, meta ^ 8, 3);
                world.markBlockForUpdate(i, j, k);
            }
        }
    }

    public void onEntityCollidedWithBlock(World world, int i, int j, int k, Entity entity) {
        entity.fallDistance = 0.0f;
        if (Game.isNotHost(world) || !(entity instanceof EntityMinecart)) {
            return;
        }
        this.minecartInteraction(world, (EntityMinecart)entity, i, j, k);
    }

    public int getLadderFacingMetadata(IBlockAccess world, int i, int j, int k) {
        return world.getBlockMetadata(i, j, k) & 7;
    }

    public boolean getPoweredBit(World world, int i, int j, int k) {
        return (world.getBlockMetadata(i, j, k) & 8) != 0;
    }

    protected boolean isPowered(World world, int x, int y, int z) {
        int meta = this.getLadderFacingMetadata((IBlockAccess)world, x, y, z);
        if (world.getBlock(x, y - 1, z) == this && meta == this.getLadderFacingMetadata((IBlockAccess)world, x, y - 1, z) && PowerPlugin.isBlockBeingPowered(world, x, y - 1, z)) {
            return true;
        }
        if (PowerPlugin.isBlockBeingPowered(world, x, y, z)) {
            return true;
        }
        return world.getBlock(x, y + 1, z) == this && meta == this.getLadderFacingMetadata((IBlockAccess)world, x, y + 1, z) && this.isPowered(world, x, y + 1, z);
    }

    protected void minecartInteraction(World world, EntityMinecart cart, int i, int j, int k) {
        cart.getEntityData().setByte("elevator", (byte)20);
        boolean powered = this.getPoweredBit(world, i, j, k);
        if (powered) {
            if (world.getBlock(i, j + 1, k) == this || this.isOffloadRail(world, i, j + 1, k)) {
                boolean empty = true;
                for (EntityMinecart c : CartTools.getMinecartsAt(world, i, j + 1, k, 0.2f)) {
                    if (c == cart) continue;
                    empty = false;
                }
                if ((this.getPoweredBit(world, i, j + 1, k) || this.isOffloadRail(world, i, j + 1, k)) && empty) {
                    cart.motionY = 0.4 + FALL_DOWN_CORRECTION;
                } else {
                    if (this.pushMinecartOntoRail(world, i, j, k, cart)) {
                        return;
                    }
                    cart.setPosition(cart.posX, (double)((float)j + 0.5f), cart.posZ);
                    cart.motionY = FALL_DOWN_CORRECTION;
                }
            } else {
                cart.setPosition(cart.posX, (double)((float)j + 0.5f), cart.posZ);
            }
        } else {
            if (world.getBlock(i, j - 1, k) != this) {
                this.pushMinecartOntoRail(world, i, j, k, cart);
                return;
            }
            boolean empty = true;
            for (EntityMinecart c : CartTools.getMinecartsAt(world, i, j - 1, k, 0.2f)) {
                if (c == cart) continue;
                empty = false;
            }
            if (empty) {
                cart.motionY = -0.4 + FALL_DOWN_CORRECTION;
            } else {
                cart.setPosition(cart.posX, (double)((float)j + 0.5f), cart.posZ);
                cart.motionY = FALL_DOWN_CORRECTION;
            }
        }
        if (powered || !TrackTools.isRailBlockAt((IBlockAccess)world, i, j - 1, k)) {
            if (TrackTools.isRailBlockAt((IBlockAccess)world, i, j - 1, k) || TrackTools.isRailBlockAt((IBlockAccess)world, i, j - 2, k)) {
                cart.setCanUseRail(false);
            } else {
                cart.setCanUseRail(true);
            }
            this.keepMinecartConnected(world, i, j, k, cart);
        } else {
            cart.setCanUseRail(true);
        }
        if (powered) {
            this.pushMinecartOnSupportingBlockIfPossible(world, i, j, k, cart);
        }
    }

    protected void keepMinecartConnected(World world, int x, int y, int z, EntityMinecart minecart) {
        minecart.motionX = (double)x + 0.5 - minecart.posX;
        minecart.motionZ = (double)z + 0.5 - minecart.posZ;
        this.allignMinecart(world, x, y, z, minecart);
    }

    protected void allignMinecart(World world, int x, int y, int z, EntityMinecart minecart) {
        switch (this.getLadderFacingMetadata((IBlockAccess)world, x, y, z)) {
            case 4: 
            case 5: {
                minecart.rotationYaw = minecart.rotationYaw <= 90.0f || minecart.rotationYaw > 270.0f ? 0.0f : 180.0f;
                return;
            }
            case 2: 
            case 3: {
                minecart.rotationYaw = minecart.rotationYaw > 180.0f ? 270.0f : 90.0f;
            }
        }
    }

    private boolean isOffloadRail(World world, int x, int y, int z) {
        if (world.getBlock(x, y, z) != this) {
            switch (world.getBlockMetadata(x, y - 1, z) & 7) {
                case 2: {
                    if (TrackTools.isRailBlockAt((IBlockAccess)world, x, y, z + 1)) {
                        return true;
                    }
                }
                case 3: {
                    if (TrackTools.isRailBlockAt((IBlockAccess)world, x, y, z - 1)) {
                        return true;
                    }
                }
                case 4: {
                    if (TrackTools.isRailBlockAt((IBlockAccess)world, x + 1, y, z)) {
                        return true;
                    }
                }
                case 5: {
                    if (!TrackTools.isRailBlockAt((IBlockAccess)world, x - 1, y, z)) break;
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    private boolean pushMinecartOnSupportingBlockIfPossible(World world, int i, int j, int k, EntityMinecart minecart) {
        if (!world.getBlock(i, j, k).getMaterial().isSolid()) {
            switch (world.getBlockMetadata(i, j, k) & 7) {
                case 2: {
                    if (TrackTools.isRailBlockAt((IBlockAccess)world, i, j + 1, k + 1)) {
                        minecart.motionY = 0.4;
                        minecart.motionZ = 0.4;
                    }
                    return true;
                }
                case 3: {
                    if (TrackTools.isRailBlockAt((IBlockAccess)world, i, j + 1, k - 1)) {
                        minecart.motionY = 0.4;
                        minecart.motionZ = -0.4;
                    }
                    return true;
                }
                case 4: {
                    if (TrackTools.isRailBlockAt((IBlockAccess)world, i + 1, j + 1, k)) {
                        minecart.motionY = 0.4;
                        minecart.motionX = 0.4;
                    }
                    return true;
                }
                case 5: {
                    if (TrackTools.isRailBlockAt((IBlockAccess)world, i - 1, j + 1, k)) {
                        minecart.motionY = 0.4;
                        minecart.motionX = -0.4;
                    }
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    private boolean pushMinecartOntoRail(World world, int i, int j, int k, EntityMinecart cart) {
        cart.setCanUseRail(true);
        switch (world.getBlockMetadata(i, j, k) & 7) {
            case 2: {
                if (!TrackTools.isRailBlockAt((IBlockAccess)world, i, j, k - 1)) break;
                cart.setPosition(cart.posX, (double)((float)j + 0.6f), cart.posZ);
                cart.motionY = FALL_DOWN_CORRECTION;
                cart.motionZ = -0.4;
                return true;
            }
            case 3: {
                if (!TrackTools.isRailBlockAt((IBlockAccess)world, i, j, k + 1)) break;
                cart.setPosition(cart.posX, (double)((float)j + 0.6f), cart.posZ);
                cart.motionY = FALL_DOWN_CORRECTION;
                cart.motionZ = 0.4;
                return true;
            }
            case 4: {
                if (!TrackTools.isRailBlockAt((IBlockAccess)world, i - 1, j, k)) break;
                cart.setPosition(cart.posX, (double)((float)j + 0.6f), cart.posZ);
                cart.motionY = FALL_DOWN_CORRECTION;
                cart.motionX = -0.4;
                return true;
            }
            case 5: {
                if (!TrackTools.isRailBlockAt((IBlockAccess)world, i + 1, j, k)) break;
                cart.setPosition(cart.posX, (double)((float)j + 0.6f), cart.posZ);
                cart.motionY = FALL_DOWN_CORRECTION;
                cart.motionX = 0.4;
                return true;
            }
            default: {
                return false;
            }
        }
        return false;
    }

    public boolean canBeReplacedByLeaves(IBlockAccess world, int x, int y, int z) {
        return false;
    }
}

