/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.tracks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mods.railcraft.api.core.items.ITrackItem;
import mods.railcraft.api.tracks.ITrackCustomPlaced;
import mods.railcraft.api.tracks.ITrackInstance;
import mods.railcraft.api.tracks.TrackRegistry;
import mods.railcraft.api.tracks.TrackSpec;
import mods.railcraft.common.blocks.RailcraftBlocks;
import mods.railcraft.common.blocks.tracks.TileTrack;
import mods.railcraft.common.blocks.tracks.TrackFactory;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class ItemTrack
extends ItemBlock
implements ITrackItem {
    public ItemTrack(Block block) {
        super(block);
        this.setMaxDamage(0);
        this.setHasSubtypes(true);
        this.setUnlocalizedName("railcraft.track");
    }

    public IIcon getIcon(ItemStack stack, int pass) {
        return this.getIconIndex(stack);
    }

    public IIcon getIconIndex(ItemStack stack) {
        TrackSpec trackSpec = this.getTrackSpec(stack);
        if (trackSpec == null) {
            return Blocks.rail.getIcon(0, 0);
        }
        return trackSpec.getItemIcon();
    }

    public TrackSpec getTrackSpec(ItemStack stack) {
        if (stack != null && stack.getItem() == this) {
            NBTTagCompound nbt = InvTools.getItemData(stack);
            if (nbt.hasKey("track")) {
                return TrackRegistry.getTrackSpec(nbt.getString("track"));
            }
            return TrackRegistry.getTrackSpec(-1);
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public int getSpriteNumber() {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister par1IconRegister) {
    }

    public int getMetadata(int i) {
        return 0;
    }

    public String getUnlocalizedName(ItemStack stack) {
        return "tile." + this.getTrackSpec(stack).getTrackTag().replace(':', '.');
    }

    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean advanced) {
        super.addInformation(stack, player, list, advanced);
        try {
            TrackSpec spec = this.getTrackSpec(stack);
            List<String> tips = spec.getItemToolTip();
            if (tips != null) {
                list.addAll(tips);
            }
        }
        catch (Throwable error) {
            Game.logErrorAPI("Railcraft", error, TrackSpec.class);
        }
    }

    @Override
    public Block getPlacedBlock() {
        return RailcraftBlocks.getBlockTrack();
    }

    @Override
    public boolean isPlacedTileEntity(ItemStack stack, TileEntity tile) {
        TileTrack track;
        return tile instanceof TileTrack && (track = (TileTrack)tile).getTrackInstance().getTrackSpec() == this.getTrackSpec(stack);
    }

    @Override
    public boolean placeTrack(ItemStack stack, World world, int i, int j, int k) {
        return this.placeTrack(stack, world, i, j, k, 1);
    }

    private boolean placeTrack(ItemStack stack, World world, int i, int j, int k, int side) {
        Block blockTrack = RailcraftBlocks.getBlockTrack();
        if (blockTrack == null) {
            return false;
        }
        if (j >= world.getHeight() - 1) {
            return false;
        }
        if (stack == null || !(stack.getItem() instanceof ItemTrack)) {
            return false;
        }
        TrackSpec spec = this.getTrackSpec(stack);
        ITrackInstance track = spec.createInstanceFromSpec();
        boolean canPlace = world.canPlaceEntityOnSide(blockTrack, i, j, k, true, side, null, stack);
        canPlace = track instanceof ITrackCustomPlaced ? (canPlace &= ((ITrackCustomPlaced)track).canPlaceRailAt(world, i, j, k)) : (canPlace &= world.isSideSolid(i, j - 1, k, ForgeDirection.UP));
        if (canPlace) {
            boolean placed = world.setBlock(i, j, k, blockTrack);
            if (placed) {
                if (world.getBlock(i, j, k) == blockTrack) {
                    TileTrack tile = TrackFactory.makeTrackTile(track);
                    world.setTileEntity(i, j, k, (TileEntity)tile);
                    blockTrack.onPostBlockPlaced(world, i, j, k, 0);
                    world.markBlockForUpdate(i, j, k);
                }
                world.playSoundEffect((double)((float)i + 0.5f), (double)((float)j + 0.5f), (double)((float)k + 0.5f), blockTrack.stepSound.getStepResourcePath(), (blockTrack.stepSound.getVolume() + 1.0f) / 2.0f, blockTrack.stepSound.getPitch() * 0.8f);
            }
            return true;
        }
        return false;
    }

    public boolean onItemUse(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float par8, float par9, float par10) {
        if (stack.stackSize <= 0) {
            return false;
        }
        Block block = world.getBlock(x, y, z);
        if (block == Blocks.snow_layer) {
            side = 1;
        } else if (block != Blocks.vine && block != Blocks.tallgrass && block != Blocks.deadbush && !block.isReplaceable((IBlockAccess)world, x, y, z)) {
            if (side == 0) {
                --y;
            }
            if (side == 1) {
                ++y;
            }
            if (side == 2) {
                --z;
            }
            if (side == 3) {
                ++z;
            }
            if (side == 4) {
                --x;
            }
            if (side == 5) {
                ++x;
            }
        }
        if (player != null && !player.canPlayerEdit(x, y, z, side, stack)) {
            return false;
        }
        boolean success = this.placeTrack(stack, world, x, y, z, side);
        if (success) {
            Block blockTrack = RailcraftBlocks.getBlockTrack();
            if (player != null) {
                blockTrack.onBlockPlacedBy(world, x, y, z, (EntityLivingBase)player, stack);
            }
            --stack.stackSize;
        }
        return success;
    }
}

