/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.tracks;

import mods.railcraft.api.tracks.ITrackReversable;
import mods.railcraft.common.blocks.tracks.EnumTrack;
import mods.railcraft.common.blocks.tracks.TrackLockingBase;
import mods.railcraft.common.blocks.tracks.TrackNextGenLocking;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.nbt.NBTTagCompound;

public class TrackBoarding
extends TrackLockingBase
implements ITrackReversable {
    protected boolean reversed = false;

    @Override
    public EnumTrack getTrackType() {
        return EnumTrack.BOARDING;
    }

    @Override
    public void updateEntity() {
        if (Game.isHost(this.getWorld())) {
            TrackNextGenLocking.LockingProfileType type = this.isReversed() ? TrackNextGenLocking.LockingProfileType.BOARDING_B : TrackNextGenLocking.LockingProfileType.BOARDING_A;
            this.migrateTrack(type);
        }
    }

    @Override
    public boolean isReversed() {
        return this.reversed;
    }

    @Override
    public void setReversed(boolean reversed) {
        this.reversed = reversed;
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.setBoolean("direction", this.reversed);
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.reversed = data.getBoolean("direction");
    }
}

