/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.tracks;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.railcraft.api.core.items.IToolCrowbar;
import mods.railcraft.api.tracks.ITrackPowered;
import mods.railcraft.common.blocks.tracks.EnumTrack;
import mods.railcraft.common.blocks.tracks.TrackBaseRailcraft;
import mods.railcraft.common.carts.EntityLocomotive;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;

public class TrackLocomotive
extends TrackBaseRailcraft
implements ITrackPowered {
    private boolean powered = false;
    private byte mode = 0;

    @Override
    public EnumTrack getTrackType() {
        return EnumTrack.LOCOMOTIVE;
    }

    @Override
    public IIcon getIcon() {
        if (this.isPowered()) {
            return this.getIcon(this.mode % EntityLocomotive.LocoMode.VALUES.length);
        }
        return this.getIcon(EntityLocomotive.LocoMode.VALUES.length + this.mode % EntityLocomotive.LocoMode.VALUES.length);
    }

    @Override
    public boolean blockActivated(EntityPlayer player) {
        IToolCrowbar crowbar;
        ItemStack current = player.getCurrentEquippedItem();
        if (current != null && current.getItem() instanceof IToolCrowbar && (crowbar = (IToolCrowbar)current.getItem()).canWhack(player, current, this.getX(), this.getY(), this.getZ())) {
            this.mode = (byte)(this.mode + 1);
            crowbar.onWhack(player, current, this.getX(), this.getY(), this.getZ());
            this.sendUpdateToClient();
            return true;
        }
        return false;
    }

    @Override
    public void onMinecartPass(EntityMinecart cart) {
        if (this.isPowered() && cart instanceof EntityLocomotive) {
            ((EntityLocomotive)cart).setMode(EntityLocomotive.LocoMode.VALUES[this.mode % EntityLocomotive.LocoMode.VALUES.length]);
        }
    }

    @Override
    public boolean isPowered() {
        return this.powered;
    }

    @Override
    public void setPowered(boolean powered) {
        this.powered = powered;
    }

    @Override
    public int getPowerPropagation() {
        return 8;
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.setBoolean("powered", this.powered);
        data.setByte("mode", this.mode);
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.powered = data.getBoolean("powered");
        this.mode = data.getByte("mode");
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeBoolean(this.powered);
        data.writeByte(this.mode);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.powered = data.readBoolean();
        this.mode = data.readByte();
        this.markBlockNeedsUpdate();
    }
}

