/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.tracks;

import mods.railcraft.api.tracks.ITrackInstance;
import mods.railcraft.common.blocks.tracks.EnumTrack;
import mods.railcraft.common.blocks.tracks.EnumTrackMeta;
import mods.railcraft.common.blocks.tracks.TrackBaseRailcraft;
import mods.railcraft.common.blocks.tracks.TrackTextureLoader;
import mods.railcraft.common.blocks.tracks.TrackTools;
import mods.railcraft.common.blocks.tracks.speedcontroller.SpeedControllerHighSpeed;
import mods.railcraft.common.carts.CartUtils;
import net.minecraft.block.Block;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class TrackSpeed
extends TrackBaseRailcraft {
    public static final float SPEED_CUTOFF = 0.39f;
    public Float maxSpeed;

    public TrackSpeed() {
        this.speedController = SpeedControllerHighSpeed.getInstance();
    }

    @Override
    public EnumTrack getTrackType() {
        return EnumTrack.SPEED;
    }

    @Override
    public IIcon getIcon() {
        int meta = this.tileEntity.getBlockMetadata();
        if (meta >= 6) {
            return TrackTextureLoader.INSTANCE.getTrackIcons(this.getTrackSpec())[1];
        }
        return TrackTextureLoader.INSTANCE.getTrackIcons(this.getTrackSpec())[0];
    }

    @Override
    public boolean isFlexibleRail() {
        return true;
    }

    @Override
    public void onNeighborBlockChange(Block block) {
        super.onNeighborBlockChange(block);
        this.maxSpeed = null;
    }

    @Override
    public void onMinecartPass(EntityMinecart cart) {
        TrackSpeed.testCartSpeedForBasic(this, cart);
    }

    protected static void testSafety(ITrackInstance track, EntityMinecart cart) {
        if (!TrackSpeed.isTrackSafeForHighSpeed(track, cart)) {
            CartUtils.explodeCart(cart);
        }
    }

    protected static boolean isTrackSafeForHighSpeed(ITrackInstance track, EntityMinecart cart) {
        EnumTrackMeta meta = EnumTrackMeta.fromMeta(track.getBasicRailMetadata(cart));
        World world = track.getWorld();
        int x = track.getX();
        int y = track.getY();
        int z = track.getZ();
        if (!meta.isStraightTrack()) {
            return false;
        }
        return meta.isNorthSouthTrack() ? !(!TrackSpeed.isTrackHighSpeedCapable(world, x, y, z + 1) && !TrackSpeed.isTrackHighSpeedCapable(world, x, y + 1, z + 1) && !TrackSpeed.isTrackHighSpeedCapable(world, x, y - 1, z + 1) || !TrackSpeed.isTrackHighSpeedCapable(world, x, y, z - 1) && !TrackSpeed.isTrackHighSpeedCapable(world, x, y + 1, z - 1) && !TrackSpeed.isTrackHighSpeedCapable(world, x, y - 1, z - 1)) : !(!meta.isEastWestTrack() || !TrackSpeed.isTrackHighSpeedCapable(world, x + 1, y, z) && !TrackSpeed.isTrackHighSpeedCapable(world, x + 1, y + 1, z) && !TrackSpeed.isTrackHighSpeedCapable(world, x + 1, y - 1, z) || !TrackSpeed.isTrackHighSpeedCapable(world, x - 1, y, z) && !TrackSpeed.isTrackHighSpeedCapable(world, x - 1, y + 1, z) && !TrackSpeed.isTrackHighSpeedCapable(world, x - 1, y - 1, z));
    }

    public static boolean isTrackHighSpeedCapable(World world, int x, int y, int z) {
        if (!world.blockExists(x, y, z)) {
            return true;
        }
        return TrackTools.isHighSpeedTrackAt((IBlockAccess)world, x, y, z);
    }

    protected static void testCartSpeedForBasic(ITrackInstance track, EntityMinecart cart) {
        boolean highSpeed = cart.getEntityData().getBoolean("HighSpeed");
        if (highSpeed) {
            TrackSpeed.testSafety(track, cart);
        } else {
            cart.motionX = Math.copySign(Math.min((double)0.39f, Math.abs(cart.motionX)), cart.motionX);
            cart.motionZ = Math.copySign(Math.min((double)0.39f, Math.abs(cart.motionZ)), cart.motionZ);
        }
    }

    protected static void testCartSpeedForBooster(ITrackInstance track, EntityMinecart cart) {
        boolean highSpeed = cart.getEntityData().getBoolean("HighSpeed");
        if (highSpeed) {
            TrackSpeed.testSafety(track, cart);
        } else if (TrackSpeed.isTrackSafeForHighSpeed(track, cart)) {
            if (Math.abs(cart.motionX) > (double)0.39f) {
                cart.motionX = Math.copySign((double)0.4f, cart.motionX);
                cart.getEntityData().setBoolean("HighSpeed", true);
            }
            if (Math.abs(cart.motionZ) > (double)0.39f) {
                cart.motionZ = Math.copySign((double)0.4f, cart.motionZ);
                cart.getEntityData().setBoolean("HighSpeed", true);
            }
        }
    }
}

