/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.tracks;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.railcraft.api.tracks.ITrackPowered;
import mods.railcraft.common.blocks.tracks.EnumTrack;
import mods.railcraft.common.blocks.tracks.TrackSpeed;
import mods.railcraft.common.blocks.tracks.TrackTextureLoader;
import mods.railcraft.common.carts.EntityLocomotive;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;

public class TrackSpeedBoost
extends TrackSpeed
implements ITrackPowered {
    private boolean powered = false;
    private static final double BOOST_AMOUNT = 0.06;
    private static final double SLOW_FACTOR = 0.65;
    private static final double BOOST_THRESHOLD = 0.01;

    @Override
    public EnumTrack getTrackType() {
        return EnumTrack.SPEED_BOOST;
    }

    @Override
    public IIcon getIcon() {
        if (!this.isPowered()) {
            return TrackTextureLoader.INSTANCE.getTrackIcons(this.getTrackSpec())[1];
        }
        return TrackTextureLoader.INSTANCE.getTrackIcons(this.getTrackSpec())[0];
    }

    @Override
    public int getPowerPropagation() {
        return 16;
    }

    @Override
    public void onMinecartPass(EntityMinecart cart) {
        TrackSpeedBoost.testCartSpeedForBooster(this, cart);
        if (this.powered) {
            double speed = Math.sqrt(cart.motionX * cart.motionX + cart.motionZ * cart.motionZ);
            if (speed > 0.01) {
                cart.motionX += cart.motionX / speed * 0.06;
                cart.motionZ += cart.motionZ / speed * 0.06;
            }
        } else {
            boolean highSpeed = cart.getEntityData().getBoolean("HighSpeed");
            if (highSpeed) {
                if (cart instanceof EntityLocomotive) {
                    ((EntityLocomotive)cart).forceIdle(20);
                }
                cart.motionX *= 0.65;
                cart.motionY = 0.0;
                cart.motionZ *= 0.65;
            } else {
                if (Math.abs(cart.motionX) > 0.0) {
                    cart.motionX = Math.copySign((double)0.38f, cart.motionX);
                }
                if (Math.abs(cart.motionZ) > 0.0) {
                    cart.motionZ = Math.copySign((double)0.38f, cart.motionZ);
                }
            }
        }
    }

    @Override
    public boolean isFlexibleRail() {
        return false;
    }

    @Override
    public boolean isPowered() {
        return this.powered;
    }

    @Override
    public void setPowered(boolean powered) {
        this.powered = powered;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.setBoolean("powered", this.powered);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.powered = nbttagcompound.getBoolean("powered");
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeBoolean(this.powered);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.powered = data.readBoolean();
        this.markBlockNeedsUpdate();
    }
}

