/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.tracks;

import mods.railcraft.api.tracks.ITrackCustomPlaced;
import mods.railcraft.common.blocks.RailcraftBlocks;
import mods.railcraft.common.blocks.tracks.EnumTrack;
import mods.railcraft.common.blocks.tracks.EnumTrackMeta;
import mods.railcraft.common.blocks.tracks.TrackTools;
import mods.railcraft.common.blocks.tracks.TrackUnsupported;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.block.Block;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TrackSuspended
extends TrackUnsupported
implements ITrackCustomPlaced {
    @Override
    public EnumTrack getTrackType() {
        return EnumTrack.SUSPENDED;
    }

    @Override
    public void onBlockPlaced() {
        super.onBlockPlaced();
        if (!this.isSupported()) {
            this.breakRail();
        }
    }

    @Override
    public void onNeighborBlockChange(Block block) {
        World world = this.getWorld();
        int i = this.tileEntity.xCoord;
        int j = this.tileEntity.yCoord;
        int k = this.tileEntity.zCoord;
        if (this.isSupported()) {
            Block myBlock = RailcraftBlocks.getBlockTrack();
            if (block != myBlock) {
                world.notifyBlocksOfNeighborChange(i + 1, j, k, myBlock);
                world.notifyBlocksOfNeighborChange(i - 1, j, k, myBlock);
                world.notifyBlocksOfNeighborChange(i, j, k + 1, myBlock);
                world.notifyBlocksOfNeighborChange(i, j, k - 1, myBlock);
            }
        } else {
            this.breakRail();
        }
    }

    public void breakRail() {
        if (Game.isHost(this.getWorld())) {
            this.getWorld().func_147480_a(this.tileEntity.xCoord, this.tileEntity.yCoord, this.tileEntity.zCoord, true);
        }
    }

    public boolean isSupportedRail(World world, int i, int j, int k, int meta) {
        if (!TrackTools.isRailBlockAt((IBlockAccess)world, i, j, k)) {
            return false;
        }
        if (this.isSupportedBelow(world, i, j, k)) {
            return true;
        }
        if (meta == EnumTrackMeta.NORTH_SOUTH.ordinal()) {
            if (this.isSupportedBelow(world, i, j, k + 1)) {
                return true;
            }
            return this.isSupportedBelow(world, i, j, k - 1);
        }
        if (meta == EnumTrackMeta.EAST_WEST.ordinal()) {
            if (this.isSupportedBelow(world, i + 1, j, k)) {
                return true;
            }
            return this.isSupportedBelow(world, i - 1, j, k);
        }
        return false;
    }

    public boolean isSupportedBelow(World world, int i, int j, int k) {
        if (!world.blockExists(i, j, k)) {
            return true;
        }
        if (TrackTools.isRailBlockAt((IBlockAccess)world, i, j, k)) {
            return world.isSideSolid(i, j - 1, k, ForgeDirection.UP);
        }
        return false;
    }

    public boolean isSupported() {
        int meta = this.tileEntity.getBlockMetadata();
        return this.isSupported(this.getWorld(), this.tileEntity.xCoord, this.tileEntity.yCoord, this.tileEntity.zCoord, meta);
    }

    public boolean isSupported(World world, int i, int j, int k, int meta) {
        if (this.isSupportedRail(world, i, j, k, meta)) {
            return true;
        }
        if (meta == EnumTrackMeta.NORTH_SOUTH.ordinal()) {
            return this.isSupportedRail(world, i, j, k + 1, meta) || this.isSupportedRail(world, i, j, k - 1, meta);
        }
        if (meta == EnumTrackMeta.EAST_WEST.ordinal()) {
            return this.isSupportedRail(world, i + 1, j, k, meta) || this.isSupportedRail(world, i - 1, j, k, meta);
        }
        return false;
    }

    @Override
    public boolean canPlaceRailAt(World world, int i, int j, int k) {
        if (this.isSupported(world, i, j, k, 0) || this.isSupported(world, i, j, k, 1)) {
            return true;
        }
        return world.isSideSolid(i, j - 1, k, ForgeDirection.UP);
    }
}

