/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.tracks;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import mods.railcraft.api.tracks.ISwitchDevice;
import mods.railcraft.api.tracks.ITrackSwitch;
import mods.railcraft.common.blocks.RailcraftTileEntity;
import mods.railcraft.common.blocks.tracks.EnumTrackMeta;
import mods.railcraft.common.blocks.tracks.TrackBaseRailcraft;
import mods.railcraft.common.blocks.tracks.TrackTools;
import mods.railcraft.common.carts.CartUtils;
import mods.railcraft.common.carts.LinkageManager;
import mods.railcraft.common.carts.Train;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.misc.MiscTools;
import net.minecraft.block.Block;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TrackSwitchBase
extends TrackBaseRailcraft
implements ITrackSwitch {
    private static final int SPRING_DURATION = 30;
    protected boolean mirrored;
    protected boolean shouldSwitch;
    protected Set<UUID> lockingCarts = new HashSet<UUID>();
    protected Set<UUID> springingCarts = new HashSet<UUID>();
    protected Set<UUID> decidingCarts = new HashSet<UUID>();
    private byte sprung;
    private byte locked;
    private UUID currentCart;
    private ISwitchDevice switchDevice;
    private boolean clientSwitched;

    @Override
    public boolean canMakeSlopes() {
        return false;
    }

    @Override
    public boolean canUpdate() {
        return true;
    }

    @Override
    public boolean isFlexibleRail() {
        return false;
    }

    @Override
    public boolean isMirrored() {
        return this.mirrored;
    }

    @Override
    public boolean isVisuallySwitched() {
        if (Game.isHost(this.getWorld())) {
            return !this.isLocked() && (this.shouldSwitch || this.isSprung());
        }
        return this.clientSwitched;
    }

    protected boolean shouldSwitchForCart(EntityMinecart cart) {
        boolean shouldSwitch;
        if (cart == null || Game.isNotHost(this.getWorld())) {
            return this.isVisuallySwitched();
        }
        if (this.springingCarts.contains(cart.getPersistentID())) {
            return true;
        }
        if (this.lockingCarts.contains(cart.getPersistentID())) {
            return false;
        }
        boolean sameTrain = Train.areInSameTrain(LinkageManager.instance().getCartFromUUID(this.currentCart), cart);
        boolean bl = shouldSwitch = this.switchDevice != null ? this.switchDevice.shouldSwitch(this, cart) : false;
        if (this.isSprung()) {
            return shouldSwitch || sameTrain;
        }
        if (this.isLocked()) {
            return shouldSwitch && !sameTrain;
        }
        return shouldSwitch;
    }

    private void springTrack(UUID cartOnTrack) {
        this.sprung = (byte)30;
        this.locked = 0;
        this.currentCart = cartOnTrack;
    }

    private void lockTrack(UUID cartOnTrack) {
        this.locked = (byte)30;
        this.sprung = 0;
        this.currentCart = cartOnTrack;
    }

    public boolean isLocked() {
        return this.locked > 0;
    }

    public boolean isSprung() {
        return this.sprung > 0;
    }

    @Override
    public void onBlockPlaced() {
        this.determineTrackMeta();
        this.determineMirror();
        ((RailcraftTileEntity)this.tileEntity).notifyBlocksOfNeighborChange();
    }

    @Override
    public void onBlockRemoved() {
        super.onBlockRemoved();
        ((RailcraftTileEntity)this.tileEntity).notifyBlocksOfNeighborChange();
    }

    protected void determineTrackMeta() {
        int x = this.tileEntity.xCoord;
        int y = this.tileEntity.yCoord;
        int z = this.tileEntity.zCoord;
        int meta = this.tileEntity.getBlockMetadata();
        if (TrackTools.isRailBlockAt((IBlockAccess)this.getWorld(), x + 1, y, z) && TrackTools.isRailBlockAt((IBlockAccess)this.getWorld(), x - 1, y, z)) {
            if (meta != EnumTrackMeta.EAST_WEST.ordinal()) {
                this.getWorld().setBlockMetadataWithNotify(x, y, z, EnumTrackMeta.EAST_WEST.ordinal(), 3);
            }
        } else if (TrackTools.isRailBlockAt((IBlockAccess)this.getWorld(), x, y, z + 1) && TrackTools.isRailBlockAt((IBlockAccess)this.getWorld(), x, y, z - 1)) {
            if (meta != EnumTrackMeta.NORTH_SOUTH.ordinal()) {
                this.getWorld().setBlockMetadataWithNotify(x, y, z, EnumTrackMeta.NORTH_SOUTH.ordinal(), 3);
            }
        } else if (meta != EnumTrackMeta.NORTH_SOUTH.ordinal()) {
            this.getWorld().setBlockMetadataWithNotify(x, y, z, EnumTrackMeta.NORTH_SOUTH.ordinal(), 3);
        }
    }

    protected void determineMirror() {
        int x = this.tileEntity.xCoord;
        int y = this.tileEntity.yCoord;
        int z = this.tileEntity.zCoord;
        int meta = this.tileEntity.getBlockMetadata();
        boolean prevValue = this.isMirrored();
        if (meta == EnumTrackMeta.NORTH_SOUTH.ordinal()) {
            int otherMeta;
            int ii = x;
            if (TrackTools.isRailBlockAt((IBlockAccess)this.getWorld(), x - 1, y, z)) {
                --ii;
                this.mirrored = true;
            } else {
                ++ii;
                this.mirrored = false;
            }
            if (TrackTools.isRailBlockAt((IBlockAccess)this.getWorld(), ii, y, z) && (otherMeta = this.getWorld().getBlockMetadata(ii, y, z)) == EnumTrackMeta.NORTH_SOUTH.ordinal()) {
                this.getWorld().setBlockMetadataWithNotify(ii, y, z, EnumTrackMeta.EAST_WEST.ordinal(), 3);
            }
        } else if (meta == EnumTrackMeta.EAST_WEST.ordinal()) {
            this.mirrored = TrackTools.isRailBlockAt((IBlockAccess)this.getWorld(), x, y, z - 1);
        }
        if (prevValue != this.isMirrored()) {
            this.sendUpdateToClient();
        }
    }

    @Override
    public void onNeighborBlockChange(Block block) {
        if (Game.isHost(this.getWorld())) {
            this.determineTrackMeta();
            this.determineMirror();
        }
        super.onNeighborBlockChange(block);
    }

    private void writeCartsToNBT(String key, Set<UUID> carts, NBTTagCompound data) {
        data.setByte(key + "Size", (byte)carts.size());
        int i = 0;
        for (UUID uuid : carts) {
            MiscTools.writeUUID(data, key + i++, uuid);
        }
    }

    private Set<UUID> readCartsFromNBT(String key, NBTTagCompound data) {
        HashSet<UUID> cartUUIDs = new HashSet<UUID>();
        String sizeKey = key + "Size";
        if (data.hasKey(sizeKey)) {
            int size = data.getByte(sizeKey);
            for (int i = 0; i < size; ++i) {
                UUID id = MiscTools.readUUID(data, key + i);
                if (id == null) continue;
                cartUUIDs.add(id);
            }
        }
        return cartUUIDs;
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.setBoolean("Direction", this.mirrored);
        data.setBoolean("Switched", this.shouldSwitch);
        data.setByte("sprung", this.sprung);
        data.setByte("locked", this.locked);
        this.writeCartsToNBT("springingCarts", this.springingCarts, data);
        this.writeCartsToNBT("lockingCarts", this.lockingCarts, data);
        this.writeCartsToNBT("decidingCarts", this.lockingCarts, data);
        MiscTools.writeUUID(data, "currentCart", this.currentCart);
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.mirrored = data.getBoolean("Direction");
        this.shouldSwitch = data.getBoolean("Switched");
        this.sprung = data.getByte("sprung");
        this.locked = data.getByte("locked");
        this.springingCarts = this.readCartsFromNBT("springingCarts", data);
        this.lockingCarts = this.readCartsFromNBT("lockingCarts", data);
        this.decidingCarts = this.readCartsFromNBT("decidingCarts", data);
        this.currentCart = MiscTools.readUUID(data, "currentCart");
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeBoolean(this.mirrored);
        data.writeBoolean(this.isVisuallySwitched());
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        boolean cs;
        super.readPacketData(data);
        boolean changed = false;
        boolean m = data.readBoolean();
        if (m != this.mirrored) {
            this.mirrored = m;
            changed = true;
        }
        if ((cs = data.readBoolean()) != this.clientSwitched) {
            this.clientSwitched = cs;
            changed = true;
        }
        if (changed) {
            this.switchDevice = this.getSwitchDevice();
            if (this.switchDevice != null) {
                this.switchDevice.updateArrows();
            }
            this.markBlockNeedsUpdate();
        }
    }

    private void updateSet(Set<UUID> setToUpdate, List<UUID> potentialUpdates, Set<UUID> reject1, Set<UUID> reject2) {
        for (UUID cartUUID : potentialUpdates) {
            reject1.remove(cartUUID);
            reject2.remove(cartUUID);
            setToUpdate.add(cartUUID);
        }
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        boolean wasSwitched = this.isVisuallySwitched();
        if (this.locked > 0) {
            this.locked = (byte)(this.locked - 1);
        }
        if (this.sprung > 0) {
            this.sprung = (byte)(this.sprung - 1);
        }
        if (this.locked == 0 && this.sprung == 0) {
            this.lockingCarts.clear();
            this.springingCarts.clear();
            this.decidingCarts.clear();
            this.currentCart = null;
        }
        this.updateSet(this.lockingCarts, this.getCartsAtLockEntrance(), this.springingCarts, this.decidingCarts);
        this.updateSet(this.springingCarts, this.getCartsAtSpringEntrance(), this.lockingCarts, this.decidingCarts);
        this.updateSet(this.decidingCarts, this.getCartsAtDecisionEntrance(), this.lockingCarts, this.springingCarts);
        List<UUID> cartsOnTrack = CartUtils.getMinecartUUIDsAt(this.getWorld(), this.tileEntity.xCoord, this.tileEntity.yCoord, this.tileEntity.zCoord, 0.3f);
        EntityMinecart bestCart = this.getBestCartForVisualState(cartsOnTrack);
        this.switchDevice = this.getSwitchDevice();
        this.shouldSwitch = this.switchDevice == null ? false : this.switchDevice.shouldSwitch(this, bestCart);
        if (bestCart != null && cartsOnTrack.contains(bestCart.getPersistentID())) {
            if (this.shouldSwitchForCart(bestCart)) {
                this.springTrack(bestCart.getPersistentID());
            } else {
                this.lockTrack(bestCart.getPersistentID());
            }
        }
        if (this.isVisuallySwitched() != wasSwitched) {
            if (this.switchDevice != null) {
                this.switchDevice.onSwitch(this.isVisuallySwitched());
            }
            this.sendUpdateToClient();
        }
    }

    private double crudeDistance(EntityMinecart cart) {
        double cx = (double)this.getX() + 0.5;
        double cz = (double)this.getZ() + 0.5;
        return Math.abs(cart.posX - cx) + Math.abs(cart.posZ - cz);
    }

    private EntityMinecart getBestCartForVisualState(List<UUID> cartsOnTrack) {
        UUID cartUUID = null;
        if (!cartsOnTrack.isEmpty()) {
            cartUUID = cartsOnTrack.get(0);
            return LinkageManager.instance().getCartFromUUID(cartUUID);
        }
        EntityMinecart closestCart = null;
        ArrayList<UUID> allCarts = new ArrayList<UUID>();
        allCarts.addAll(this.lockingCarts);
        allCarts.addAll(this.springingCarts);
        allCarts.addAll(this.decidingCarts);
        for (UUID testCartUUID : allCarts) {
            double testDist;
            if (closestCart == null) {
                closestCart = LinkageManager.instance().getCartFromUUID(testCartUUID);
                continue;
            }
            double closestDist = this.crudeDistance(closestCart);
            EntityMinecart testCart = LinkageManager.instance().getCartFromUUID(testCartUUID);
            if (testCart == null || !((testDist = this.crudeDistance(testCart)) < closestDist)) continue;
            closestCart = testCart;
        }
        return closestCart;
    }

    protected abstract List<UUID> getCartsAtLockEntrance();

    protected abstract List<UUID> getCartsAtSpringEntrance();

    protected abstract List<UUID> getCartsAtDecisionEntrance();

    public abstract ForgeDirection getActuatorLocation();

    public abstract ISwitchDevice.ArrowDirection getRedSignDirection();

    public abstract ISwitchDevice.ArrowDirection getWhiteSignDirection();

    public ISwitchDevice getSwitchDevice() {
        TileEntity entity = ((RailcraftTileEntity)this.tileEntity).getTileCache().getTileOnSide(this.getActuatorLocation());
        if (entity instanceof ISwitchDevice) {
            return (ISwitchDevice)entity;
        }
        return null;
    }
}

