/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.tracks;

import java.util.List;
import java.util.UUID;
import mods.railcraft.api.tracks.ISwitchDevice;
import mods.railcraft.common.blocks.tracks.EnumTrack;
import mods.railcraft.common.blocks.tracks.EnumTrackMeta;
import mods.railcraft.common.blocks.tracks.TrackSwitchBase;
import mods.railcraft.common.carts.CartUtils;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;

public class TrackWye
extends TrackSwitchBase {
    @Override
    public EnumTrack getTrackType() {
        return EnumTrack.WYE;
    }

    @Override
    public IIcon getIcon() {
        if (this.isVisuallySwitched()) {
            return this.getIcon(1);
        }
        return this.getIcon(0);
    }

    @Override
    public int getBasicRailMetadata(EntityMinecart cart) {
        int meta = this.tileEntity.getBlockMetadata();
        if (cart != null) {
            if (meta == EnumTrackMeta.NORTH_SOUTH.ordinal()) {
                meta = this.isMirrored() ? (this.shouldSwitchForCart(cart) ? EnumTrackMeta.WEST_NORTH_CORNER.ordinal() : EnumTrackMeta.WEST_SOUTH_CORNER.ordinal()) : (this.shouldSwitchForCart(cart) ? EnumTrackMeta.EAST_SOUTH_CORNER.ordinal() : EnumTrackMeta.EAST_NORTH_CORNER.ordinal());
            } else if (meta == EnumTrackMeta.EAST_WEST.ordinal()) {
                meta = this.isMirrored() ? (this.shouldSwitchForCart(cart) ? EnumTrackMeta.EAST_NORTH_CORNER.ordinal() : EnumTrackMeta.WEST_NORTH_CORNER.ordinal()) : (this.shouldSwitchForCart(cart) ? EnumTrackMeta.WEST_SOUTH_CORNER.ordinal() : EnumTrackMeta.EAST_SOUTH_CORNER.ordinal());
            }
        }
        return meta;
    }

    @Override
    protected List<UUID> getCartsAtLockEntrance() {
        int x = this.tileEntity.xCoord;
        int y = this.tileEntity.yCoord;
        int z = this.tileEntity.zCoord;
        int meta = this.tileEntity.getBlockMetadata();
        if (meta == EnumTrackMeta.EAST_WEST.ordinal()) {
            x = this.isMirrored() ? --x : ++x;
        } else if (meta == EnumTrackMeta.NORTH_SOUTH.ordinal()) {
            z = this.isMirrored() ? ++z : --z;
        }
        return CartUtils.getMinecartUUIDsAt(this.getWorld(), x, y, z, 0.1f);
    }

    @Override
    protected List<UUID> getCartsAtDecisionEntrance() {
        int x = this.tileEntity.xCoord;
        int y = this.tileEntity.yCoord;
        int z = this.tileEntity.zCoord;
        int meta = this.tileEntity.getBlockMetadata();
        if (meta == EnumTrackMeta.EAST_WEST.ordinal()) {
            z = this.isMirrored() ? --z : ++z;
        } else if (meta == EnumTrackMeta.NORTH_SOUTH.ordinal()) {
            x = this.isMirrored() ? --x : ++x;
        }
        return CartUtils.getMinecartUUIDsAt(this.getWorld(), x, y, z, 0.1f);
    }

    @Override
    protected List<UUID> getCartsAtSpringEntrance() {
        int x = this.tileEntity.xCoord;
        int y = this.tileEntity.yCoord;
        int z = this.tileEntity.zCoord;
        int meta = this.tileEntity.getBlockMetadata();
        if (meta == EnumTrackMeta.EAST_WEST.ordinal()) {
            x = this.isMirrored() ? ++x : --x;
        } else if (meta == EnumTrackMeta.NORTH_SOUTH.ordinal()) {
            z = this.isMirrored() ? --z : ++z;
        }
        return CartUtils.getMinecartUUIDsAt(this.getWorld(), x, y, z, 0.1f);
    }

    @Override
    public ISwitchDevice.ArrowDirection getRedSignDirection() {
        if (EnumTrackMeta.EAST_WEST.isEqual(this.tileEntity.getBlockMetadata())) {
            if (this.isVisuallySwitched()) {
                if (this.isMirrored()) {
                    return ISwitchDevice.ArrowDirection.WEST;
                }
                return ISwitchDevice.ArrowDirection.EAST;
            }
            if (this.isMirrored()) {
                return ISwitchDevice.ArrowDirection.EAST;
            }
            return ISwitchDevice.ArrowDirection.WEST;
        }
        if (this.isVisuallySwitched()) {
            if (this.isMirrored()) {
                return ISwitchDevice.ArrowDirection.NORTH;
            }
            return ISwitchDevice.ArrowDirection.SOUTH;
        }
        if (this.isMirrored()) {
            return ISwitchDevice.ArrowDirection.SOUTH;
        }
        return ISwitchDevice.ArrowDirection.NORTH;
    }

    @Override
    public ISwitchDevice.ArrowDirection getWhiteSignDirection() {
        if (EnumTrackMeta.EAST_WEST.isEqual(this.tileEntity.getBlockMetadata())) {
            if (this.isMirrored()) {
                return ISwitchDevice.ArrowDirection.NORTH;
            }
            return ISwitchDevice.ArrowDirection.SOUTH;
        }
        if (this.isMirrored()) {
            return ISwitchDevice.ArrowDirection.EAST;
        }
        return ISwitchDevice.ArrowDirection.WEST;
    }

    @Override
    public ForgeDirection getActuatorLocation() {
        ForgeDirection dir = ForgeDirection.NORTH;
        int meta = this.tileEntity.getBlockMetadata();
        if (meta == EnumTrackMeta.EAST_WEST.ordinal()) {
            dir = this.isMirrored() ? ForgeDirection.SOUTH : ForgeDirection.NORTH;
        } else if (meta == EnumTrackMeta.NORTH_SOUTH.ordinal()) {
            dir = this.isMirrored() ? ForgeDirection.EAST : ForgeDirection.WEST;
        }
        return dir;
    }
}

