/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.tracks.locking;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.railcraft.api.carts.CartTools;
import mods.railcraft.common.blocks.tracks.TrackNextGenLocking;
import mods.railcraft.common.blocks.tracks.locking.LockingProfile;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.nbt.NBTTagCompound;

public class HoldingLockingProfile
extends LockingProfile {
    protected static float DIR_THRESHOLD = 0.01f;
    protected boolean launchForward = true;

    public HoldingLockingProfile(TrackNextGenLocking track) {
        super(track);
    }

    @Override
    public void onLock(EntityMinecart cart) {
        super.onLock(cart);
        this.setLaunchDirection(cart);
    }

    @Override
    public void onRelease(EntityMinecart cart) {
        super.onRelease(cart);
        int meta = this.track.tileEntity.getBlockMetadata();
        double speed = CartTools.getCartSpeedUncapped(cart);
        double boostX = TrackNextGenLocking.START_BOOST;
        double boostZ = TrackNextGenLocking.START_BOOST;
        if (speed > 0.005) {
            boostX = Math.abs(cart.motionX) / speed * TrackNextGenLocking.BOOST_FACTOR;
            boostZ = Math.abs(cart.motionZ) / speed * TrackNextGenLocking.BOOST_FACTOR;
        }
        if (meta == 0 || meta == 4 || meta == 5) {
            cart.motionZ = this.launchForward ? (cart.motionZ += boostZ) : (cart.motionZ -= boostZ);
        } else if (meta == 1 || meta == 2 || meta == 3) {
            cart.motionX = this.launchForward ? (cart.motionX += boostX) : (cart.motionX -= boostX);
        }
    }

    protected void setLaunchDirection(EntityMinecart cart) {
        int meta = this.track.tileEntity.getBlockMetadata();
        double speed = CartTools.getCartSpeedUncapped(cart);
        if (speed > (double)DIR_THRESHOLD) {
            boolean launch = this.launchForward;
            if (meta == 0 || meta == 4 || meta == 5) {
                launch = cart.motionZ > 0.0;
            } else if (meta == 1 || meta == 2 || meta == 3) {
                boolean bl = launch = cart.motionX > 0.0;
            }
            if (this.launchForward != launch) {
                this.launchForward = launch;
                this.track.sendUpdateToClient();
            }
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.setBoolean("launchForward", this.launchForward);
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.launchForward = data.getBoolean("launchForward");
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeBoolean(this.launchForward);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.launchForward = data.readBoolean();
        this.track.markBlockNeedsUpdate();
    }
}

