/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.carts;

import cpw.mods.fml.common.eventhandler.Event;
import java.util.ArrayList;
import java.util.List;
import mods.railcraft.api.carts.IItemCart;
import mods.railcraft.common.carts.EnumCart;
import mods.railcraft.common.carts.IRailcraftCart;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.minecart.MinecartInteractEvent;

public abstract class CartBase
extends EntityMinecart
implements IRailcraftCart,
IItemCart {
    public CartBase(World world) {
        super(world);
        this.renderDistanceWeight = 4.0;
    }

    public CartBase(World world, double x, double y, double z) {
        super(world, x, y, z);
        this.renderDistanceWeight = 4.0;
    }

    @Override
    public void initEntityFromItem(ItemStack stack) {
    }

    public final boolean interactFirst(EntityPlayer player) {
        if (MinecraftForge.EVENT_BUS.post((Event)new MinecartInteractEvent((EntityMinecart)this, player))) {
            return true;
        }
        return this.doInteract(player);
    }

    public boolean doInteract(EntityPlayer player) {
        return true;
    }

    public abstract double getDrag();

    public ItemStack getCartItem() {
        ItemStack stack = EnumCart.fromCart(this).getCartItem();
        if (this.hasCustomInventoryName()) {
            stack.setStackDisplayName(this.getCommandSenderName());
        }
        return stack;
    }

    public List<ItemStack> getItemsDropped() {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        items.add(this.getCartItem());
        return items;
    }

    public void killMinecart(DamageSource par1DamageSource) {
        this.setDead();
        List<ItemStack> drops = this.getItemsDropped();
        if (this.func_95999_t() != null) {
            drops.get(0).setStackDisplayName(this.func_95999_t());
        }
        for (ItemStack item : drops) {
            this.entityDropItem(item, 0.0f);
        }
    }

    public int getMinecartType() {
        return -1;
    }

    @Override
    public boolean canPassItemRequests() {
        return false;
    }

    @Override
    public boolean canAcceptPushedItem(EntityMinecart requester, ItemStack stack) {
        return false;
    }

    @Override
    public boolean canProvidePulledItem(EntityMinecart requester, ItemStack stack) {
        return false;
    }
}

