/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.carts;

import mods.railcraft.api.carts.CartTools;
import mods.railcraft.common.carts.CartMaintenanceBase;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.inventory.StandaloneInventory;
import mods.railcraft.common.util.inventory.filters.ArrayStackFilter;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public abstract class CartMaintenancePatternBase
extends CartMaintenanceBase
implements ISidedInventory {
    protected final StandaloneInventory patternInv = new StandaloneInventory(6, (IInventory)this);

    public CartMaintenancePatternBase(World world) {
        super(world);
    }

    public IInventory getPattern() {
        return this.patternInv;
    }

    @Override
    public int getSizeInventory() {
        return 1;
    }

    public boolean canExtractItem(int slot, ItemStack stack, int side) {
        return false;
    }

    public boolean canInsertItem(int slot, ItemStack stack, int side) {
        return this.isItemValidForSlot(slot, stack);
    }

    protected void stockItems(int slotReplace, int slotStock) {
        ItemStack stackReplace = this.patternInv.getStackInSlot(slotReplace);
        ItemStack stackStock = this.getStackInSlot(slotStock);
        if (stackStock != null && !InvTools.isItemEqual(stackReplace, stackStock)) {
            CartTools.offerOrDropItem((EntityMinecart)this, stackStock);
            this.setInventorySlotContents(slotStock, null);
        }
        if (stackReplace == null) {
            return;
        }
        stackStock = this.getStackInSlot(slotStock);
        if (stackStock == null) {
            this.setInventorySlotContents(slotStock, CartTools.transferHelper.pullStack((EntityMinecart)this, new ArrayStackFilter(stackReplace)));
        }
    }

    protected void writeEntityToNBT(NBTTagCompound data) {
        super.writeEntityToNBT(data);
        this.patternInv.writeToNBT("patternInv", data);
    }

    protected void readEntityFromNBT(NBTTagCompound data) {
        super.readEntityFromNBT(data);
        this.patternInv.readFromNBT("patternInv", data);
    }
}

