/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.carts;

import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import mods.railcraft.api.carts.CartTools;
import mods.railcraft.api.carts.IMinecart;
import mods.railcraft.common.blocks.tracks.TrackTools;
import mods.railcraft.common.carts.ICartType;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.misc.MiscTools;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S1BPacketEntityAttach;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class CartUtils {
    public static Map<Item, ICartType> vanillaCartItemMap = new HashMap<Item, ICartType>();
    public static Map<Class<? extends EntityMinecart>, ICartType> classReplacements = new HashMap<Class<? extends EntityMinecart>, ICartType>();

    public static EntityMinecart placeCart(GameProfile owner, ItemStack cart, WorldServer world, int x, int y, int z) {
        if (cart == null) {
            return null;
        }
        ICartType vanillaType = vanillaCartItemMap.get((cart = cart.copy()).getItem());
        if (vanillaType != null) {
            return CartUtils.placeCart(vanillaType, owner, cart, (World)world, x, y, z);
        }
        return CartTools.placeCart(owner, cart, world, x, y, z);
    }

    public static EntityMinecart placeCart(ICartType cartType, GameProfile owner, ItemStack cartStack, World world, int i, int j, int k) {
        Block block = world.getBlock(i, j, k);
        if (TrackTools.isRailBlock(block) && !CartTools.isMinecartAt(world, i, j, k, 0.0f)) {
            EntityMinecart cart = cartType.makeCart(cartStack, world, (float)i + 0.5f, (float)j + 0.5f, (float)k + 0.5f);
            if (cartStack.hasDisplayName()) {
                cart.setMinecartName(cartStack.getDisplayName());
            }
            CartTools.setCartOwner(cart, owner);
            if (world.spawnEntityInWorld((Entity)cart)) {
                return cart;
            }
        }
        return null;
    }

    public static boolean doesCartMatchFilter(ItemStack stack, EntityMinecart cart) {
        if (stack == null) {
            return false;
        }
        if (cart instanceof IMinecart) {
            if (stack.hasDisplayName()) {
                return ((IMinecart)cart).doesCartMatchFilter(stack, cart) && stack.getDisplayName().equals(cart.getCartItem().getDisplayName());
            }
            return ((IMinecart)cart).doesCartMatchFilter(stack, cart);
        }
        ItemStack cartItem = cart.getCartItem();
        return cartItem != null && InvTools.isCartItemEqual(stack, cartItem, true);
    }

    public static void explodeCart(EntityMinecart cart) {
        if (cart.isDead) {
            return;
        }
        cart.getEntityData().setBoolean("HighSpeed", false);
        cart.motionX = 0.0;
        cart.motionZ = 0.0;
        if (Game.isNotHost(cart.worldObj)) {
            return;
        }
        if (cart.riddenByEntity != null) {
            cart.riddenByEntity.mountEntity((Entity)cart);
        }
        cart.worldObj.newExplosion((Entity)cart, cart.posX, cart.posY, cart.posZ, 3.0f, true, true);
        if (MiscTools.getRand().nextInt(2) == 0) {
            cart.setDead();
        }
    }

    public static boolean cartVelocityIsLessThan(EntityMinecart cart, float vel) {
        return Math.abs(cart.motionX) < (double)vel && Math.abs(cart.motionZ) < (double)vel;
    }

    public static List<EntityMinecart> getMinecartsIn(World world, AxisAlignedBB searchBox) {
        List entities = world.getEntitiesWithinAABB(EntityMinecart.class, searchBox);
        ArrayList<EntityMinecart> carts = new ArrayList<EntityMinecart>();
        for (Object o : entities) {
            EntityMinecart cart = (EntityMinecart)o;
            if (cart.isDead) continue;
            carts.add((EntityMinecart)o);
        }
        return carts;
    }

    public static List<UUID> getMinecartUUIDsAt(World world, int i, int j, int k, float sensitivity) {
        sensitivity = Math.min(sensitivity, 0.49f);
        List entities = world.getEntitiesWithinAABB(EntityMinecart.class, AxisAlignedBB.getBoundingBox((double)((float)i + sensitivity), (double)((float)j + sensitivity), (double)((float)k + sensitivity), (double)((float)(i + 1) - sensitivity), (double)((float)(j + 1) - sensitivity), (double)((float)(k + 1) - sensitivity)));
        ArrayList<UUID> carts = new ArrayList<UUID>();
        for (Object o : entities) {
            EntityMinecart cart = (EntityMinecart)o;
            if (cart.isDead) continue;
            carts.add(((EntityMinecart)o).getPersistentID());
        }
        return carts;
    }

    public static void dismount(EntityMinecart cart, double x, double y, double z) {
        if (cart.riddenByEntity == null) {
            return;
        }
        Entity rider = cart.riddenByEntity;
        rider.ridingEntity = null;
        cart.riddenByEntity = null;
        if (rider instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)rider;
            player.playerNetServerHandler.sendPacket((Packet)new S1BPacketEntityAttach(0, rider, null));
            player.setPositionAndUpdate(x, y, z);
        } else {
            rider.setLocationAndAngles(x, y, z, rider.rotationYaw, rider.rotationPitch);
        }
    }
}

