/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.carts;

import java.util.ArrayList;
import java.util.List;
import mods.railcraft.api.carts.IItemCart;
import mods.railcraft.common.carts.EntityCartFiltered;
import mods.railcraft.common.carts.EnumCart;
import mods.railcraft.common.carts.ICartType;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.fluids.FluidItemHelper;
import mods.railcraft.common.gui.EnumGui;
import mods.railcraft.common.gui.GuiHandler;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class EntityCartCargo
extends EntityCartFiltered
implements IItemCart {
    private static final byte SLOTS_FILLED_DATA_ID = 25;

    public EntityCartCargo(World world) {
        super(world);
    }

    public EntityCartCargo(World world, double d, double d1, double d2) {
        this(world);
        this.setPosition(d, d1 + (double)this.yOffset, d2);
        this.motionX = 0.0;
        this.motionY = 0.0;
        this.motionZ = 0.0;
        this.prevPosX = d;
        this.prevPosY = d1;
        this.prevPosZ = d2;
    }

    @Override
    public ICartType getCartType() {
        return EnumCart.CARGO;
    }

    @Override
    protected void entityInit() {
        super.entityInit();
        this.dataWatcher.addObject(25, (Object)new Integer(-1));
    }

    public int getSlotsFilled() {
        return this.dataWatcher.getWatchableObjectInt(25);
    }

    private void setSlotsFilled(int slotsFilled) {
        this.dataWatcher.updateObject(25, (Object)slotsFilled);
    }

    public void onUpdate() {
        super.onUpdate();
        if (Game.isHost(this.worldObj)) {
            this.setSlotsFilled(InvTools.countStacks((IInventory)this));
        }
    }

    @Override
    public List<ItemStack> getItemsDropped() {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        if (RailcraftConfig.doCartsBreakOnDrop()) {
            items.add(new ItemStack(Items.minecart));
            items.add(new ItemStack(Blocks.trapped_chest));
        } else {
            items.add(this.getCartItem());
        }
        return items;
    }

    @Override
    public boolean doInteract(EntityPlayer player) {
        if (Game.isHost(this.worldObj)) {
            GuiHandler.openGui(EnumGui.CART_CARGO, player, this.worldObj, (Entity)this);
        }
        return true;
    }

    public Block func_145820_n() {
        return null;
    }

    public int getDefaultDisplayTileOffset() {
        return 8;
    }

    public int getSizeInventory() {
        return 18;
    }

    public boolean isItemValidForSlot(int slot, ItemStack stack) {
        ItemStack filter = this.getFilterItem();
        if (!InvTools.isItemEqual(stack, filter)) {
            return false;
        }
        if (!RailcraftConfig.chestAllowLiquids()) {
            return this.getStackInSlot(slot) == null || !FluidItemHelper.isContainer(stack);
        }
        return true;
    }

    @Override
    public boolean canPassItemRequests() {
        return true;
    }

    @Override
    public boolean canAcceptPushedItem(EntityMinecart requester, ItemStack stack) {
        return true;
    }

    @Override
    public boolean canProvidePulledItem(EntityMinecart requester, ItemStack stack) {
        return true;
    }
}

