/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.carts;

import java.util.ArrayList;
import java.util.List;
import mods.railcraft.api.carts.IItemCart;
import mods.railcraft.common.carts.CartContainerBase;
import mods.railcraft.common.carts.EnumCart;
import mods.railcraft.common.carts.ICartType;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.fluids.FluidItemHelper;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.block.Block;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class EntityCartChest
extends CartContainerBase
implements IItemCart {
    public EntityCartChest(World world) {
        super(world);
    }

    public EntityCartChest(World world, double x, double y, double z) {
        super(world, x, y, z);
    }

    @Override
    public ICartType getCartType() {
        return EnumCart.CHEST;
    }

    @Override
    public List<ItemStack> getItemsDropped() {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        if (RailcraftConfig.doCartsBreakOnDrop()) {
            items.add(new ItemStack(Items.minecart));
            items.add(new ItemStack((Block)Blocks.chest));
        } else {
            items.add(this.getCartItem());
        }
        return items;
    }

    @Override
    public ItemStack getCartItem() {
        ItemStack stack = new ItemStack(Items.chest_minecart);
        if (this.hasCustomInventoryName()) {
            stack.setStackDisplayName(this.getCommandSenderName());
        }
        return stack;
    }

    @Override
    public boolean doInteract(EntityPlayer player) {
        if (Game.isHost(this.worldObj)) {
            player.displayGUIChest((IInventory)this);
        }
        return true;
    }

    @Override
    public int getMinecartType() {
        return 1;
    }

    public Block func_145820_n() {
        return Blocks.chest;
    }

    public int getDefaultDisplayTileOffset() {
        return 8;
    }

    public boolean canBeRidden() {
        return false;
    }

    public int getSizeInventory() {
        return 27;
    }

    @Override
    public String getInventoryName() {
        return "Chest Cart";
    }

    public boolean isItemValidForSlot(int slot, ItemStack stack) {
        if (!RailcraftConfig.chestAllowLiquids()) {
            return this.getStackInSlot(slot) == null || !FluidItemHelper.isContainer(stack);
        }
        return true;
    }

    @Override
    public boolean canPassItemRequests() {
        return true;
    }

    @Override
    public boolean canAcceptPushedItem(EntityMinecart requester, ItemStack stack) {
        return true;
    }

    @Override
    public boolean canProvidePulledItem(EntityMinecart requester, ItemStack stack) {
        return true;
    }
}

