/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.carts;

import java.util.ArrayList;
import java.util.List;
import mods.railcraft.api.carts.IMinecart;
import mods.railcraft.common.carts.CartContainerBase;
import mods.railcraft.common.carts.EnumCart;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.inventory.PhantomInventory;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public abstract class EntityCartFiltered
extends CartContainerBase
implements IMinecart {
    private static final byte FILTER_DATA_ID = 29;
    private final PhantomInventory invFilter = new PhantomInventory(1, (IInventory)this);

    public EntityCartFiltered(World world) {
        super(world);
    }

    public EntityCartFiltered(World world, double d, double d1, double d2) {
        this(world);
        this.setPosition(d, d1 + (double)this.yOffset, d2);
        this.motionX = 0.0;
        this.motionY = 0.0;
        this.motionZ = 0.0;
        this.prevPosX = d;
        this.prevPosY = d1;
        this.prevPosZ = d2;
    }

    protected void entityInit() {
        super.entityInit();
        this.dataWatcher.addObjectByDataType(29, 5);
    }

    public static ItemStack getFilterFromCartItem(ItemStack cart) {
        ItemStack filter = null;
        NBTTagCompound nbt = cart.getTagCompound();
        if (nbt != null) {
            NBTTagCompound filterNBT = nbt.getCompoundTag("filterStack");
            filter = ItemStack.loadItemStackFromNBT((NBTTagCompound)filterNBT);
        }
        return filter;
    }

    public static ItemStack addFilterToCartItem(ItemStack cart, ItemStack filter) {
        if (filter != null) {
            NBTTagCompound nbt = InvTools.getItemData(cart);
            NBTTagCompound filterNBT = new NBTTagCompound();
            filter.writeToNBT(filterNBT);
            nbt.setTag("filterStack", (NBTBase)filterNBT);
        }
        return cart;
    }

    public ItemStack getFilteredCartItem(ItemStack filter) {
        ItemStack stack = this.getCartType().getCartItem();
        return EntityCartFiltered.addFilterToCartItem(stack, filter);
    }

    @Override
    public void initEntityFromItem(ItemStack stack) {
        super.initEntityFromItem(stack);
        ItemStack filter = EntityCartFiltered.getFilterFromCartItem(stack);
        this.setFilter(filter);
    }

    @Override
    public ItemStack getCartItem() {
        ItemStack stack = this.getFilteredCartItem(this.getFilterItem());
        if (this.hasCustomInventoryName()) {
            stack.setStackDisplayName(this.getCommandSenderName());
        }
        return stack;
    }

    @Override
    public List<ItemStack> getItemsDropped() {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        items.add(this.getCartItem());
        return items;
    }

    public boolean canBeRidden() {
        return false;
    }

    protected void readEntityFromNBT(NBTTagCompound data) {
        super.readEntityFromNBT(data);
        this.invFilter.readFromNBT("invFilter", data);
    }

    protected void writeEntityToNBT(NBTTagCompound data) {
        super.writeEntityToNBT(data);
        this.invFilter.writeToNBT("invFilter", data);
    }

    public boolean hasFilter() {
        return this.getFilterItem() != null;
    }

    public ItemStack getFilterItem() {
        return this.dataWatcher.getWatchableObjectItemStack(29);
    }

    public PhantomInventory getFilterInv() {
        return this.invFilter;
    }

    public void setFilter(ItemStack filter) {
        this.getFilterInv().setInventorySlotContents(0, filter);
    }

    @Override
    public boolean doesCartMatchFilter(ItemStack stack, EntityMinecart cart) {
        return EnumCart.getCartType(stack) == this.getCartType();
    }

    public void markDirty() {
        super.markDirty();
        this.dataWatcher.updateObject(29, (Object)this.getFilterInv().getStackInSlot(0));
    }
}

