/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.carts;

import cpw.mods.fml.relauncher.ReflectionHelper;
import java.util.ArrayList;
import java.util.List;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.plugins.forge.FuelPlugin;
import mods.railcraft.common.util.inventory.InvTools;
import net.minecraft.entity.item.EntityMinecartFurnace;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public class EntityCartFurnace
extends EntityMinecartFurnace {
    private static final double DRAG_FACTOR = 0.99;
    private static final double PUSH_FACTOR = 0.1;

    public EntityCartFurnace(World world) {
        super(world);
    }

    public EntityCartFurnace(World world, double x, double y, double z) {
        super(world, x, y, z);
    }

    public List<ItemStack> getItemsDropped() {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        if (RailcraftConfig.doCartsBreakOnDrop()) {
            items.add(new ItemStack(Items.minecart));
            items.add(new ItemStack(Blocks.furnace));
        } else {
            items.add(this.getCartItem());
        }
        return items;
    }

    public void killMinecart(DamageSource par1DamageSource) {
        this.setDead();
        List<ItemStack> drops = this.getItemsDropped();
        if (this.func_95999_t() != null) {
            drops.get(0).setStackDisplayName(this.func_95999_t());
        }
        for (ItemStack item : drops) {
            this.entityDropItem(item, 0.0f);
        }
    }

    public ItemStack getCartItem() {
        ItemStack stack = new ItemStack(Items.furnace_minecart);
        if (this.hasCustomInventoryName()) {
            stack.setStackDisplayName(this.getCommandSenderName());
        }
        return stack;
    }

    public double getDrag() {
        return 0.99;
    }

    public boolean interactFirst(EntityPlayer player) {
        int burnTime;
        ItemStack stack;
        Integer fuel = (Integer)ReflectionHelper.getPrivateValue(EntityMinecartFurnace.class, (Object)((Object)this), (int)0);
        if (fuel <= 0 && (stack = player.inventory.getCurrentItem()) != null && (burnTime = FuelPlugin.getBurnTime(stack)) > 0) {
            if (!player.capabilities.isCreativeMode) {
                player.inventory.setInventorySlotContents(player.inventory.currentItem, InvTools.depleteItem(stack));
            }
            fuel = fuel + burnTime;
            ReflectionHelper.setPrivateValue(EntityMinecartFurnace.class, (Object)((Object)this), (Object)fuel, (int)0);
            this.pushX = this.posX - player.posX;
            this.pushZ = this.posZ - player.posZ;
        }
        return true;
    }
}

