/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.carts;

import java.util.ArrayList;
import java.util.List;
import mods.railcraft.api.carts.ICartContentsTextureProvider;
import mods.railcraft.common.carts.CartBase;
import mods.railcraft.common.carts.Train;
import mods.railcraft.common.gui.EnumGui;
import mods.railcraft.common.gui.GuiHandler;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public final class EntityCartRF
extends CartBase
implements ICartContentsTextureProvider {
    private static final int DATA_ID_RF = 25;
    private static final int RF_CAP = 2000000;

    public EntityCartRF(World world) {
        super(world);
    }

    public EntityCartRF(World world, double d, double d1, double d2) {
        this(world);
        this.setPosition(d, d1 + (double)this.yOffset, d2);
        this.motionX = 0.0;
        this.motionY = 0.0;
        this.motionZ = 0.0;
        this.prevPosX = d;
        this.prevPosY = d1;
        this.prevPosZ = d2;
    }

    protected void entityInit() {
        super.entityInit();
        this.dataWatcher.addObject(25, (Object)0);
    }

    public int addRF(int amount) {
        if (amount <= 0) {
            return 0;
        }
        if (this.getRF() >= 2000000) {
            return 0;
        }
        if (2000000 - this.getRF() >= amount) {
            this.setRF(this.getRF() + amount);
            return amount;
        }
        int used = 2000000 - this.getRF();
        this.setRF(2000000);
        return used;
    }

    public int removeRF(int request) {
        if (request <= 0) {
            return 0;
        }
        if (this.getRF() >= request) {
            this.setRF(this.getRF() - request);
            return request;
        }
        int ret = this.getRF();
        this.setRF(0);
        return ret;
    }

    public void setRF(int amount) {
        this.dataWatcher.updateObject(25, (Object)amount);
    }

    public int getRF() {
        return this.dataWatcher.getWatchableObjectInt(25);
    }

    public int getMaxRF() {
        return 2000000;
    }

    @Override
    public List<ItemStack> getItemsDropped() {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        items.add(this.getCartItem());
        return items;
    }

    public void onUpdate() {
        super.onUpdate();
        if (Game.isNotHost(this.worldObj)) {
            return;
        }
        if (this.getRF() > 2000000) {
            this.setRF(2000000);
        }
    }

    @Override
    public boolean doInteract(EntityPlayer player) {
        if (Game.isHost(this.worldObj)) {
            GuiHandler.openGui(EnumGui.CART_RF, player, this.worldObj, (Entity)this);
        }
        return true;
    }

    public boolean canBeRidden() {
        return false;
    }

    public final float getMaxCartSpeedOnRail() {
        int numLocomotives = Train.getTrain(this).getNumRunningLocomotives();
        if (numLocomotives == 0) {
            return super.getMaxCartSpeedOnRail();
        }
        return Math.min(1.2f, 0.08f + (float)(numLocomotives - 1) * 0.075f);
    }

    protected void readEntityFromNBT(NBTTagCompound nbt) {
        super.readEntityFromNBT(nbt);
        this.setRF(nbt.getInteger("rf"));
    }

    protected void writeEntityToNBT(NBTTagCompound nbt) {
        super.writeEntityToNBT(nbt);
        nbt.setInteger("rf", this.getRF());
    }

    @Override
    public double getDrag() {
        return 0.991999979019165;
    }

    @Override
    public IIcon getBlockTextureOnSide(int side) {
        return null;
    }
}

