/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.carts;

import mods.railcraft.common.blocks.tracks.EnumTrackMeta;
import mods.railcraft.common.carts.CartMaintenancePatternBase;
import mods.railcraft.common.carts.EntityTunnelBore;
import mods.railcraft.common.carts.EnumCart;
import mods.railcraft.common.carts.ICartType;
import mods.railcraft.common.gui.EnumGui;
import mods.railcraft.common.gui.GuiHandler;
import mods.railcraft.common.plugins.forge.LocalizationPlugin;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.common.util.ForgeDirection;

public class EntityCartTrackLayer
extends CartMaintenancePatternBase {
    public static final int SLOT_STOCK = 0;
    public static final int SLOT_REPLACE = 0;
    public static final int[] SLOTS = InvTools.buildSlotArray(0, 1);

    public EntityCartTrackLayer(World world) {
        super(world);
    }

    public EntityCartTrackLayer(World world, double d, double d1, double d2) {
        this(world);
        this.setPosition(d, d1 + (double)this.yOffset, d2);
        this.motionX = 0.0;
        this.motionY = 0.0;
        this.motionZ = 0.0;
        this.prevPosX = d;
        this.prevPosY = d1;
        this.prevPosZ = d2;
    }

    @Override
    public ICartType getCartType() {
        return EnumCart.TRACK_LAYER;
    }

    protected void func_145821_a(int trackX, int trackY, int trackZ, double maxSpeed, double slopeAdjustment, Block trackBlock, int trackMeta) {
        super.func_145821_a(trackX, trackY, trackZ, maxSpeed, slopeAdjustment, trackBlock, trackMeta);
        if (Game.isNotHost(this.worldObj)) {
            return;
        }
        this.stockItems(0, 0);
        this.updateTravelDirection(trackX, trackY, trackZ, trackMeta);
        if (this.travelDirection != ForgeDirection.UNKNOWN) {
            this.placeTrack(trackX, trackY, trackZ);
        }
    }

    private void placeTrack(int x, int y, int z) {
        x += this.travelDirection.offsetX;
        z += this.travelDirection.offsetZ;
        EnumTrackMeta trackMeta = EnumTrackMeta.NORTH_SOUTH;
        if (this.travelDirection == ForgeDirection.EAST || this.travelDirection == ForgeDirection.WEST) {
            trackMeta = EnumTrackMeta.EAST_WEST;
        }
        if (!this.isValidReplacementBlock(x, y, z) && this.isValidReplacementBlock(x, y + 1, z) && trackMeta.isStraightTrack()) {
            ++y;
        }
        if (this.isValidReplacementBlock(x, y, z) && this.isValidReplacementBlock(x, y - 1, z)) {
            --y;
            if (this.travelDirection == ForgeDirection.NORTH) {
                trackMeta = EnumTrackMeta.SOUTH_SLOPE;
            }
            if (this.travelDirection == ForgeDirection.SOUTH) {
                trackMeta = EnumTrackMeta.NORTH_SLOPE;
            }
            if (this.travelDirection == ForgeDirection.WEST) {
                trackMeta = EnumTrackMeta.EAST_SLOPE;
            }
            if (this.travelDirection == ForgeDirection.EAST) {
                trackMeta = EnumTrackMeta.WEST_SLOPE;
            }
        }
        if (this.isValidNewTrackPosition(x, y, z)) {
            Block block = this.worldObj.getBlock(x, y, z);
            int metadata = this.worldObj.getBlockMetadata(x, y, z);
            if (this.placeNewTrack(x, y, z, 0, trackMeta.ordinal())) {
                block.dropBlockAsItem(this.worldObj, x, y, z, metadata, 0);
            }
        }
    }

    private boolean isValidNewTrackPosition(int x, int y, int z) {
        return this.isValidReplacementBlock(x, y, z) && World.doesBlockHaveSolidTopSurface((IBlockAccess)this.worldObj, (int)x, (int)(y - 1), (int)z);
    }

    private boolean isValidReplacementBlock(int x, int y, int z) {
        Block block = this.worldObj.getBlock(x, y, z);
        return this.worldObj.isAirBlock(x, y, z) || block instanceof IPlantable || block instanceof IShearable || EntityTunnelBore.replaceableBlocks.contains(block) || block.isReplaceable((IBlockAccess)this.worldObj, x, y, z);
    }

    public int[] getAccessibleSlotsFromSide(int p_94128_1_) {
        return SLOTS;
    }

    @Override
    public boolean doInteract(EntityPlayer player) {
        if (Game.isHost(this.worldObj)) {
            GuiHandler.openGui(EnumGui.CART_TRACK_LAYER, player, this.worldObj, (Entity)this);
        }
        return true;
    }

    public boolean isItemValidForSlot(int slot, ItemStack stack) {
        ItemStack trackReplace = this.patternInv.getStackInSlot(0);
        return InvTools.isItemEqual(stack, trackReplace);
    }

    @Override
    public String getInventoryName() {
        return LocalizationPlugin.translate(EnumCart.TRACK_LAYER.getTag());
    }
}

