/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.carts;

import java.util.EnumSet;
import mods.railcraft.api.core.items.ITrackItem;
import mods.railcraft.api.tracks.ITrackTile;
import mods.railcraft.common.blocks.tracks.TrackSuspended;
import mods.railcraft.common.blocks.tracks.TrackTools;
import mods.railcraft.common.carts.CartMaintenancePatternBase;
import mods.railcraft.common.carts.EnumCart;
import mods.railcraft.common.carts.ICartType;
import mods.railcraft.common.gui.EnumGui;
import mods.railcraft.common.gui.GuiHandler;
import mods.railcraft.common.plugins.forge.LocalizationPlugin;
import mods.railcraft.common.plugins.forge.WorldPlugin;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class EntityCartTrackRelayer
extends CartMaintenancePatternBase {
    private static final int SLOT_STOCK = 0;
    private static final int SLOT_EXIST = 0;
    private static final int SLOT_REPLACE = 1;
    private static final int[] SLOTS = InvTools.buildSlotArray(0, 1);

    public EntityCartTrackRelayer(World world) {
        super(world);
    }

    public EntityCartTrackRelayer(World world, double d, double d1, double d2) {
        this(world);
        this.setPosition(d, d1 + (double)this.yOffset, d2);
        this.motionX = 0.0;
        this.motionY = 0.0;
        this.motionZ = 0.0;
        this.prevPosX = d;
        this.prevPosY = d1;
        this.prevPosZ = d2;
    }

    @Override
    public ICartType getCartType() {
        return EnumCart.TRACK_RELAYER;
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (Game.isNotHost(this.worldObj)) {
            return;
        }
        this.stockItems(1, 0);
        this.replace();
    }

    private void replace() {
        Block block;
        int k;
        int j;
        int i = MathHelper.floor_double((double)this.posX);
        if (TrackTools.isRailBlockAt((IBlockAccess)this.worldObj, i, (j = MathHelper.floor_double((double)this.posY)) - 1, k = MathHelper.floor_double((double)this.posZ))) {
            --j;
        }
        if (TrackTools.isRailBlock(block = this.worldObj.getBlock(i, j, k))) {
            ItemStack trackExist = this.patternInv.getStackInSlot(0);
            ItemStack trackStock = this.getStackInSlot(0);
            boolean nextToSuspended = false;
            for (ForgeDirection side : EnumSet.of(ForgeDirection.EAST, ForgeDirection.WEST, ForgeDirection.NORTH, ForgeDirection.SOUTH)) {
                ITrackTile track;
                TileEntity tile = WorldPlugin.getTileEntityOnSide(this.worldObj, i, j, k, side);
                if (!(tile instanceof ITrackTile) || !((track = (ITrackTile)tile).getTrackInstance() instanceof TrackSuspended)) continue;
                nextToSuspended = true;
                break;
            }
            if (nextToSuspended) {
                return;
            }
            if (trackExist != null && trackStock != null) {
                int meta;
                if (trackExist.getItem() instanceof ITrackItem) {
                    int meta2;
                    TileEntity tile;
                    ITrackItem trackItem = (ITrackItem)trackExist.getItem();
                    if (trackItem.getPlacedBlock() == block && trackItem.isPlacedTileEntity(trackExist, tile = this.worldObj.getTileEntity(i, j, k)) && (meta2 = this.removeOldTrack(i, j, k, block)) != -1) {
                        this.placeNewTrack(i, j, k, 0, meta2);
                    }
                } else if (InvTools.isStackEqualToBlock(trackExist, block) && (meta = this.removeOldTrack(i, j, k, block)) != -1) {
                    this.placeNewTrack(i, j, k, 0, meta);
                }
            }
        }
    }

    @Override
    public boolean doInteract(EntityPlayer player) {
        if (Game.isHost(this.worldObj)) {
            GuiHandler.openGui(EnumGui.CART_TRACK_RELAYER, player, this.worldObj, (Entity)this);
        }
        return true;
    }

    @Override
    public String getInventoryName() {
        return LocalizationPlugin.translate(EnumCart.TRACK_RELAYER.getTag());
    }

    public int[] getAccessibleSlotsFromSide(int side) {
        return SLOTS;
    }

    public boolean isItemValidForSlot(int slot, ItemStack stack) {
        ItemStack trackReplace = this.patternInv.getStackInSlot(1);
        return InvTools.isItemEqual(stack, trackReplace);
    }
}

