/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.carts;

import java.util.ArrayList;
import java.util.List;
import mods.railcraft.common.carts.CartBase;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.gui.EnumGui;
import mods.railcraft.common.gui.GuiHandler;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class EntityCartWork
extends CartBase {
    public EntityCartWork(World world) {
        super(world);
    }

    public EntityCartWork(World world, double d, double d1, double d2) {
        this(world);
        this.setPosition(d, d1 + (double)this.yOffset, d2);
        this.motionX = 0.0;
        this.motionY = 0.0;
        this.motionZ = 0.0;
        this.prevPosX = d;
        this.prevPosY = d1;
        this.prevPosZ = d2;
    }

    @Override
    public List<ItemStack> getItemsDropped() {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        if (RailcraftConfig.doCartsBreakOnDrop()) {
            items.add(new ItemStack(Items.minecart));
            items.add(new ItemStack(Blocks.crafting_table));
        } else {
            items.add(this.getCartItem());
        }
        return items;
    }

    @Override
    public boolean doInteract(EntityPlayer entityplayer) {
        if (Game.isHost(this.worldObj)) {
            GuiHandler.openGui(EnumGui.CART_WORK, entityplayer, this.worldObj, (Entity)this);
        }
        return true;
    }

    public boolean canBeRidden() {
        return false;
    }

    public Block func_145820_n() {
        return Blocks.crafting_table;
    }

    @Override
    public double getDrag() {
        return 0.991999979019165;
    }
}

