/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.carts;

import cpw.mods.fml.common.eventhandler.Event;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mods.railcraft.api.carts.CartTools;
import mods.railcraft.api.carts.ILinkableCart;
import mods.railcraft.api.carts.bore.IBoreHead;
import mods.railcraft.api.carts.bore.IMineable;
import mods.railcraft.api.tracks.RailTools;
import mods.railcraft.common.blocks.tracks.EnumTrackMeta;
import mods.railcraft.common.blocks.tracks.TrackTools;
import mods.railcraft.common.carts.CartContainerBase;
import mods.railcraft.common.carts.EntityTunnelBorePart;
import mods.railcraft.common.carts.EnumCart;
import mods.railcraft.common.carts.ICartType;
import mods.railcraft.common.carts.Train;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.gui.EnumGui;
import mods.railcraft.common.gui.GuiHandler;
import mods.railcraft.common.plugins.forge.FuelPlugin;
import mods.railcraft.common.plugins.forge.HarvestPlugin;
import mods.railcraft.common.plugins.forge.PlayerPlugin;
import mods.railcraft.common.util.collections.BlockKey;
import mods.railcraft.common.util.collections.BlockSet;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.inventory.filters.StackFilter;
import mods.railcraft.common.util.inventory.wrappers.InventoryMapper;
import mods.railcraft.common.util.misc.BallastRegistry;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.misc.MiscTools;
import mods.railcraft.common.util.misc.RailcraftDamageSource;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.world.BlockEvent;

public class EntityTunnelBore
extends CartContainerBase
implements IInventory,
ILinkableCart {
    public static final float SPEED = 0.03f;
    public static final float LENGTH = 6.2f;
    public static final int MAX_FILL_DEPTH = 10;
    public static final int FAIL_DELAY = 200;
    public static final int STANDARD_DELAY = 5;
    public static final int LAYER_DELAY = 40;
    public static final int BALLAST_DELAY = 10;
    public static final int FUEL_CONSUMPTION = 12;
    public static final float HARDNESS_MULTIPLER = 8.0f;
    public static final BlockSet mineableBlocks = new BlockSet();
    public static final Set<Block> replaceableBlocks = new HashSet<Block>();
    protected static final int WATCHER_ID_FUEL = 16;
    protected static final int WATCHER_ID_MOVING = 25;
    protected static final int WATCHER_ID_BORE_HEAD = 26;
    protected static final int WATCHER_ID_FACING = 5;
    private static final Block[] mineable = new Block[]{Blocks.clay, Blocks.snow_layer, Blocks.cactus, Blocks.carrots, Blocks.cobblestone, Blocks.mossy_cobblestone, Blocks.cocoa, Blocks.wheat, Blocks.deadbush, Blocks.dirt, Blocks.fire, Blocks.glowstone, Blocks.grass, Blocks.gravel, Blocks.ice, Blocks.leaves, Blocks.melon_block, Blocks.melon_stem, Blocks.brown_mushroom, Blocks.brown_mushroom_block, Blocks.red_mushroom, Blocks.red_mushroom_block, Blocks.mycelium, Blocks.nether_wart, Blocks.netherrack, Blocks.obsidian, Blocks.coal_ore, Blocks.diamond_ore, Blocks.emerald_ore, Blocks.gold_ore, Blocks.iron_ore, Blocks.lapis_ore, Blocks.redstone_ore, Blocks.lit_redstone_ore, Blocks.red_flower, Blocks.yellow_flower, Blocks.potatoes, Blocks.pumpkin, Blocks.pumpkin_stem, Blocks.reeds, Blocks.sand, Blocks.sandstone, Blocks.sapling, Blocks.soul_sand, Blocks.snow, Blocks.stone, Blocks.tallgrass, Blocks.farmland, Blocks.torch, Blocks.vine, Blocks.waterlily, Blocks.web, Blocks.end_stone, Blocks.log, Blocks.log2};
    private static final Block[] replaceable = new Block[]{Blocks.torch, Blocks.tallgrass, Blocks.deadbush, Blocks.vine, Blocks.brown_mushroom, Blocks.red_mushroom, Blocks.yellow_flower, Blocks.red_flower, Blocks.double_plant};
    protected final IInventory invFuel = new InventoryMapper(this, 1, 6);
    protected final IInventory invBallast = new InventoryMapper(this, 7, 9);
    protected final IInventory invRails = new InventoryMapper(this, 16, 9);
    protected boolean degreeCalc = false;
    protected int delay = 0;
    protected boolean placeRail = false;
    protected boolean placeBallast = false;
    protected boolean boreLayer = false;
    protected int boreRotationAngle = 0;
    private boolean active;
    private int clock = MiscTools.getRand().nextInt();
    private int burnTime;
    private int fuel;
    private boolean hasInit = true;
    private EntityTunnelBorePart[] partArray;
    private EntityTunnelBorePart partHead1 = new EntityTunnelBorePart(this, "head1", 1.9f, 2.6f, 2.0f, -0.6f);
    private EntityTunnelBorePart partHead2 = new EntityTunnelBorePart(this, "head2", 1.9f, 2.6f, 2.0f, 0.6f);
    private EntityTunnelBorePart partBody = new EntityTunnelBorePart(this, "body", 2.0f, 1.9f, 0.6f);
    private EntityTunnelBorePart partTail1 = new EntityTunnelBorePart(this, "tail1", 1.6f, 1.4f, -1.0f);
    private EntityTunnelBorePart partTail2 = new EntityTunnelBorePart(this, "tail2", 1.6f, 1.4f, -2.2f);

    public EntityTunnelBore(World world, double i, double j, double k) {
        this(world, i, j, k, ForgeDirection.SOUTH);
    }

    public EntityTunnelBore(World world, double i, double j, double k, ForgeDirection f) {
        super(world);
        this.partArray = new EntityTunnelBorePart[]{this.partHead1, this.partHead2, this.partBody, this.partTail1, this.partTail2};
        this.setPosition(i, j + (double)this.yOffset, k);
        this.motionX = 0.0;
        this.motionY = 0.0;
        this.motionZ = 0.0;
        this.prevPosX = i;
        this.prevPosY = j;
        this.prevPosZ = k;
        this.setFacing(f);
        this.setSize(6.2f, 4.0f);
    }

    public EntityTunnelBore(World world) {
        this(world, 0.0, 0.0, 0.0, ForgeDirection.SOUTH);
    }

    public static void addMineableBlock(Block block) {
        EntityTunnelBore.addMineableBlock(block, -1);
    }

    public static void addMineableBlock(Block block, int meta) {
        mineableBlocks.add(new BlockKey(block, meta));
    }

    public static boolean canHeadHarvestBlock(ItemStack head, Block block, int meta) {
        if (head == null) {
            return false;
        }
        if (head.getItem() instanceof IBoreHead) {
            IBoreHead boreHead = (IBoreHead)head.getItem();
            boolean mappingExists = false;
            int blockHarvestLevel = HarvestPlugin.getBlockHarvestLevel(block, meta, "pickaxe");
            if (blockHarvestLevel > -1) {
                if (boreHead.getHarvestLevel() >= blockHarvestLevel) {
                    return true;
                }
                mappingExists = true;
            }
            if ((blockHarvestLevel = HarvestPlugin.getBlockHarvestLevel(block, meta, "axe")) > -1) {
                if (boreHead.getHarvestLevel() >= blockHarvestLevel) {
                    return true;
                }
                mappingExists = true;
            }
            if ((blockHarvestLevel = HarvestPlugin.getBlockHarvestLevel(block, meta, "shovel")) > -1) {
                if (boreHead.getHarvestLevel() >= blockHarvestLevel) {
                    return true;
                }
                mappingExists = true;
            }
            if (mappingExists) {
                return false;
            }
        }
        return true;
    }

    @Override
    public ICartType getCartType() {
        return EnumCart.BORE;
    }

    private boolean isMinableBlock(Block block, int meta) {
        if (RailcraftConfig.boreMinesAllBlocks()) {
            return true;
        }
        return mineableBlocks.contains(block, meta);
    }

    protected void entityInit() {
        super.entityInit();
        this.dataWatcher.addObject(16, (Object)0);
        this.dataWatcher.addObject(25, (Object)0);
        this.dataWatcher.addObjectByDataType(26, 5);
        this.dataWatcher.addObject(5, (Object)0);
    }

    public boolean isMinecartPowered() {
        return this.dataWatcher.getWatchableObjectByte(16) != 0;
    }

    public void setMinecartPowered(boolean powered) {
        this.dataWatcher.updateObject(16, (Object)((byte)(powered ? 1 : 0)));
    }

    public boolean attackEntityFrom(DamageSource source, float damage) {
        if (!this.worldObj.isRemote && !this.isDead) {
            boolean flag;
            if (this.isEntityInvulnerable()) {
                return false;
            }
            this.setRollingDirection(-this.getRollingDirection());
            this.setRollingAmplitude(10);
            this.setBeenAttacked();
            this.setDamage(this.getDamage() + damage * 10.0f);
            boolean bl = flag = source.getEntity() instanceof EntityPlayer && ((EntityPlayer)source.getEntity()).capabilities.isCreativeMode;
            if (flag || this.getDamage() > 120.0f) {
                if (this.riddenByEntity != null) {
                    this.riddenByEntity.mountEntity((Entity)this);
                }
                if (flag && !this.hasCustomInventoryName()) {
                    this.setDead();
                } else {
                    this.killMinecart(source);
                }
            }
            return true;
        }
        return true;
    }

    private void setYaw() {
        float yaw = 0.0f;
        switch (this.getFacing()) {
            case NORTH: {
                yaw = 90.0f;
                break;
            }
            case EAST: {
                yaw = 0.0f;
                break;
            }
            case SOUTH: {
                yaw = 270.0f;
                break;
            }
            case WEST: {
                yaw = 180.0f;
            }
        }
        this.setRotation(yaw, this.rotationPitch);
    }

    public int getSizeInventory() {
        return 25;
    }

    public boolean canBePushed() {
        return false;
    }

    public void setPosition(double i, double j, double k) {
        if (!this.hasInit) {
            super.setPosition(i, j, k);
            return;
        }
        this.posX = i;
        this.posY = j;
        this.posZ = k;
        double w = 1.35;
        double h = 2.7;
        double l = 3.1f;
        double x1 = i;
        double x2 = i;
        double z1 = k;
        double z2 = k;
        if (this.getFacing() == ForgeDirection.WEST || this.getFacing() == ForgeDirection.EAST) {
            x1 -= l;
            x2 += l;
            z1 -= w;
            z2 += w;
        } else {
            x1 -= w;
            x2 += w;
            z1 -= l;
            z2 += l;
        }
        this.boundingBox.setBounds(x1, j - (double)this.yOffset + (double)this.ySize, z1, x2, j - (double)this.yOffset + (double)this.ySize + h, z2);
    }

    public void onUpdate() {
        ++this.clock;
        if (Game.isHost(this.worldObj)) {
            if (this.clock % 64 == 0) {
                this.forceUpdateBoreHead();
                this.setMinecartPowered(false);
                this.setMoving(false);
            }
            this.stockBallast();
            this.stockTracks();
        }
        super.onUpdate();
        for (EntityTunnelBorePart part : this.partArray) {
            part.onUpdate();
        }
        if (Game.isHost(this.worldObj)) {
            this.updateFuel();
            if (this.hasFuel() && this.getDelay() == 0) {
                boolean placed;
                int z;
                float offset;
                this.setActive(true);
                int y = MathHelper.floor_double((double)this.posY);
                EnumTrackMeta dir = EnumTrackMeta.NORTH_SOUTH;
                if (this.getFacing() == ForgeDirection.WEST || this.getFacing() == ForgeDirection.EAST) {
                    dir = EnumTrackMeta.EAST_WEST;
                }
                if (this.getDelay() == 0) {
                    offset = 1.5f;
                    int x = MathHelper.floor_double((double)this.getXAhead(this.posX, offset));
                    z = MathHelper.floor_double((double)this.getZAhead(this.posZ, offset));
                    if (this.placeBallast) {
                        placed = this.placeBallast(x, y - 1, z);
                        if (placed) {
                            this.setDelay(5);
                        } else {
                            this.setDelay(200);
                            this.setActive(false);
                        }
                        this.placeBallast = false;
                    } else if (!this.worldObj.isSideSolid(x, y - 1, z, ForgeDirection.UP)) {
                        this.placeBallast = true;
                        this.setDelay(10);
                    }
                }
                if (this.getDelay() == 0) {
                    offset = 0.8f;
                    int x = MathHelper.floor_double((double)this.getXAhead(this.posX, offset));
                    z = MathHelper.floor_double((double)this.getZAhead(this.posZ, offset));
                    if (this.placeRail) {
                        placed = this.placeTrack(x, y, z, dir);
                        if (placed) {
                            this.setDelay(5);
                        } else {
                            this.setDelay(200);
                            this.setActive(false);
                        }
                        this.placeRail = false;
                    } else if (TrackTools.isRailBlockAt((IBlockAccess)this.worldObj, x, y, z)) {
                        if (!dir.isEqual(TrackTools.getTrackMeta((IBlockAccess)this.worldObj, (EntityMinecart)this, x, y, z))) {
                            this.worldObj.setBlockMetadataWithNotify(x, y, z, dir.ordinal(), 3);
                            this.setDelay(5);
                        }
                    } else if (this.worldObj.isAirBlock(x, y, z) || replaceableBlocks.contains(this.worldObj.getBlock(x, y, z))) {
                        this.placeRail = true;
                        this.setDelay(5);
                    } else {
                        this.setDelay(200);
                        this.setActive(false);
                    }
                }
                if (this.getDelay() == 0) {
                    offset = 3.3f;
                    int x = MathHelper.floor_double((double)this.getXAhead(this.posX, offset));
                    z = MathHelper.floor_double((double)this.getZAhead(this.posZ, offset));
                    if (this.boreLayer) {
                        boolean bored = this.boreLayer(x, y, z, dir);
                        if (bored) {
                            this.setDelay(40);
                        } else {
                            this.setDelay(200);
                            this.setActive(false);
                        }
                        this.boreLayer = false;
                    } else if (this.checkForLava(x, y, z, dir)) {
                        this.setDelay(200);
                        this.setActive(false);
                    } else {
                        this.setDelay((int)Math.ceil(this.getLayerHardness(x, y, z, dir)));
                        if (this.getDelay() != 0) {
                            this.boreLayer = true;
                        }
                    }
                }
            }
            if (this.isMinecartPowered()) {
                double i = this.getXAhead(this.posX, 3.3);
                double k = this.getZAhead(this.posZ, 3.3);
                double size = 0.8;
                List entities = this.worldObj.getEntitiesWithinAABBExcludingEntity((Entity)this, AxisAlignedBB.getBoundingBox((double)(i - size), (double)this.posY, (double)(k - size), (double)(i + size), (double)(this.posY + 2.0), (double)(k + size)));
                for (Object e : entities) {
                    if (!(e instanceof EntityLivingBase)) continue;
                    EntityLivingBase ent = (EntityLivingBase)e;
                    ent.attackEntityFrom((DamageSource)RailcraftDamageSource.BORE, 2.0f);
                }
            }
            this.setMoving(this.hasFuel() && this.getDelay() == 0);
            if (this.getDelay() > 0) {
                this.setDelay(this.getDelay() - 1);
            }
        }
        if (this.isMoving()) {
            float factorX = MathHelper.cos((float)((float)Math.toRadians(this.rotationYaw)));
            float factorZ = -MathHelper.sin((float)((float)Math.toRadians(this.rotationYaw)));
            this.motionX = 0.03f * factorX;
            this.motionZ = 0.03f * factorZ;
        } else {
            this.motionX = 0.0;
            this.motionZ = 0.0;
        }
        this.emitParticles();
        if (this.isMinecartPowered()) {
            this.boreRotationAngle += 5;
        }
    }

    public float getMaxCartSpeedOnRail() {
        return 0.03f;
    }

    private void updateFuel() {
        if (Game.isHost(this.worldObj)) {
            if (this.isMinecartPowered()) {
                this.spendFuel();
            }
            this.stockFuel();
            if (this.outOfFuel()) {
                this.addFuel();
            }
            this.setMinecartPowered(this.hasFuel() && this.isActive());
        }
    }

    protected double getXAhead(double x, double offset) {
        if (this.getFacing() == ForgeDirection.EAST) {
            x += offset;
        } else if (this.getFacing() == ForgeDirection.WEST) {
            x -= offset;
        }
        return x;
    }

    protected double getZAhead(double z, double offset) {
        if (this.getFacing() == ForgeDirection.NORTH) {
            z -= offset;
        } else if (this.getFacing() == ForgeDirection.SOUTH) {
            z += offset;
        }
        return z;
    }

    protected double getOffsetX(double x, double forwardOffset, double sideOffset) {
        switch (this.getFacing()) {
            case NORTH: {
                return x + sideOffset;
            }
            case SOUTH: {
                return x - sideOffset;
            }
            case EAST: {
                return x + forwardOffset;
            }
            case WEST: {
                return x - forwardOffset;
            }
        }
        return x;
    }

    protected double getOffsetZ(double z, double forwardOffset, double sideOffset) {
        switch (this.getFacing()) {
            case NORTH: {
                return z - forwardOffset;
            }
            case SOUTH: {
                return z + forwardOffset;
            }
            case EAST: {
                return z - sideOffset;
            }
            case WEST: {
                return z + sideOffset;
            }
        }
        return z;
    }

    protected void emitParticles() {
        if (this.isMinecartPowered()) {
            double randomFactor = 0.125;
            double forwardOffset = -0.35;
            double smokeYOffset = 2.4;
            double flameYOffset = 0.7;
            double smokeSideOffset = 0.92;
            double flameSideOffset = 1.14;
            double smokeX1 = this.posX;
            double smokeX2 = this.posX;
            double smokeZ1 = this.posZ;
            double smokeZ2 = this.posZ;
            double flameX1 = this.posX;
            double flameX2 = this.posX;
            double flameZ1 = this.posZ;
            double flameZ2 = this.posZ;
            if (this.getFacing() == ForgeDirection.NORTH) {
                smokeX1 += smokeSideOffset;
                smokeX2 -= smokeSideOffset;
                smokeZ1 += forwardOffset;
                smokeZ2 += forwardOffset;
                flameX1 += flameSideOffset;
                flameX2 -= flameSideOffset;
                flameZ1 += forwardOffset + this.rand.nextGaussian() * randomFactor;
                flameZ2 += forwardOffset + this.rand.nextGaussian() * randomFactor;
            } else if (this.getFacing() == ForgeDirection.EAST) {
                smokeX1 -= forwardOffset;
                smokeX2 -= forwardOffset;
                smokeZ1 += smokeSideOffset;
                smokeZ2 -= smokeSideOffset;
                flameX1 -= forwardOffset + this.rand.nextGaussian() * randomFactor;
                flameX2 -= forwardOffset + this.rand.nextGaussian() * randomFactor;
                flameZ1 += flameSideOffset;
                flameZ2 -= flameSideOffset;
            } else if (this.getFacing() == ForgeDirection.SOUTH) {
                smokeX1 += smokeSideOffset;
                smokeX2 -= smokeSideOffset;
                smokeZ1 -= forwardOffset;
                smokeZ2 -= forwardOffset;
                flameX1 += flameSideOffset;
                flameX2 -= flameSideOffset;
                flameZ1 -= forwardOffset + this.rand.nextGaussian() * randomFactor;
                flameZ2 -= forwardOffset + this.rand.nextGaussian() * randomFactor;
            } else if (this.getFacing() == ForgeDirection.WEST) {
                smokeX1 += forwardOffset;
                smokeX2 += forwardOffset;
                smokeZ1 += smokeSideOffset;
                smokeZ2 -= smokeSideOffset;
                flameX1 += forwardOffset + this.rand.nextGaussian() * randomFactor;
                flameX2 += forwardOffset + this.rand.nextGaussian() * randomFactor;
                flameZ1 += flameSideOffset;
                flameZ2 -= flameSideOffset;
            }
            if (this.rand.nextInt(4) == 0) {
                this.worldObj.spawnParticle("largesmoke", smokeX1, this.posY + smokeYOffset, smokeZ1, 0.0, 0.0, 0.0);
                this.worldObj.spawnParticle("flame", flameX1, this.posY + flameYOffset + this.rand.nextGaussian() * randomFactor, flameZ1, 0.0, 0.0, 0.0);
            }
            if (this.rand.nextInt(4) == 0) {
                this.worldObj.spawnParticle("largesmoke", smokeX2, this.posY + smokeYOffset, smokeZ2, 0.0, 0.0, 0.0);
                this.worldObj.spawnParticle("flame", flameX2, this.posY + flameYOffset + this.rand.nextGaussian() * randomFactor, flameZ2, 0.0, 0.0, 0.0);
            }
        }
    }

    protected void stockBallast() {
        ItemStack stack;
        if (InvTools.isEmptySlot(this.invBallast) && (stack = CartTools.transferHelper.pullStack((EntityMinecart)this, StackFilter.BALLAST)) != null) {
            InvTools.moveItemStack(stack, this.invBallast);
        }
    }

    protected boolean placeBallast(int i, int j, int k) {
        if (!this.worldObj.isSideSolid(i, j, k, ForgeDirection.UP)) {
            for (int inv = 0; inv < this.invBallast.getSizeInventory(); ++inv) {
                ItemStack stack = this.invBallast.getStackInSlot(inv);
                if (stack == null || !BallastRegistry.isItemBallast(stack)) continue;
                for (int y = j; y > j - 10; --y) {
                    if (!this.worldObj.isSideSolid(i, y, k, ForgeDirection.UP)) continue;
                    this.invBallast.decrStackSize(inv, 1);
                    this.worldObj.setBlock(i, j, k, InvTools.getBlockFromStack(stack), stack.getItemDamage(), 3);
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    protected void stockTracks() {
        ItemStack stack;
        if (InvTools.isEmptySlot(this.invRails) && (stack = CartTools.transferHelper.pullStack((EntityMinecart)this, StackFilter.TRACK)) != null) {
            InvTools.moveItemStack(stack, this.invRails);
        }
    }

    protected boolean placeTrack(int x, int y, int z, EnumTrackMeta meta) {
        Block block = this.worldObj.getBlock(x, y, z);
        if (replaceableBlocks.contains(block)) {
            this.worldObj.func_147480_a(x, y, z, true);
        }
        if (this.worldObj.isAirBlock(x, y, z) && this.worldObj.isSideSolid(x, y - 1, z, ForgeDirection.UP)) {
            for (int inv = 0; inv < this.invRails.getSizeInventory(); ++inv) {
                ItemStack stack = this.invRails.getStackInSlot(inv);
                if (stack == null) continue;
                boolean placed = RailTools.placeRailAt(stack, this.worldObj, x, y, z);
                if (placed) {
                    this.worldObj.setBlockMetadataWithNotify(x, y, z, meta.ordinal(), 3);
                    this.invRails.decrStackSize(inv, 1);
                }
                return placed;
            }
        }
        return false;
    }

    protected boolean checkForLava(int i, int j, int k, EnumTrackMeta dir) {
        int xStart = i - 1;
        int zStart = k - 1;
        int xEnd = i + 1;
        int zEnd = k + 1;
        if (dir == EnumTrackMeta.NORTH_SOUTH) {
            xStart = i - 2;
            xEnd = i + 2;
        } else {
            zStart = k - 2;
            zEnd = k + 2;
        }
        for (int jj = j; jj < j + 4; ++jj) {
            for (int ii = xStart; ii <= xEnd; ++ii) {
                for (int kk = zStart; kk <= zEnd; ++kk) {
                    Block block = this.worldObj.getBlock(ii, jj, kk);
                    if (block != Blocks.lava && block != Blocks.flowing_lava) continue;
                    return true;
                }
            }
        }
        return false;
    }

    protected boolean boreLayer(int i, int j, int k, EnumTrackMeta dir) {
        int jj;
        boolean clear = true;
        int ii = i;
        int kk = k;
        for (jj = j; jj < j + 3; ++jj) {
            clear = clear && this.mineBlock(ii, jj, kk, dir);
        }
        if (dir == EnumTrackMeta.NORTH_SOUTH) {
            --ii;
        } else {
            --kk;
        }
        for (jj = j; jj < j + 3; ++jj) {
            clear = clear && this.mineBlock(ii, jj, kk, dir);
        }
        ii = i;
        kk = k;
        if (dir == EnumTrackMeta.NORTH_SOUTH) {
            ++ii;
        } else {
            ++kk;
        }
        for (jj = j; jj < j + 3; ++jj) {
            clear = clear && this.mineBlock(ii, jj, kk, dir);
        }
        return clear;
    }

    protected boolean mineBlock(int x, int y, int z, EnumTrackMeta dir) {
        int trackMeta;
        if (this.worldObj.isAirBlock(x, y, z)) {
            return true;
        }
        Block block = this.worldObj.getBlock(x, y, z);
        if (TrackTools.isRailBlock(block) ? dir.isEqual(trackMeta = TrackTools.getTrackMeta((IBlockAccess)this.worldObj, block, (EntityMinecart)this, x, y, z)) : block == Blocks.torch) {
            return true;
        }
        ItemStack head = this.getStackInSlot(0);
        if (head == null) {
            return false;
        }
        int meta = this.worldObj.getBlockMetadata(x, y, z);
        if (!this.canMineBlock(x, y, z, block, meta)) {
            return false;
        }
        BlockEvent.BreakEvent breakEvent = new BlockEvent.BreakEvent(x, y, z, this.worldObj, block, meta, PlayerPlugin.getFakePlayer((WorldServer)this.worldObj, this.posX, this.posY, this.posZ));
        MinecraftForge.EVENT_BUS.post((Event)breakEvent);
        if (breakEvent.isCanceled()) {
            return false;
        }
        ArrayList items = block.getDrops(this.worldObj, x, y, z, meta, 0);
        for (ItemStack stack : items) {
            if (StackFilter.FUEL.matches(stack)) {
                stack = InvTools.moveItemStack(stack, this.invFuel);
            }
            if (stack != null && stack.stackSize > 0 && InvTools.isStackEqualToBlock(stack, Blocks.gravel)) {
                stack = InvTools.moveItemStack(stack, this.invBallast);
            }
            if (stack != null && stack.stackSize > 0) {
                stack = CartTools.transferHelper.pushStack((EntityMinecart)this, stack);
            }
            if (stack == null || stack.stackSize <= 0 || RailcraftConfig.boreDestroysBlocks()) continue;
            float f = 0.7f;
            double xr = ((double)this.worldObj.rand.nextFloat() - 0.5) * (double)f;
            double yr = ((double)this.worldObj.rand.nextFloat() - 0.5) * (double)f;
            double zr = ((double)this.worldObj.rand.nextFloat() - 0.5) * (double)f;
            EntityItem entityitem = new EntityItem(this.worldObj, this.getXAhead(this.posX, -3.2) + xr, this.posY + 0.3 + yr, this.getZAhead(this.posZ, -3.2) + zr, stack);
            this.worldObj.spawnEntityInWorld((Entity)entityitem);
        }
        this.worldObj.setBlockToAir(x, y, z);
        head.setItemDamage(head.getItemDamage() + 1);
        if (head.getItemDamage() > head.getMaxDamage()) {
            this.setInventorySlotContents(0, null);
        }
        return true;
    }

    private boolean canMineBlock(int i, int j, int k, Block block, int meta) {
        ItemStack head = this.getStackInSlot(0);
        if (block instanceof IMineable) {
            if (head == null) {
                return false;
            }
            return ((IMineable)block).canMineBlock(this.worldObj, i, j, k, (EntityMinecart)this, head);
        }
        if (block.getBlockHardness(this.worldObj, i, j, k) < 0.0f) {
            return false;
        }
        return this.isMinableBlock(block, meta) && EntityTunnelBore.canHeadHarvestBlock(head, block, meta);
    }

    protected float getLayerHardness(int i, int j, int k, EnumTrackMeta dir) {
        int jj;
        float hardness = 0.0f;
        int ii = i;
        int kk = k;
        for (jj = j; jj < j + 3; ++jj) {
            hardness += this.getBlockHardness(ii, jj, kk, dir);
        }
        if (dir == EnumTrackMeta.NORTH_SOUTH) {
            --ii;
        } else {
            --kk;
        }
        for (jj = j; jj < j + 3; ++jj) {
            hardness += this.getBlockHardness(ii, jj, kk, dir);
        }
        ii = i;
        kk = k;
        if (dir == EnumTrackMeta.NORTH_SOUTH) {
            ++ii;
        } else {
            ++kk;
        }
        for (jj = j; jj < j + 3; ++jj) {
            hardness += this.getBlockHardness(ii, jj, kk, dir);
        }
        hardness *= 8.0f;
        ItemStack boreSlot = this.getStackInSlot(0);
        if (boreSlot != null && boreSlot.getItem() instanceof IBoreHead) {
            IBoreHead head = (IBoreHead)boreSlot.getItem();
            float dig = 2.0f - head.getDigModifier();
            hardness *= dig;
        }
        return hardness /= RailcraftConfig.boreMiningSpeedMultiplier();
    }

    protected float getBlockHardness(int x, int y, int z, EnumTrackMeta dir) {
        int trackMeta;
        if (this.worldObj.isAirBlock(x, y, z)) {
            return 0.0f;
        }
        Block block = this.worldObj.getBlock(x, y, z);
        if (TrackTools.isRailBlock(block) && dir.isEqual(trackMeta = TrackTools.getTrackMeta((IBlockAccess)this.worldObj, block, (EntityMinecart)this, x, y, z))) {
            return 0.0f;
        }
        if (block == Blocks.torch) {
            return 0.0f;
        }
        if (block == Blocks.obsidian) {
            return 15.0f;
        }
        int meta = this.worldObj.getBlockMetadata(x, y, z);
        if (!this.canMineBlock(x, y, z, block, meta)) {
            return 0.1f;
        }
        float hardness = block.getBlockHardness(this.worldObj, x, y, z);
        if (hardness <= 0.0f) {
            hardness = 0.1f;
        }
        return hardness;
    }

    public AxisAlignedBB getCollisionBox(Entity other) {
        if (other instanceof EntityLivingBase) {
            return other.boundingBox;
        }
        return null;
    }

    public AxisAlignedBB getBoundingBox() {
        return null;
    }

    @Override
    public String getInventoryName() {
        return "Tunnel Bore";
    }

    public float getBoreRotationAngle() {
        return (float)Math.toRadians(this.boreRotationAngle);
    }

    protected void writeEntityToNBT(NBTTagCompound data) {
        super.writeEntityToNBT(data);
        data.setByte("facing", (byte)this.getFacing().ordinal());
        data.setInteger("delay", this.getDelay());
        data.setBoolean("active", this.isActive());
        data.setInteger("burnTime", this.getBurnTime());
        data.setInteger("fuel", this.fuel);
    }

    protected void readEntityFromNBT(NBTTagCompound data) {
        super.readEntityFromNBT(data);
        this.setFacing(ForgeDirection.getOrientation((int)data.getByte("facing")));
        this.setDelay(data.getInteger("delay"));
        this.setActive(data.getBoolean("active"));
        this.setBurnTime(data.getInteger("burnTime"));
        this.setFuel(data.getInteger("fuel"));
    }

    protected int getDelay() {
        return this.delay;
    }

    protected void setDelay(int i) {
        this.delay = i;
    }

    protected boolean isActive() {
        return this.active;
    }

    protected void setActive(boolean active) {
        this.active = active;
        Train.TrainState state = active ? Train.TrainState.STOPPED : Train.TrainState.NORMAL;
        Train.getTrain((EntityMinecart)this).setTrainState(state);
    }

    protected boolean isMoving() {
        return this.dataWatcher.getWatchableObjectByte(25) != 0;
    }

    protected void setMoving(boolean move) {
        this.dataWatcher.updateObject(25, (Object)((byte)(move ? 1 : 0)));
    }

    public int getBurnTime() {
        return this.burnTime;
    }

    public void setBurnTime(int burnTime) {
        this.burnTime = burnTime;
    }

    public int getFuel() {
        return this.fuel;
    }

    public void setFuel(int i) {
        this.fuel = i;
    }

    public boolean outOfFuel() {
        return this.getFuel() <= 12;
    }

    public boolean hasFuel() {
        return this.getFuel() > 0;
    }

    protected void stockFuel() {
        ItemStack stack;
        if (InvTools.isEmptySlot(this.invFuel) && (stack = CartTools.transferHelper.pullStack((EntityMinecart)this, StackFilter.FUEL)) != null) {
            InvTools.moveItemStack(stack, this.invFuel);
        }
    }

    protected void addFuel() {
        int burn = 0;
        for (int slot = 0; slot < this.invFuel.getSizeInventory(); ++slot) {
            ItemStack stack = this.invFuel.getStackInSlot(slot);
            if (stack == null || (burn = FuelPlugin.getBurnTime(stack)) <= 0) continue;
            if (stack.getItem().hasContainerItem(stack)) {
                this.invFuel.setInventorySlotContents(slot, stack.getItem().getContainerItem(stack));
                break;
            }
            this.invFuel.decrStackSize(slot, 1);
            break;
        }
        if (burn > 0) {
            this.setBurnTime(burn + this.getFuel());
            this.setFuel(this.getFuel() + burn);
        }
    }

    public int getBurnProgressScaled(int i) {
        int burn = this.getBurnTime();
        if (burn == 0) {
            return 0;
        }
        return this.getFuel() * i / burn;
    }

    protected void spendFuel() {
        this.setFuel(this.getFuel() - 12);
    }

    protected void forceUpdateBoreHead() {
        ItemStack boreStack = this.getStackInSlot(0);
        if (boreStack != null) {
            boreStack = boreStack.copy();
        }
        this.dataWatcher.updateObject(26, (Object)boreStack);
    }

    public IBoreHead getBoreHead() {
        ItemStack boreStack = this.dataWatcher.getWatchableObjectItemStack(26);
        if (boreStack != null && boreStack.getItem() instanceof IBoreHead) {
            return (IBoreHead)boreStack.getItem();
        }
        return null;
    }

    protected void applyDrag() {
        this.motionX *= this.getDrag();
        this.motionY *= 0.0;
        this.motionZ *= this.getDrag();
    }

    @Override
    public List<ItemStack> getItemsDropped() {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        items.add(this.getCartItem());
        return items;
    }

    public boolean isPoweredCart() {
        return true;
    }

    @Override
    public boolean doInteract(EntityPlayer player) {
        if (Game.isHost(this.worldObj)) {
            GuiHandler.openGui(EnumGui.CART_BORE, player, this.worldObj, (Entity)this);
        }
        return true;
    }

    public void markDirty() {
        if (!this.isActive()) {
            this.setDelay(5);
        }
    }

    public final ForgeDirection getFacing() {
        return ForgeDirection.getOrientation((int)this.dataWatcher.getWatchableObjectByte(5));
    }

    protected final void setFacing(ForgeDirection facing) {
        this.dataWatcher.updateObject(5, (Object)((byte)facing.ordinal()));
        this.setYaw();
    }

    @Override
    public boolean isLinkable() {
        return true;
    }

    @Override
    public boolean canLinkWithCart(EntityMinecart cart) {
        double z;
        double x = this.getXAhead(this.posX, -3.1f);
        return cart.getDistance(x, this.posY, z = this.getZAhead(this.posZ, -3.1f)) < 2.5;
    }

    @Override
    public boolean hasTwoLinks() {
        return false;
    }

    @Override
    public float getLinkageDistance(EntityMinecart cart) {
        return 4.0f;
    }

    @Override
    public float getOptimalDistance(EntityMinecart cart) {
        return 3.1f;
    }

    @Override
    public void onLinkCreated(EntityMinecart cart) {
    }

    @Override
    public void onLinkBroken(EntityMinecart cart) {
    }

    @Override
    public boolean canBeAdjusted(EntityMinecart cart) {
        return !this.isActive();
    }

    public boolean shouldDoRailFunctions() {
        return false;
    }

    public IInventory getInventoryFuel() {
        return this.invFuel;
    }

    public IInventory getInventoryGravel() {
        return this.invBallast;
    }

    public IInventory getInventoryRails() {
        return this.invRails;
    }

    public Entity[] getParts() {
        return this.partArray;
    }

    public boolean attackEntityFromPart(EntityTunnelBorePart part, DamageSource damageSource, float damage) {
        return this.attackEntityFrom(damageSource, damage);
    }

    static {
        for (Block block : mineable) {
            EntityTunnelBore.addMineableBlock(block);
        }
        replaceableBlocks.addAll(Arrays.asList(replaceable));
    }
}

