/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.carts;

import mods.railcraft.common.carts.EntityTunnelBore;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;

public class EntityTunnelBorePart
extends Entity {
    public final EntityTunnelBore parent;
    public final String partName;
    public final float forwardOffset;
    public final float sideOffset;

    public EntityTunnelBorePart(EntityTunnelBore parent, String partName, float width, float height, float forwardOffset) {
        this(parent, partName, width, height, forwardOffset, 0.0f);
    }

    public EntityTunnelBorePart(EntityTunnelBore parent, String partName, float width, float height, float forwardOffset, float sideOffset) {
        super(parent.worldObj);
        this.setSize(width, height);
        this.parent = parent;
        this.partName = partName;
        this.forwardOffset = forwardOffset;
        this.sideOffset = sideOffset;
    }

    public void onUpdate() {
        super.onUpdate();
        double x = this.parent.getOffsetX(this.parent.posX, this.forwardOffset, this.sideOffset);
        double z = this.parent.getOffsetZ(this.parent.posZ, this.forwardOffset, this.sideOffset);
        this.setLocationAndAngles(x, this.parent.posY, z, 0.0f, 0.0f);
    }

    public AxisAlignedBB getBoundingBox() {
        return this.boundingBox;
    }

    protected void entityInit() {
    }

    protected void readEntityFromNBT(NBTTagCompound p_70037_1_) {
    }

    protected void writeEntityToNBT(NBTTagCompound p_70014_1_) {
    }

    public boolean canBeCollidedWith() {
        return true;
    }

    public boolean attackEntityFrom(DamageSource p_70097_1_, float p_70097_2_) {
        return !this.isEntityInvulnerable() && this.parent.attackEntityFromPart(this, p_70097_1_, p_70097_2_);
    }

    public boolean isEntityEqual(Entity entity) {
        return this == entity || this.parent == entity;
    }
}

