/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.carts;

import com.google.common.collect.MapMaker;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import mods.railcraft.api.carts.CartTools;
import mods.railcraft.api.carts.ILinkableCart;
import mods.railcraft.api.carts.ILinkageManager;
import mods.railcraft.common.carts.EntityLocomotive;
import mods.railcraft.common.carts.Train;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import org.apache.logging.log4j.Level;

public class LinkageManager
implements ILinkageManager {
    public static final String AUTO_LINK = "rcAutoLink";
    public static final String LINK_A_HIGH = "rcLinkAHigh";
    public static final String LINK_A_LOW = "rcLinkALow";
    public static final String LINK_B_HIGH = "rcLinkBHigh";
    public static final String LINK_B_LOW = "rcLinkBLow";
    private final Map<UUID, EntityMinecart> carts = new MapMaker().weakValues().makeMap();

    private LinkageManager() {
    }

    public static LinkageManager instance() {
        return (LinkageManager)CartTools.linkageManager;
    }

    public static void printDebug(String msg, Object ... args) {
        if (RailcraftConfig.printLinkingDebug()) {
            Game.log(Level.DEBUG, msg, args);
        }
    }

    public static void reset() {
        CartTools.linkageManager = new LinkageManager();
    }

    public void removeLinkageId(EntityMinecart cart) {
        this.carts.remove(this.getLinkageId(cart));
    }

    public UUID getLinkageId(EntityMinecart cart) {
        UUID id = cart.getPersistentID();
        if (!cart.isDead) {
            this.carts.put(id, cart);
        }
        return id;
    }

    @Override
    public EntityMinecart getCartFromUUID(UUID id) {
        EntityMinecart cart = this.carts.get(id);
        if (cart != null && cart.isDead) {
            this.carts.remove(id);
            return null;
        }
        return this.carts.get(id);
    }

    private float getLinkageDistanceSq(EntityMinecart cart1, EntityMinecart cart2) {
        float dist = 0.0f;
        dist = cart1 instanceof ILinkableCart ? (dist += ((ILinkableCart)cart1).getLinkageDistance(cart2)) : (dist += 1.25f);
        dist = cart2 instanceof ILinkableCart ? (dist += ((ILinkableCart)cart2).getLinkageDistance(cart1)) : (dist += 1.25f);
        return dist * dist;
    }

    @Override
    public boolean setAutoLink(EntityMinecart cart, boolean autoLink) {
        if (autoLink && this.hasFreeLink(cart)) {
            cart.getEntityData().setBoolean(AUTO_LINK, true);
            LinkageManager.printDebug("Cart {0}({1}) Set To Auto Link With First Collision.", this.getLinkageId(cart), cart);
            return true;
        }
        if (!autoLink) {
            cart.getEntityData().removeTag(AUTO_LINK);
            return true;
        }
        return false;
    }

    @Override
    public boolean hasAutoLink(EntityMinecart cart) {
        if (!this.hasFreeLink(cart)) {
            cart.getEntityData().removeTag(AUTO_LINK);
        }
        return cart.getEntityData().getBoolean(AUTO_LINK);
    }

    @Override
    public boolean tryAutoLink(EntityMinecart cart1, EntityMinecart cart2) {
        if ((this.hasAutoLink(cart1) || this.hasAutoLink(cart2)) && this.createLink(cart1, cart2)) {
            cart1.getEntityData().removeTag(AUTO_LINK);
            cart2.getEntityData().removeTag(AUTO_LINK);
            LinkageManager.printDebug("Automatically Linked Carts {0}({1}) and {2}({3}).", this.getLinkageId(cart1), cart1, this.getLinkageId(cart2), cart2);
            if (cart1 instanceof EntityLocomotive) {
                ((EntityLocomotive)cart1).setSpeed(EntityLocomotive.LocoSpeed.SLOWEST);
            }
            if (cart2 instanceof EntityLocomotive) {
                ((EntityLocomotive)cart2).setSpeed(EntityLocomotive.LocoSpeed.SLOWEST);
            }
            return true;
        }
        return false;
    }

    private boolean canLinkCarts(EntityMinecart cart1, EntityMinecart cart2) {
        ILinkableCart link;
        if (cart1 == null || cart2 == null) {
            return false;
        }
        if (cart1 == cart2) {
            return false;
        }
        if (!(!(cart1 instanceof ILinkableCart) || (link = (ILinkableCart)cart1).isLinkable() && link.canLinkWithCart(cart2))) {
            return false;
        }
        if (!(!(cart2 instanceof ILinkableCart) || (link = (ILinkableCart)cart2).isLinkable() && link.canLinkWithCart(cart1))) {
            return false;
        }
        if (this.areLinked(cart1, cart2)) {
            return false;
        }
        if (cart1.getDistanceSqToEntity((Entity)cart2) > (double)this.getLinkageDistanceSq(cart1, cart2)) {
            return false;
        }
        if (Train.areInSameTrain(cart1, cart2)) {
            return false;
        }
        return this.hasFreeLink(cart1) && this.hasFreeLink(cart2);
    }

    @Override
    public boolean createLink(EntityMinecart cart1, EntityMinecart cart2) {
        if (this.canLinkCarts(cart1, cart2)) {
            Train train = Train.getLongestTrain(cart1, cart2);
            this.setLink(cart1, cart2);
            this.setLink(cart2, cart1);
            train.addLink(cart1, cart2);
            if (cart1 instanceof ILinkableCart) {
                ((ILinkableCart)cart1).onLinkCreated(cart2);
            }
            if (cart2 instanceof ILinkableCart) {
                ((ILinkableCart)cart2).onLinkCreated(cart1);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean hasFreeLink(EntityMinecart cart) {
        return this.getLinkedCartA(cart) == null || this.hasLink(cart, LinkType.LINK_B) && this.getLinkedCartB(cart) == null;
    }

    public boolean hasLink(EntityMinecart cart, LinkType linkType) {
        if (linkType == LinkType.LINK_B && cart instanceof ILinkableCart) {
            return ((ILinkableCart)cart).hasTwoLinks();
        }
        return true;
    }

    private void setLink(EntityMinecart cart1, EntityMinecart cart2) {
        if (this.getLinkedCartA(cart1) == null) {
            this.setLink(cart1, cart2, LinkType.LINK_A);
        } else if (this.hasLink(cart1, LinkType.LINK_B) && this.getLinkedCartB(cart1) == null) {
            this.setLink(cart1, cart2, LinkType.LINK_B);
        }
    }

    public UUID getLink(EntityMinecart cart, LinkType linkType) {
        long high = cart.getEntityData().getLong(linkType.tagHigh);
        long low = cart.getEntityData().getLong(linkType.tagLow);
        return new UUID(high, low);
    }

    public UUID getLinkA(EntityMinecart cart) {
        return this.getLink(cart, LinkType.LINK_A);
    }

    public UUID getLinkB(EntityMinecart cart) {
        return this.getLink(cart, LinkType.LINK_B);
    }

    private void setLink(EntityMinecart cart1, EntityMinecart cart2, LinkType linkType) {
        if (!this.hasLink(cart1, linkType)) {
            return;
        }
        UUID id = this.getLinkageId(cart2);
        cart1.getEntityData().setLong(linkType.tagHigh, id.getMostSignificantBits());
        cart1.getEntityData().setLong(linkType.tagLow, id.getLeastSignificantBits());
    }

    @Override
    public EntityMinecart getLinkedCartA(EntityMinecart cart) {
        return this.getLinkedCart(cart, LinkType.LINK_A);
    }

    @Override
    public EntityMinecart getLinkedCartB(EntityMinecart cart) {
        return this.getLinkedCart(cart, LinkType.LINK_B);
    }

    public EntityMinecart getLinkedCart(EntityMinecart cart, LinkType type) {
        return this.getCartFromUUID(this.getLink(cart, type));
    }

    @Deprecated
    public Train getTrain(EntityMinecart cart) {
        return Train.getTrain(cart);
    }

    @Deprecated
    public Train getTrain(UUID cartUUID) {
        if (cartUUID == null) {
            return null;
        }
        EntityMinecart cart = this.getCartFromUUID(cartUUID);
        if (cart == null) {
            return null;
        }
        return this.getTrain(cart);
    }

    @Deprecated
    public UUID getTrainUUID(EntityMinecart cart) {
        return Train.getTrainUUID(cart);
    }

    @Deprecated
    public void resetTrain(EntityMinecart cart) {
        Train.resetTrain(cart);
    }

    @Deprecated
    public boolean areInSameTrain(EntityMinecart cart1, EntityMinecart cart2) {
        return Train.areInSameTrain(cart1, cart2);
    }

    @Override
    public boolean areLinked(EntityMinecart cart1, EntityMinecart cart2) {
        return this.areLinked(cart1, cart2, true);
    }

    public boolean areLinked(EntityMinecart cart1, EntityMinecart cart2, boolean strict) {
        if (cart1 == null || cart2 == null) {
            return false;
        }
        if (cart1 == cart2) {
            return false;
        }
        boolean cart1Linked = false;
        UUID id1 = this.getLinkageId(cart1);
        UUID id2 = this.getLinkageId(cart2);
        if (id2.equals(this.getLinkA(cart1)) || id2.equals(this.getLinkB(cart1))) {
            cart1Linked = true;
        }
        boolean cart2Linked = false;
        if (id1.equals(this.getLinkA(cart2)) || id1.equals(this.getLinkB(cart2))) {
            cart2Linked = true;
        }
        if (strict) {
            return cart1Linked && cart2Linked;
        }
        return cart1Linked || cart2Linked;
    }

    @Override
    public void breakLink(EntityMinecart cart1, EntityMinecart cart2) {
        UUID link = this.getLinkageId(cart2);
        if (link.equals(this.getLinkA(cart1))) {
            this.breakLinkA(cart1);
        }
        if (link.equals(this.getLinkB(cart1))) {
            this.breakLinkB(cart1);
        }
    }

    @Override
    public void breakLinks(EntityMinecart cart) {
        this.breakLink(cart, LinkType.LINK_A);
        this.breakLink(cart, LinkType.LINK_B);
    }

    @Override
    public void breakLinkA(EntityMinecart cart) {
        this.breakLink(cart, LinkType.LINK_A);
    }

    @Override
    public void breakLinkB(EntityMinecart cart) {
        this.breakLink(cart, LinkType.LINK_B);
    }

    private EntityMinecart breakLink(EntityMinecart cart, LinkType linkType) {
        Train.resetTrain(cart);
        UUID link = this.getLink(cart, linkType);
        cart.getEntityData().setLong(linkType.tagHigh, 0L);
        cart.getEntityData().setLong(linkType.tagLow, 0L);
        EntityMinecart other = this.getCartFromUUID(link);
        if (other != null) {
            this.breakLink(other, cart);
        }
        if (cart instanceof ILinkableCart) {
            ((ILinkableCart)cart).onLinkBroken(other);
        }
        LinkageManager.printDebug("Carts {0}({1}) and {2}({3}) unlinked ({4}).", this.getLinkageId(cart), cart, link, other != null ? other : "null", linkType.name());
        return other;
    }

    @Override
    public int countCartsInTrain(EntityMinecart cart) {
        return Train.getTrain(cart).size();
    }

    private int numLinkedCarts(EntityMinecart prev, EntityMinecart next) {
        int count = 1;
        EntityMinecart linkA = this.getLinkedCartA(next);
        EntityMinecart linkB = this.getLinkedCartB(next);
        if (linkA != null && linkA != prev) {
            count += this.numLinkedCarts(next, linkA);
        }
        if (linkB != null && linkB != prev) {
            count += this.numLinkedCarts(next, linkB);
        }
        return count;
    }

    @Override
    public Iterable<EntityMinecart> getCartsInTrain(EntityMinecart cart) {
        return Train.getTrain(cart);
    }

    public Iterable<EntityMinecart> getLinkedCarts(final EntityMinecart cart, final LinkType type) {
        return new Iterable<EntityMinecart>(){

            @Override
            public Iterator<EntityMinecart> iterator() {
                return new Iterator<EntityMinecart>(){
                    private final LinkageManager lm = LinkageManager.instance();
                    private EntityMinecart last = null;
                    private EntityMinecart current;
                    {
                        this.current = cart;
                    }

                    @Override
                    public boolean hasNext() {
                        if (this.last == null) {
                            EntityMinecart next = this.lm.getLinkedCart(this.current, type);
                            return next != null;
                        }
                        EntityMinecart next = this.lm.getLinkedCartA(this.current);
                        if (next != null && next != this.last) {
                            return true;
                        }
                        next = this.lm.getLinkedCartB(this.current);
                        return next != null && next != this.last;
                    }

                    @Override
                    public EntityMinecart next() {
                        if (this.last == null) {
                            EntityMinecart next = this.lm.getLinkedCart(this.current, type);
                            if (next == null) {
                                return null;
                            }
                            this.last = this.current;
                            this.current = next;
                            return this.current;
                        }
                        EntityMinecart next = this.lm.getLinkedCartA(this.current);
                        if (next != null && next != this.last) {
                            this.last = this.current;
                            this.current = next;
                            return this.current;
                        }
                        next = this.lm.getLinkedCartB(this.current);
                        if (next != null && next != this.last) {
                            this.last = this.current;
                            this.current = next;
                            return this.current;
                        }
                        return null;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("Removing not supported.");
                    }
                };
            }
        };
    }

    public static enum LinkType {
        LINK_A("rcLinkAHigh", "rcLinkALow"),
        LINK_B("rcLinkBHigh", "rcLinkBLow");

        public final String tagHigh;
        public final String tagLow;

        private LinkType(String tagHigh, String tagLow) {
            this.tagHigh = tagHigh;
            this.tagLow = tagLow;
        }
    }
}

