/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.gui.containers;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mods.railcraft.common.carts.IIC2EnergyCart;
import mods.railcraft.common.gui.containers.RailcraftContainer;
import mods.railcraft.common.gui.slots.SlotEnergy;
import mods.railcraft.common.util.network.PacketBuilder;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;

public class ContainerCartEnergy
extends RailcraftContainer {
    private IIC2EnergyCart cart;
    private int lastEnergy;

    public ContainerCartEnergy(InventoryPlayer inventoryplayer, IIC2EnergyCart device) {
        super(device);
        this.cart = device;
        this.addSlot(new SlotEnergy(device, 0, 56, 17));
        this.addSlot(new SlotEnergy(device, 1, 56, 53));
        for (int i = 0; i < 3; ++i) {
            for (int k = 0; k < 9; ++k) {
                this.addSlot(new Slot((IInventory)inventoryplayer, k + i * 9 + 9, 8 + k * 18, 84 + i * 18));
            }
        }
        for (int j = 0; j < 9; ++j) {
            this.addSlot(new Slot((IInventory)inventoryplayer, j, 8 + j * 18, 142));
        }
    }

    @Override
    public void addCraftingToCrafters(ICrafting player) {
        super.addCraftingToCrafters(player);
        PacketBuilder.instance().sendGuiIntegerPacket((EntityPlayerMP)player, this.windowId, 0, (int)this.cart.getEnergy());
    }

    @Override
    public void sendUpdateToClient() {
        super.sendUpdateToClient();
        for (int i = 0; i < this.crafters.size(); ++i) {
            ICrafting player = (ICrafting)this.crafters.get(i);
            if ((double)this.lastEnergy == this.cart.getEnergy()) continue;
            PacketBuilder.instance().sendGuiIntegerPacket((EntityPlayerMP)player, this.windowId, 0, (int)this.cart.getEnergy());
        }
        this.lastEnergy = (int)this.cart.getEnergy();
    }

    @SideOnly(value=Side.CLIENT)
    public void updateProgressBar(int id, int data) {
        if (id == 0) {
            this.cart.setEnergy(data);
        }
    }
}

