/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.gui.containers;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mods.railcraft.common.carts.EntityCartRF;
import mods.railcraft.common.gui.containers.RailcraftContainer;
import mods.railcraft.common.gui.widgets.IndicatorWidget;
import mods.railcraft.common.gui.widgets.RFEnergyIndicator;
import mods.railcraft.common.util.network.PacketBuilder;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.ICrafting;

public class ContainerCartRF
extends RailcraftContainer {
    private final EntityCartRF cart;
    private final RFEnergyIndicator energyIndicator;
    private int lastEnergy;

    public ContainerCartRF(EntityCartRF cart) {
        this.cart = cart;
        this.energyIndicator = new RFEnergyIndicator(cart.getMaxRF());
        this.addWidget(new IndicatorWidget(this.energyIndicator, 57, 38, 176, 0, 62, 8, false));
    }

    @Override
    public void addCraftingToCrafters(ICrafting crafter) {
        super.addCraftingToCrafters(crafter);
        PacketBuilder.instance().sendGuiIntegerPacket((EntityPlayerMP)crafter, this.windowId, 0, this.cart.getRF());
    }

    @Override
    public void sendUpdateToClient() {
        super.sendUpdateToClient();
        for (int var1 = 0; var1 < this.crafters.size(); ++var1) {
            ICrafting crafter = (ICrafting)this.crafters.get(var1);
            if (this.lastEnergy == this.cart.getRF()) continue;
            PacketBuilder.instance().sendGuiIntegerPacket((EntityPlayerMP)crafter, this.windowId, 0, this.cart.getRF());
        }
        this.lastEnergy = this.cart.getRF();
    }

    @SideOnly(value=Side.CLIENT)
    public void updateProgressBar(int id, int value) {
        switch (id) {
            case 0: {
                this.energyIndicator.setEnergy(value);
            }
        }
    }
}

