/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.gui.containers;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mods.railcraft.api.crafting.RailcraftCraftingManager;
import mods.railcraft.common.blocks.machine.alpha.TileCokeOven;
import mods.railcraft.common.fluids.TankManager;
import mods.railcraft.common.gui.containers.RailcraftContainer;
import mods.railcraft.common.gui.slots.SlotFluidContainerEmpty;
import mods.railcraft.common.gui.slots.SlotOutput;
import mods.railcraft.common.gui.slots.SlotRailcraft;
import mods.railcraft.common.gui.widgets.FluidGaugeWidget;
import mods.railcraft.common.util.inventory.InvTools;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class ContainerCokeOven
extends RailcraftContainer {
    private TileCokeOven tile;
    private int lastCookTime = 0;
    private int lastCookTimeTotal;

    public ContainerCokeOven(InventoryPlayer inventoryplayer, TileCokeOven tile) {
        super(tile);
        this.tile = tile;
        this.addWidget(new FluidGaugeWidget(tile.getTankManager().get(0), 90, 24, 176, 0, 48, 47));
        this.addSlot(new SlotCokeOven(tile, 0, 16, 43));
        this.addSlot(new SlotOutput(tile, 1, 62, 43));
        this.addSlot(new SlotOutput(tile, 2, 149, 57));
        this.addSlot(new SlotFluidContainerEmpty(tile, 3, 149, 22));
        for (int i = 0; i < 3; ++i) {
            for (int k = 0; k < 9; ++k) {
                this.addSlot(new Slot((IInventory)inventoryplayer, k + i * 9 + 9, 8 + k * 18, 84 + i * 18));
            }
        }
        for (int j = 0; j < 9; ++j) {
            this.addSlot(new Slot((IInventory)inventoryplayer, j, 8 + j * 18, 142));
        }
    }

    @Override
    public void sendUpdateToClient() {
        super.sendUpdateToClient();
        TankManager tMan = this.tile.getTankManager();
        if (tMan != null) {
            tMan.updateGuiData(this, this.crafters, 0);
        }
        for (int i = 0; i < this.crafters.size(); ++i) {
            int cookTimeTotal;
            ICrafting icrafting = (ICrafting)this.crafters.get(i);
            int cookTime = this.tile.getCookTime();
            if (this.lastCookTime != cookTime) {
                icrafting.sendProgressBarUpdate((Container)this, 10, cookTime);
            }
            if (this.lastCookTimeTotal == (cookTimeTotal = this.tile.getTotalCookTime())) continue;
            icrafting.sendProgressBarUpdate((Container)this, 11, cookTimeTotal);
        }
        this.lastCookTime = this.tile.getCookTime();
        this.lastCookTimeTotal = this.tile.getTotalCookTime();
    }

    @Override
    public void addCraftingToCrafters(ICrafting icrafting) {
        super.addCraftingToCrafters(icrafting);
        TankManager tMan = this.tile.getTankManager();
        if (tMan != null) {
            tMan.initGuiData(this, icrafting, 0);
        }
        icrafting.sendProgressBarUpdate((Container)this, 10, this.tile.getCookTime());
        icrafting.sendProgressBarUpdate((Container)this, 11, this.tile.getTotalCookTime());
    }

    @SideOnly(value=Side.CLIENT)
    public void updateProgressBar(int id, int data) {
        TankManager tMan = this.tile.getTankManager();
        if (tMan != null) {
            tMan.processGuiUpdate(id, data);
        }
        switch (id) {
            case 10: {
                this.tile.setCookTime(data);
                break;
            }
            case 11: {
                this.tile.cookTimeTotal = data;
            }
        }
    }

    private class SlotCokeOven
    extends SlotRailcraft {
        public SlotCokeOven(IInventory iinventory, int slotIndex, int posX, int posY) {
            super(iinventory, slotIndex, posX, posY);
        }

        public boolean isItemValid(ItemStack stack) {
            return stack != null && !InvTools.isSynthetic(stack) && RailcraftCraftingManager.cokeOven.getRecipe(stack) != null;
        }
    }
}

