/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.gui.containers;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mods.railcraft.common.blocks.RailcraftTileEntity;
import mods.railcraft.common.blocks.machine.beta.TileEngineSteam;
import mods.railcraft.common.gui.containers.RailcraftContainer;
import mods.railcraft.common.gui.widgets.FluidGaugeWidget;
import mods.railcraft.common.gui.widgets.IndicatorWidget;
import mods.railcraft.common.gui.widgets.RFEnergyIndicator;
import mods.railcraft.common.util.network.PacketBuilder;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;

public class ContainerEngineSteam
extends RailcraftContainer {
    private final TileEngineSteam tile;
    private int lastEnergy;
    private float lastOutput;
    private final RFEnergyIndicator energyIndicator;

    public ContainerEngineSteam(InventoryPlayer inventoryplayer, TileEngineSteam tile) {
        this.tile = tile;
        this.addWidget(new FluidGaugeWidget(tile.getTankManager().get(0), 71, 23, 176, 0, 16, 47));
        this.energyIndicator = new RFEnergyIndicator(tile.maxEnergy());
        this.addWidget(new IndicatorWidget(this.energyIndicator, 94, 25, 176, 47, 6, 43));
        for (int i = 0; i < 3; ++i) {
            for (int k = 0; k < 9; ++k) {
                this.addSlot(new Slot((IInventory)inventoryplayer, k + i * 9 + 9, 8 + k * 18, 84 + i * 18));
            }
        }
        for (int j = 0; j < 9; ++j) {
            this.addSlot(new Slot((IInventory)inventoryplayer, j, 8 + j * 18, 142));
        }
    }

    @Override
    public void addCraftingToCrafters(ICrafting crafter) {
        super.addCraftingToCrafters(crafter);
        this.tile.getTankManager().initGuiData(this, crafter, 0);
        PacketBuilder.instance().sendGuiIntegerPacket((EntityPlayerMP)crafter, this.windowId, 12, this.tile.energy);
        crafter.sendProgressBarUpdate((Container)this, 14, Math.round(this.tile.currentOutput * 100.0f));
    }

    @Override
    public void sendUpdateToClient() {
        super.sendUpdateToClient();
        this.tile.getTankManager().updateGuiData(this, this.crafters, 0);
        for (int var1 = 0; var1 < this.crafters.size(); ++var1) {
            ICrafting crafter = (ICrafting)this.crafters.get(var1);
            if (this.lastEnergy != this.tile.energy) {
                PacketBuilder.instance().sendGuiIntegerPacket((EntityPlayerMP)crafter, this.windowId, 13, this.tile.energy);
            }
            if (this.lastOutput == this.tile.currentOutput) continue;
            crafter.sendProgressBarUpdate((Container)this, 14, Math.round(this.tile.currentOutput * 100.0f));
        }
        this.lastEnergy = this.tile.energy;
        this.lastOutput = this.tile.currentOutput;
    }

    @SideOnly(value=Side.CLIENT)
    public void updateProgressBar(int id, int value) {
        this.tile.getTankManager().processGuiUpdate(id, value);
        switch (id) {
            case 12: {
                this.energyIndicator.setEnergy(value);
                break;
            }
            case 13: {
                this.energyIndicator.updateEnergy(value);
                break;
            }
            case 14: {
                this.tile.currentOutput = (float)value / 100.0f;
            }
        }
    }

    @Override
    public boolean canInteractWith(EntityPlayer entityplayer) {
        return RailcraftTileEntity.isUseableByPlayerHelper(this.tile, entityplayer);
    }
}

