/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.gui.containers;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mods.railcraft.common.blocks.machine.gamma.TileRFLoaderBase;
import mods.railcraft.common.gui.containers.RailcraftContainer;
import mods.railcraft.common.gui.widgets.IndicatorWidget;
import mods.railcraft.common.gui.widgets.RFEnergyIndicator;
import mods.railcraft.common.util.network.PacketBuilder;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.ICrafting;

public class ContainerLoaderRF
extends RailcraftContainer {
    private TileRFLoaderBase device;
    private final RFEnergyIndicator energyIndicator;
    private int lastEnergy;

    public ContainerLoaderRF(TileRFLoaderBase device) {
        super(device);
        this.device = device;
        this.energyIndicator = new RFEnergyIndicator(device.getMaxRF());
        this.addWidget(new IndicatorWidget(this.energyIndicator, 57, 38, 176, 0, 62, 8, false));
    }

    @Override
    public void addCraftingToCrafters(ICrafting player) {
        super.addCraftingToCrafters(player);
        PacketBuilder.instance().sendGuiIntegerPacket((EntityPlayerMP)player, this.windowId, 0, this.device.getRF());
    }

    @Override
    public void sendUpdateToClient() {
        super.sendUpdateToClient();
        for (int i = 0; i < this.crafters.size(); ++i) {
            ICrafting player = (ICrafting)this.crafters.get(i);
            if (this.lastEnergy == this.device.getRF()) continue;
            PacketBuilder.instance().sendGuiIntegerPacket((EntityPlayerMP)player, this.windowId, 0, this.device.getRF());
        }
        this.lastEnergy = this.device.getRF();
    }

    @SideOnly(value=Side.CLIENT)
    public void updateProgressBar(int id, int data) {
        if (id == 0) {
            this.energyIndicator.setEnergy(data);
        }
    }
}

