/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.gui.containers;

import cofh.api.energy.EnergyStorage;
import mods.railcraft.api.crafting.RailcraftCraftingManager;
import mods.railcraft.common.blocks.machine.alpha.TileRockCrusher;
import mods.railcraft.common.gui.containers.RailcraftContainer;
import mods.railcraft.common.gui.slots.SlotOutput;
import mods.railcraft.common.gui.slots.SlotRailcraft;
import mods.railcraft.common.gui.widgets.IndicatorWidget;
import mods.railcraft.common.gui.widgets.RFEnergyIndicator;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class ContainerRockCrusher
extends RailcraftContainer {
    private final TileRockCrusher tile;
    private int lastProcessTime;
    private final RFEnergyIndicator energyIndicator;

    public ContainerRockCrusher(InventoryPlayer inventoryplayer, TileRockCrusher crusher) {
        super(crusher);
        int k;
        int i;
        this.tile = crusher;
        this.energyIndicator = new RFEnergyIndicator(this.tile);
        this.addWidget(new IndicatorWidget(this.energyIndicator, 157, 23, 176, 53, 6, 48));
        for (i = 0; i < 3; ++i) {
            for (k = 0; k < 3; ++k) {
                this.addSlot(new SlotRockCrusher(crusher, i * 3 + k, 8 + k * 18, 21 + i * 18));
            }
        }
        for (i = 0; i < 3; ++i) {
            for (k = 0; k < 3; ++k) {
                this.addSlot(new SlotOutput(crusher, 9 + i * 3 + k, 98 + k * 18, 21 + i * 18));
            }
        }
        for (i = 0; i < 3; ++i) {
            for (k = 0; k < 9; ++k) {
                this.addSlot(new Slot((IInventory)inventoryplayer, k + i * 9 + 9, 8 + k * 18, 84 + i * 18));
            }
        }
        for (int j = 0; j < 9; ++j) {
            this.addSlot(new Slot((IInventory)inventoryplayer, j, 8 + j * 18, 142));
        }
    }

    @Override
    public void addCraftingToCrafters(ICrafting icrafting) {
        super.addCraftingToCrafters(icrafting);
        icrafting.sendProgressBarUpdate((Container)this, 0, this.tile.getProcessTime());
        EnergyStorage storage = this.tile.getEnergyStorage();
        if (storage != null) {
            icrafting.sendProgressBarUpdate((Container)this, 1, storage.getEnergyStored());
        }
    }

    @Override
    public void sendUpdateToClient() {
        super.sendUpdateToClient();
        EnergyStorage storage = this.tile.getEnergyStorage();
        for (Object crafter : this.crafters) {
            ICrafting icrafting = (ICrafting)crafter;
            if (this.lastProcessTime != this.tile.getProcessTime()) {
                icrafting.sendProgressBarUpdate((Container)this, 0, this.tile.getProcessTime());
            }
            if (storage == null) continue;
            icrafting.sendProgressBarUpdate((Container)this, 2, storage.getEnergyStored());
        }
        this.lastProcessTime = this.tile.getProcessTime();
    }

    public void updateProgressBar(int id, int data) {
        switch (id) {
            case 0: {
                this.tile.setProcessTime(data);
                break;
            }
            case 1: {
                this.energyIndicator.setEnergy(data);
                break;
            }
            case 2: {
                this.energyIndicator.updateEnergy(data);
            }
        }
    }

    public class SlotRockCrusher
    extends SlotRailcraft {
        public SlotRockCrusher(IInventory iinventory, int slotIndex, int posX, int posY) {
            super(iinventory, slotIndex, posX, posY);
        }

        public boolean isItemValid(ItemStack stack) {
            return stack != null && RailcraftCraftingManager.rockCrusher.getRecipe(stack) != null;
        }
    }
}

