/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.items;

import cpw.mods.fml.common.FMLCommonHandler;
import java.util.List;
import mods.railcraft.common.blocks.hidden.BlockHidden;
import mods.railcraft.common.blocks.hidden.TrailTicker;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.items.ItemCircuit;
import mods.railcraft.common.items.ItemMaterials;
import mods.railcraft.common.items.RailcraftItem;
import mods.railcraft.common.plugins.forge.ChatPlugin;
import mods.railcraft.common.plugins.forge.CraftingPlugin;
import mods.railcraft.common.plugins.forge.CreativePlugin;
import mods.railcraft.common.plugins.forge.LocalizationPlugin;
import mods.railcraft.common.plugins.forge.LootPlugin;
import mods.railcraft.common.plugins.forge.OreDictPlugin;
import mods.railcraft.common.plugins.forge.RailcraftRegistry;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.misc.MiscTools;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class ItemGoggles
extends ItemArmor {
    private static final String TEXTURE = "railcraft:textures/entities/armor/goggles.png";
    private static ItemGoggles item;

    public ItemGoggles() {
        super(ItemMaterials.GOGGLES, 0, 0);
        this.setCreativeTab(CreativePlugin.RAILCRAFT_TAB);
    }

    public static void registerItem() {
        String tag;
        if (item == null && RailcraftConfig.isItemEnabled(tag = "railcraft.armor.goggles")) {
            item = new ItemGoggles();
            item.setUnlocalizedName(tag);
            RailcraftRegistry.register((Item)item);
            CraftingPlugin.addShapedRecipe(new ItemStack((Item)item), new Object[]{true, "GCG", "I I", "LLL", Character.valueOf('C'), RailcraftItem.circuit, ItemCircuit.EnumCircuit.RECEIVER, Character.valueOf('I'), "ingotSteel", Character.valueOf('L'), Items.leather, Character.valueOf('G'), "paneGlassColorless"});
            BlockHidden.registerBlock();
            if (BlockHidden.getBlock() != null && RailcraftConfig.isTrackingAuraEnabled()) {
                FMLCommonHandler.instance().bus().register((Object)new TrailTicker());
            }
            LootPlugin.addLootWorkshop(new ItemStack((Item)item), 1, 1, tag);
        }
    }

    public static ItemStack getItem() {
        if (item == null) {
            return null;
        }
        return new ItemStack((Item)item);
    }

    public static GoggleAura getCurrentAura(ItemStack goggles) {
        NBTTagCompound data;
        GoggleAura aura = GoggleAura.NONE;
        if (goggles != null && goggles.getItem() instanceof ItemGoggles && (data = goggles.getTagCompound()) != null) {
            aura = GoggleAura.VALUES[data.getByte("aura")];
        }
        return aura;
    }

    public static void incrementAura(ItemStack goggles) {
        if (goggles != null && goggles.getItem() instanceof ItemGoggles) {
            NBTTagCompound data = goggles.getTagCompound();
            if (data == null) {
                data = new NBTTagCompound();
                goggles.setTagCompound(data);
            }
            byte aura = data.getByte("aura");
            if ((aura = (byte)(aura + 1)) >= GoggleAura.VALUES.length) {
                aura = 0;
            }
            data.setByte("aura", aura);
            if (ItemGoggles.getCurrentAura(goggles) == GoggleAura.TRACKING && !RailcraftConfig.isTrackingAuraEnabled()) {
                ItemGoggles.incrementAura(goggles);
            }
        }
    }

    public static boolean areEnabled() {
        return item != null;
    }

    public static ItemStack getGoggles(EntityPlayer player) {
        if (player == null) {
            return null;
        }
        ItemStack helm = player.getCurrentArmor(MiscTools.ArmorSlots.HELM.ordinal());
        if (helm != null && helm.getItem() instanceof ItemGoggles) {
            return helm;
        }
        return null;
    }

    public static boolean isPlayerWearing(EntityPlayer player) {
        ItemStack helm = player.getCurrentArmor(MiscTools.ArmorSlots.HELM.ordinal());
        return helm != null && helm.getItem() instanceof ItemGoggles;
    }

    public void registerIcons(IIconRegister iconRegister) {
        this.itemIcon = iconRegister.registerIcon("railcraft:" + MiscTools.cleanTag(this.getUnlocalizedName()));
    }

    public ItemStack onItemRightClick(ItemStack stack, World world, EntityPlayer player) {
        ItemGoggles.incrementAura(stack);
        if (Game.isNotHost(world)) {
            GoggleAura aura = ItemGoggles.getCurrentAura(stack);
            ChatPlugin.sendLocalizedChat(player, "railcraft.gui.goggles.mode", "\u00a75" + (Object)((Object)aura));
        }
        return stack.copy();
    }

    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        return TEXTURE;
    }

    public boolean getIsRepairable(ItemStack itemToRepair, ItemStack stack) {
        return OreDictPlugin.isOreType("ingotSteel", stack);
    }

    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean adv) {
        NBTTagCompound data = stack.getTagCompound();
        GoggleAura aura = ItemGoggles.getCurrentAura(stack);
        String mode = LocalizationPlugin.translate("railcraft.gui.goggles.mode");
        String tip = LocalizationPlugin.translate("railcraft.gui.goggles.tip");
        list.add(String.format(mode, "\u00a75" + (Object)((Object)aura)));
        list.add(tip);
    }

    public static enum GoggleAura {
        NONE("railcraft.gui.goggles.aura.none"),
        ANCHOR("railcraft.gui.goggles.aura.anchor"),
        TRACKING("railcraft.gui.goggles.aura.tracking"),
        TUNING("railcraft.gui.goggles.aura.tuning"),
        SURVEYING("railcraft.gui.goggles.aura.surveying"),
        SIGNALLING("railcraft.gui.goggles.aura.signalling");

        public static final GoggleAura[] VALUES;
        private final String locTag;

        private GoggleAura(String locTag) {
            this.locTag = locTag;
        }

        public String toString() {
            return LocalizationPlugin.translate(this.locTag);
        }

        static {
            VALUES = GoggleAura.values();
        }
    }
}

