/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.items;

import java.util.List;
import java.util.Locale;
import mods.railcraft.common.items.IItemMetaEnum;
import mods.railcraft.common.items.ItemRailcraft;
import mods.railcraft.common.items.Metal;
import mods.railcraft.common.plugins.forestry.ForestryPlugin;
import mods.railcraft.common.plugins.forge.LootPlugin;
import mods.railcraft.common.plugins.forge.RailcraftRegistry;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.oredict.OreDictionary;

public class ItemIngot
extends ItemRailcraft {
    public ItemIngot() {
        this.setHasSubtypes(true);
        this.setMaxDamage(0);
        this.setUnlocalizedName("railcraft.ingot");
        this.setSmeltingExperience(1.0f);
    }

    @Override
    public void initItem() {
        for (EnumIngot i : EnumIngot.VALUES) {
            ItemStack stack = new ItemStack((Item)this, 1, i.ordinal());
            ForestryPlugin.addBackpackItem("miner", stack);
            RailcraftRegistry.register(stack);
            Metal m = Metal.get(i);
            OreDictionary.registerOre((String)m.getIngotTag(), (ItemStack)m.getIngot());
        }
        LootPlugin.addLootTool(new ItemStack((Item)this), 5, 9, "steel.ingot");
    }

    @Override
    public String getOreTag(IItemMetaEnum meta) {
        this.assertMeta(meta);
        return ((EnumIngot)meta).oreTag;
    }

    @Override
    public void registerIcons(IIconRegister iconRegister) {
        for (EnumIngot ingot : EnumIngot.VALUES) {
            ingot.icon = iconRegister.registerIcon("railcraft:ingot." + ingot.name().toLowerCase(Locale.ENGLISH));
        }
    }

    public void getSubItems(Item id, CreativeTabs tab, List list) {
        for (EnumIngot ingot : EnumIngot.VALUES) {
            list.add(new ItemStack((Item)this, 1, ingot.ordinal()));
        }
    }

    public IIcon getIconFromDamage(int damage) {
        if (damage >= EnumIngot.VALUES.length) {
            return EnumIngot.STEEL.icon;
        }
        return EnumIngot.VALUES[damage].icon;
    }

    public String getUnlocalizedName(ItemStack stack) {
        int damage = stack.getItemDamage();
        if (damage < 0 || damage >= EnumIngot.VALUES.length) {
            return "item.railcraft.ingot";
        }
        switch (EnumIngot.VALUES[damage]) {
            case STEEL: {
                return "item.railcraft.ingot.steel";
            }
            case COPPER: {
                return "item.railcraft.ingot.copper";
            }
            case TIN: {
                return "item.railcraft.ingot.tin";
            }
            case LEAD: {
                return "item.railcraft.ingot.lead";
            }
        }
        return "item.railcraft.ingot";
    }

    public static enum EnumIngot implements IItemMetaEnum
    {
        STEEL("ingotSteel"),
        COPPER("ingotCopper"),
        TIN("ingotTin"),
        LEAD("ingotLead");

        public static final EnumIngot[] VALUES;
        private IIcon icon;
        private String oreTag;

        private EnumIngot(String oreTag) {
            this.oreTag = oreTag;
        }

        @Override
        public Object getAlternate() {
            return this.oreTag;
        }

        @Override
        public Class<? extends ItemRailcraft> getItemClass() {
            return ItemIngot.class;
        }

        static {
            VALUES = EnumIngot.values();
        }
    }
}

