/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.items;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.EnumSet;
import java.util.List;
import mods.railcraft.api.carts.CartTools;
import mods.railcraft.api.core.IOwnable;
import mods.railcraft.api.signals.SignalAspect;
import mods.railcraft.common.blocks.machine.TileMultiBlock;
import mods.railcraft.common.blocks.signals.IDualHeadSignal;
import mods.railcraft.common.blocks.signals.TileSignalBase;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.items.IActivationBlockingItem;
import mods.railcraft.common.items.ItemRailcraft;
import mods.railcraft.common.plugins.forge.ChatPlugin;
import mods.railcraft.common.plugins.forge.CraftingPlugin;
import mods.railcraft.common.plugins.forge.CreativePlugin;
import mods.railcraft.common.plugins.forge.LocalizationPlugin;
import mods.railcraft.common.plugins.forge.LootPlugin;
import mods.railcraft.common.plugins.forge.RailcraftRegistry;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.EntityInteractEvent;

public class ItemMagnifyingGlass
extends ItemRailcraft
implements IActivationBlockingItem {
    public static Item item;

    public ItemMagnifyingGlass() {
        this.setMaxDamage(0);
        this.setMaxStackSize(1);
        this.setUnlocalizedName("railcraft.tool.magnifying.glass");
        this.setFull3D();
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.setCreativeTab(CreativePlugin.RAILCRAFT_TAB);
    }

    public static void register() {
        String tag;
        if (item == null && RailcraftConfig.isItemEnabled(tag = "tool.magnifying.glass")) {
            item = new ItemMagnifyingGlass();
            RailcraftRegistry.register(item);
            CraftingPlugin.addShapedRecipe(new ItemStack(item), " G", "S ", Character.valueOf('S'), "stickWood", Character.valueOf('G'), "paneGlassColorless");
            LootPlugin.addLootWorkshop(new ItemStack(item), 1, 1, tag);
        }
    }

    public static ItemStack getItem() {
        if (item == null) {
            return null;
        }
        return new ItemStack(item);
    }

    @SubscribeEvent
    public void onEntityInteract(EntityInteractEvent event) {
        EntityPlayer thePlayer = event.entityPlayer;
        Entity entity = event.target;
        ItemStack stack = thePlayer.getCurrentEquippedItem();
        if (stack != null && stack.getItem() instanceof ItemMagnifyingGlass) {
            thePlayer.swingItem();
        }
        if (Game.isNotHost(thePlayer.worldObj)) {
            return;
        }
        if (stack != null && stack.getItem() instanceof ItemMagnifyingGlass && entity instanceof EntityMinecart) {
            EntityMinecart cart = (EntityMinecart)entity;
            ChatPlugin.sendLocalizedChatFromServer(thePlayer, "railcraft.gui.mag.glass.placedby", LocalizationPlugin.getEntityLocalizationTag((Entity)cart), CartTools.getCartOwner(cart));
            event.setCanceled(true);
        }
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (Game.isNotHost(world)) {
            return false;
        }
        TileEntity t = world.getTileEntity(x, y, z);
        boolean returnValue = false;
        if (t instanceof IOwnable) {
            IOwnable ownable = (IOwnable)t;
            ChatPlugin.sendLocalizedChatFromServer(player, "railcraft.gui.mag.glass.placedby", ownable.getLocalizationTag(), ownable.getOwner());
            returnValue = true;
        }
        if (t instanceof TileMultiBlock) {
            TileMultiBlock tile = (TileMultiBlock)t;
            if (tile.isStructureValid()) {
                ChatPlugin.sendLocalizedChatFromServer(player, "railcraft.multiblock.state.valid", new Object[0]);
            } else {
                for (TileMultiBlock.MultiBlockStateReturn returnState : EnumSet.complementOf(EnumSet.of(TileMultiBlock.MultiBlockStateReturn.VALID))) {
                    List pats = tile.patternStates.get((Object)returnState);
                    if (pats.isEmpty()) continue;
                    ChatPlugin.sendLocalizedChatFromServer(player, returnState.message, pats.toString());
                }
            }
            returnValue = true;
        }
        if (t instanceof IDualHeadSignal) {
            IDualHeadSignal signal = (IDualHeadSignal)t;
            SignalAspect top = signal.getTopAspect();
            SignalAspect bottom = signal.getBottomAspect();
            ChatPlugin.sendLocalizedChatFromServer(player, "railcraft.gui.mag.glass.aspect.dual", top.getLocalizationTag(), bottom.getLocalizationTag());
            returnValue = true;
        } else if (t instanceof TileSignalBase) {
            ChatPlugin.sendLocalizedChatFromServer(player, "railcraft.gui.mag.glass.aspect", ((TileSignalBase)t).getSignalAspect().getLocalizationTag());
            returnValue = true;
        }
        return returnValue;
    }
}

