/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mods.railcraft.common.blocks.RailcraftTileEntity;
import mods.railcraft.common.blocks.machine.gamma.TileLoaderBase;
import mods.railcraft.common.blocks.machine.gamma.TileLoaderFluidBase;
import mods.railcraft.common.blocks.machine.gamma.TileLoaderItemBase;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.items.ItemRailcraft;
import mods.railcraft.common.plugins.forge.ChatPlugin;
import mods.railcraft.common.plugins.forge.LocalizationPlugin;
import mods.railcraft.common.plugins.forge.RailcraftRegistry;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.inventory.PhantomInventory;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import org.apache.commons.lang3.StringUtils;

public class ItemNotepad
extends ItemRailcraft {
    public static ItemNotepad item;
    private static IIcon itemIconFull;

    public ItemNotepad() {
        this.setMaxStackSize(1);
        this.setMaxDamage(50);
    }

    public static void registerItem() {
        String tag;
        if (item == null && RailcraftConfig.isItemEnabled(tag = "railcraft.tool.notepad")) {
            item = new ItemNotepad();
            item.setUnlocalizedName(tag);
            RailcraftRegistry.register(item);
        }
    }

    private static void setPasteMode(ItemStack stack, PasteMode mode) {
        if (stack != null && stack.getItem() instanceof ItemNotepad) {
            NBTTagCompound nbt = InvTools.getItemDataRailcraft(stack);
            nbt.setByte("pasteMode", (byte)mode.ordinal());
        }
    }

    private static PasteMode getPasteMode(ItemStack stack) {
        if (stack != null && stack.getItem() instanceof ItemNotepad) {
            NBTTagCompound nbt = InvTools.getItemDataRailcraft(stack);
            return PasteMode.fromOrdinal(nbt.getByte("pasteMode"));
        }
        return PasteMode.ALL;
    }

    private static PasteMode nextPasteMode(ItemStack stack) {
        if (stack != null && stack.getItem() instanceof ItemNotepad) {
            PasteMode pasteMode = ItemNotepad.getPasteMode(stack);
            pasteMode = pasteMode.next();
            ItemNotepad.setPasteMode(stack, pasteMode);
            return pasteMode;
        }
        return PasteMode.ALL;
    }

    private static void setContents(ItemStack stack, EnumMap<Contents, NBTTagCompound> contents) {
        if (stack != null && stack.getItem() instanceof ItemNotepad) {
            NBTTagCompound contentTag = new NBTTagCompound();
            for (Map.Entry<Contents, NBTTagCompound> entry : contents.entrySet()) {
                contentTag.setTag(entry.getKey().nbtTag, (NBTBase)entry.getValue());
            }
            NBTTagCompound nbt = InvTools.getItemDataRailcraft(stack);
            nbt.setTag("contents", (NBTBase)contentTag);
        }
    }

    @Nonnull
    private static EnumMap<Contents, NBTTagCompound> getContents(ItemStack stack) {
        NBTTagCompound nbt;
        EnumMap<Contents, NBTTagCompound> contents = new EnumMap<Contents, NBTTagCompound>(Contents.class);
        if (stack != null && stack.getItem() instanceof ItemNotepad && (nbt = InvTools.getItemDataRailcraft(stack)).hasKey("contents")) {
            nbt = nbt.getCompoundTag("contents");
            for (Contents content : Contents.VALUES) {
                if (!nbt.hasKey(content.nbtTag)) continue;
                contents.put(content, nbt.getCompoundTag(content.nbtTag));
            }
        }
        return contents;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister iconRegister) {
        this.itemIcon = iconRegister.registerIcon("railcraft:tool.notepad.empty");
        itemIconFull = iconRegister.registerIcon("railcraft:tool.notepad.filled");
    }

    @Override
    public void addInformation(ItemStack stack, EntityPlayer player, List info, boolean adv) {
        String contentString;
        EnumMap<Contents, NBTTagCompound> contents = ItemNotepad.getContents(stack);
        if (contents.isEmpty()) {
            contentString = LocalizationPlugin.translate("item.railcraft.tool.notepad.tip.contents.empty");
        } else {
            ArrayList<String> contentTypes = new ArrayList<String>();
            for (Contents content : contents.keySet()) {
                contentTypes.add(LocalizationPlugin.translate(content.locTag));
            }
            contentString = StringUtils.join(contentTypes, (String)", ");
        }
        info.add(LocalizationPlugin.translate("item.railcraft.tool.notepad.tip.contents", contentString));
        PasteMode pasteMode = ItemNotepad.getPasteMode(stack);
        info.add(LocalizationPlugin.translate("item.railcraft.tool.notepad.tip.mode", EnumChatFormatting.DARK_PURPLE + pasteMode.toString()));
        super.addInformation(stack, player, info, adv);
    }

    public ItemStack onItemRightClick(ItemStack stack, World world, EntityPlayer player) {
        NBTTagCompound nbt = InvTools.getItemDataRailcraft(stack);
        if (player.isSneaking()) {
            nbt.removeTag("contents");
        } else {
            PasteMode pasteMode = ItemNotepad.nextPasteMode(stack);
            if (Game.isNotHost(world)) {
                ChatPlugin.sendLocalizedChatFromClient(player, "item.railcraft.tool.notepad.tip.mode", EnumChatFormatting.DARK_PURPLE + pasteMode.toString());
            }
        }
        return stack;
    }

    public boolean onItemUse(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        return true;
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        TileEntity tileEntity = world.getTileEntity(x, y, z);
        if (Game.isHost(world)) {
            if (player.isSneaking()) {
                EnumMap<Contents, NBTTagCompound> contents = new EnumMap<Contents, NBTTagCompound>(Contents.class);
                for (Contents contentType : Contents.VALUES) {
                    NBTTagCompound data = contentType.copy(tileEntity);
                    if (data == null) continue;
                    contents.put(contentType, data);
                }
                if (contents.isEmpty()) {
                    ChatPlugin.sendLocalizedChatFromServer(player, "item.railcraft.tool.notepad.action.copy.fail", new Object[0]);
                } else {
                    ItemNotepad.setContents(stack, contents);
                    if (tileEntity instanceof RailcraftTileEntity) {
                        ChatPlugin.sendLocalizedChatFromServer(player, "item.railcraft.tool.notepad.action.copy", ((RailcraftTileEntity)tileEntity).getLocalizationTag());
                    }
                    player.getCurrentEquippedItem().damageItem(1, (EntityLivingBase)player);
                }
            } else {
                EnumMap<Contents, NBTTagCompound> contents = ItemNotepad.getContents(stack);
                if (contents.isEmpty()) {
                    ChatPlugin.sendLocalizedChatFromServer(player, "item.railcraft.tool.notepad.action.empty", new Object[0]);
                } else {
                    PasteMode pasteMode = ItemNotepad.getPasteMode(stack);
                    boolean pasted = false;
                    for (Map.Entry<Contents, NBTTagCompound> entry : ItemNotepad.getContents(stack).entrySet()) {
                        if (!pasteMode.allows(entry.getKey())) continue;
                        pasted |= entry.getKey().paste(tileEntity, entry.getValue());
                    }
                    if (pasted) {
                        if (tileEntity instanceof RailcraftTileEntity) {
                            ChatPlugin.sendLocalizedChatFromServer(player, "item.railcraft.tool.notepad.action.paste", ((RailcraftTileEntity)tileEntity).getLocalizationTag());
                        }
                    } else {
                        ChatPlugin.sendLocalizedChatFromServer(player, "item.railcraft.tool.notepad.action.paste.fail", new Object[0]);
                    }
                }
            }
        }
        return !world.isRemote;
    }

    public boolean doesSneakBypassUse(World world, int x, int y, int z, EntityPlayer player) {
        return true;
    }

    public IIcon getIconIndex(ItemStack stack) {
        NBTTagCompound tag = InvTools.getItemDataRailcraft(stack);
        if (tag.hasKey("contents")) {
            return itemIconFull;
        }
        return this.itemIcon;
    }

    public IIcon getIcon(ItemStack stack, int renderPass, EntityPlayer player, ItemStack usingItem, int useRemaining) {
        return this.getIcon(stack, renderPass);
    }

    public IIcon getIcon(ItemStack stack, int renderPass) {
        return this.getIconIndex(stack);
    }

    private static enum PasteMode {
        ALL("item.railcraft.tool.notepad.tip.mode.all", Contents.VALUES),
        CART_FILTER("item.railcraft.tool.notepad.tip.mode.cart.filter", Contents.FILTER_CART),
        LOADER_FILTERS("item.railcraft.tool.notepad.tip.mode.loader.filters", Contents.FILTER_ITEMS, Contents.FILTER_ITEMS);

        public static final PasteMode[] VALUES;
        private final String locTag;
        private final EnumSet<Contents> allows;

        private PasteMode(String locTag, Contents ... allows) {
            this.locTag = locTag;
            this.allows = EnumSet.copyOf(Arrays.asList(allows));
        }

        public static PasteMode fromOrdinal(int id) {
            if (id < 0 || id >= VALUES.length) {
                return ALL;
            }
            return VALUES[id];
        }

        public boolean allows(Contents content) {
            return this.allows.contains((Object)content);
        }

        public String toString() {
            return LocalizationPlugin.translate(this.locTag);
        }

        public PasteMode next() {
            return VALUES[(this.ordinal() + 1) % VALUES.length];
        }

        static {
            VALUES = PasteMode.values();
        }
    }

    private static enum Contents {
        FILTER_CART("filter.cart", "item.railcraft.tool.notepad.tip.contents.filter.cart"){

            @Override
            NBTTagCompound copy(Object target) {
                if (target instanceof TileLoaderBase) {
                    PhantomInventory cartFilters = ((TileLoaderBase)target).getCartFilters();
                    NBTTagCompound nbt = new NBTTagCompound();
                    cartFilters.writeToNBT("inv", nbt);
                    return nbt;
                }
                return null;
            }

            @Override
            boolean paste(Object target, NBTTagCompound nbt) {
                if (target instanceof TileLoaderBase) {
                    ((TileLoaderBase)target).getCartFilters().readFromNBT("inv", nbt);
                    return true;
                }
                return false;
            }
        }
        ,
        FILTER_ITEMS("filter.items", "item.railcraft.tool.notepad.tip.contents.filter.items"){

            @Override
            NBTTagCompound copy(Object target) {
                if (target instanceof TileLoaderItemBase) {
                    PhantomInventory itemFilters = ((TileLoaderItemBase)target).getItemFilters();
                    NBTTagCompound nbt = new NBTTagCompound();
                    itemFilters.writeToNBT("inv", nbt);
                    return nbt;
                }
                return null;
            }

            @Override
            boolean paste(Object target, NBTTagCompound nbt) {
                if (target instanceof TileLoaderItemBase) {
                    ((TileLoaderItemBase)target).getItemFilters().readFromNBT("inv", nbt);
                    return true;
                }
                return false;
            }
        }
        ,
        FILTER_FLUID("filter.fluid", "item.railcraft.tool.notepad.tip.contents.filter.fluid"){

            @Override
            NBTTagCompound copy(Object target) {
                if (target instanceof TileLoaderFluidBase) {
                    PhantomInventory itemFilters = ((TileLoaderFluidBase)target).getFluidFilter();
                    NBTTagCompound nbt = new NBTTagCompound();
                    itemFilters.writeToNBT("inv", nbt);
                    return nbt;
                }
                return null;
            }

            @Override
            boolean paste(Object target, NBTTagCompound nbt) {
                if (target instanceof TileLoaderFluidBase) {
                    ((TileLoaderFluidBase)target).getFluidFilter().readFromNBT("inv", nbt);
                    return true;
                }
                return false;
            }
        };

        public static final Contents[] VALUES;
        private final String nbtTag;
        private final String locTag;

        private Contents(String nbtTag, String locTag) {
            this.nbtTag = nbtTag;
            this.locTag = locTag;
        }

        @Nullable
        abstract NBTTagCompound copy(Object var1);

        abstract boolean paste(Object var1, NBTTagCompound var2);

        static {
            VALUES = Contents.values();
        }
    }
}

