/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.items;

import java.util.List;
import java.util.Locale;
import mods.railcraft.api.crafting.RailcraftCraftingManager;
import mods.railcraft.common.items.IItemMetaEnum;
import mods.railcraft.common.items.ItemRailcraft;
import mods.railcraft.common.items.ItemTie;
import mods.railcraft.common.items.RailcraftItem;
import mods.railcraft.common.plugins.forge.CraftingPlugin;
import mods.railcraft.common.plugins.forge.LootPlugin;
import mods.railcraft.common.plugins.forge.RailcraftRegistry;
import mods.railcraft.common.util.crafting.RollingMachineCraftingManager;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.IIcon;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class ItemRail
extends ItemRailcraft {
    public ItemRail() {
        this.setHasSubtypes(true);
        this.setMaxDamage(0);
    }

    @Override
    public void initItem() {
        for (int meta = 0; meta < 5; ++meta) {
            ItemStack stack = new ItemStack((Item)this, 1, meta);
            RailcraftRegistry.register(stack);
            LootPlugin.addLootWorkshop(stack, 6, 18, "rail.part");
        }
    }

    @Override
    public void registerIcons(IIconRegister iconRegister) {
        for (EnumRail rail : EnumRail.VALUES) {
            rail.icon = iconRegister.registerIcon("railcraft:part.rail." + rail.name().toLowerCase(Locale.ENGLISH));
        }
    }

    public void getSubItems(Item id, CreativeTabs tab, List list) {
        for (int i = 0; i < EnumRail.VALUES.length; ++i) {
            list.add(new ItemStack((Item)this, 1, i));
        }
    }

    @Override
    public void defineRecipes() {
        RailcraftItem item = RailcraftItem.rail;
        RailcraftCraftingManager.rollingMachine.addRecipe(item.getStack(8, EnumRail.STANDARD), "I I", "I I", "I I", Character.valueOf('I'), Items.iron_ingot);
        ShapedOreRecipe recipe = new ShapedOreRecipe(item.getStack(6, EnumRail.STANDARD), new Object[]{"I I", "I I", "I I", Character.valueOf('I'), "ingotBronze"});
        RollingMachineCraftingManager.getInstance().getRecipeList().add((IRecipe)recipe);
        recipe = new ShapedOreRecipe(item.getStack(16, EnumRail.STANDARD), new Object[]{"I I", "I I", "I I", Character.valueOf('I'), "ingotSteel"});
        RollingMachineCraftingManager.getInstance().getRecipeList().add((IRecipe)recipe);
        RailcraftCraftingManager.rollingMachine.addRecipe(item.getStack(8, EnumRail.ADVANCED), "IRG", "IRG", "IRG", Character.valueOf('I'), item.getRecipeObject(EnumRail.STANDARD), Character.valueOf('R'), new ItemStack(Items.redstone), Character.valueOf('G'), new ItemStack(Items.gold_ingot));
        CraftingPlugin.addShapelessRecipe(item.getStack(6, EnumRail.WOOD), "ingotIron", RailcraftItem.tie.getRecipeObject(ItemTie.EnumTie.WOOD));
        recipe = new ShapedOreRecipe(item.getStack(8, EnumRail.SPEED), new Object[]{"IBG", "IBG", "IBG", Character.valueOf('I'), "ingotSteel", Character.valueOf('B'), Items.blaze_powder, Character.valueOf('G'), Items.gold_ingot});
        RollingMachineCraftingManager.getInstance().getRecipeList().add((IRecipe)recipe);
        recipe = new ShapedOreRecipe(item.getStack(8, EnumRail.REINFORCED), new Object[]{"IDI", "IDI", "IDI", Character.valueOf('I'), "ingotSteel", Character.valueOf('D'), "dustObsidian"});
        RollingMachineCraftingManager.getInstance().getRecipeList().add((IRecipe)recipe);
        recipe = new ShapedOreRecipe(item.getStack(6, EnumRail.ELECTRIC), new Object[]{"ICI", "ICI", "ICI", Character.valueOf('I'), item.getRecipeObject(EnumRail.STANDARD), Character.valueOf('C'), "ingotCopper"});
        RollingMachineCraftingManager.getInstance().getRecipeList().add((IRecipe)recipe);
    }

    public IIcon getIconFromDamage(int damage) {
        if (damage < 0 || damage >= EnumRail.VALUES.length) {
            return EnumRail.STANDARD.icon;
        }
        return EnumRail.VALUES[damage].icon;
    }

    public String getUnlocalizedName(ItemStack stack) {
        int damage = stack.getItemDamage();
        if (damage < 0 || damage >= EnumRail.VALUES.length) {
            return "";
        }
        switch (EnumRail.VALUES[stack.getItemDamage()]) {
            case STANDARD: {
                return "item.railcraft.part.rail.standard";
            }
            case ADVANCED: {
                return "item.railcraft.part.rail.advanced";
            }
            case WOOD: {
                return "item.railcraft.part.rail.wood";
            }
            case SPEED: {
                return "item.railcraft.part.rail.speed";
            }
            case REINFORCED: {
                return "item.railcraft.part.rail.reinforced";
            }
            case ELECTRIC: {
                return "item.railcraft.part.rail.electric";
            }
        }
        return "";
    }

    public static enum EnumRail implements IItemMetaEnum
    {
        STANDARD("ingotIron"),
        ADVANCED("ingotGold"),
        WOOD("slabWood"),
        SPEED("ingotSteel"),
        REINFORCED("ingotSteel"),
        ELECTRIC("ingotCopper");

        public static final EnumRail[] VALUES;
        private IIcon icon;
        private Object alternate;

        private EnumRail(Object alt) {
            this.alternate = alt;
        }

        @Override
        public Object getAlternate() {
            return this.alternate;
        }

        @Override
        public Class<? extends ItemRailcraft> getItemClass() {
            return ItemRail.class;
        }

        static {
            VALUES = EnumRail.values();
        }
    }
}

