/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mods.railcraft.common.gui.tooltips.ToolTip;
import mods.railcraft.common.items.IItemMetaEnum;
import mods.railcraft.common.plugins.forge.CreativePlugin;
import mods.railcraft.common.util.misc.MiscTools;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ItemRailcraft
extends Item {
    private float smeltingExperience = -1.0f;
    private int rarity = 0;

    public ItemRailcraft() {
        this.setCreativeTab(CreativePlugin.RAILCRAFT_TAB);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister iconRegister) {
        this.itemIcon = iconRegister.registerIcon("railcraft:" + MiscTools.cleanTag(this.getUnlocalizedName()));
    }

    public ItemRailcraft setRarity(int rarity) {
        this.rarity = rarity;
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity getRarity(ItemStack par1ItemStack) {
        return EnumRarity.values()[this.rarity];
    }

    public int getHeatValue(ItemStack stack) {
        return 0;
    }

    public ItemRailcraft setSmeltingExperience(float smeltingExperience) {
        this.smeltingExperience = smeltingExperience;
        return this;
    }

    public float getSmeltingExperience(ItemStack item) {
        return this.smeltingExperience;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public void addInformation(ItemStack stack, EntityPlayer player, List info, boolean adv) {
        super.addInformation(stack, player, info, adv);
        ToolTip tip = ToolTip.buildToolTip(stack.getUnlocalizedName() + ".tip", new String[0]);
        if (tip != null) {
            info.addAll(tip.convertToStrings());
        }
    }

    public Object getRecipeObject(IItemMetaEnum meta) {
        this.assertMeta(meta);
        String oreTag = this.getOreTag(meta);
        if (oreTag != null) {
            return oreTag;
        }
        if (meta != null && this.getHasSubtypes()) {
            return new ItemStack((Item)this, 1, meta.ordinal());
        }
        return this;
    }

    public String getOreTag(IItemMetaEnum meta) {
        return null;
    }

    protected void assertMeta(IItemMetaEnum meta) {
        if (meta != null && meta.getItemClass() != ((Object)((Object)this)).getClass()) {
            throw new RuntimeException("Incorrect Item Meta object used.");
        }
    }

    public void defineRecipes() {
    }

    public void definePostRecipes() {
    }

    public void initItem() {
    }
}

